/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.routing.expression;

import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.util.routing.RouterBlockEntity;

@FunctionalInterface
public interface Expression {
    public static final Expression FALSE = (router, rollingStock) -> false;
    public static final Expression TRUE = (router, rollingStock) -> true;

    public boolean evaluate(RouterBlockEntity var1, RollingStock var2);

    default public Expression negate() {
        return (router, rollingStock) -> !this.evaluate(router, rollingStock);
    }

    default public Expression and(Expression other) {
        return (router, rollingStock) -> this.evaluate(router, rollingStock) && other.evaluate(router, rollingStock);
    }

    default public Expression or(Expression other) {
        return (router, rollingStock) -> this.evaluate(router, rollingStock) || other.evaluate(router, rollingStock);
    }

    default public Expression select(Expression success, Expression fail) {
        return (router, rollingStock) -> this.evaluate(router, rollingStock) ? success.evaluate(router, rollingStock) : fail.evaluate(router, rollingStock);
    }
}

