/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.item.MinecartFactory;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.item.CartItem;
import mods.railcraft.world.level.material.FluidItemHelper;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StemBlock;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public enum StackFilter implements Predicate<ItemStack>
{
    FUEL(itemStack -> ForgeHooks.getBurnTime((ItemStack)itemStack, null) > 0),
    TRACK(TrackUtil::isRail),
    MINECART(itemStack -> {
        Item item = itemStack.m_41720_();
        return item instanceof MinecartItem || item instanceof MinecartFactory || item instanceof CartItem;
    }),
    BALLAST(itemStack -> {
        BlockItem blockItem;
        Item patt1561$temp = itemStack.m_41720_();
        return patt1561$temp instanceof BlockItem && (blockItem = (BlockItem)patt1561$temp).m_40614_().m_204297_().m_203656_(RailcraftTags.Blocks.BALLAST);
    }),
    FLUID_CONTAINER(itemStack -> itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()),
    FEED(itemStack -> {
        BlockItem blockItem;
        Item patt1949$temp;
        return itemStack.m_41720_().getFoodProperties(itemStack, null) != null || itemStack.m_150930_(Items.f_42405_) || (patt1949$temp = itemStack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)patt1949$temp).m_40614_() instanceof StemBlock;
    }),
    CARGO(itemStack -> ((Boolean)RailcraftConfig.SERVER.chestAllowFluids.get() != false || !FluidItemHelper.isContainer(itemStack)) && !((List)RailcraftConfig.SERVER.cargoBlacklist.get()).contains(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString())),
    RAW_METAL(itemStack -> itemStack.m_204117_(RailcraftTags.Items.METAL));

    private final Predicate<ItemStack> predicate;

    private StackFilter(Predicate<ItemStack> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return !itemStack.m_41619_() && this.predicate.test(itemStack);
    }

    public static Predicate<ItemStack> of(Class<?> itemClass) {
        return itemStack -> !itemStack.m_41619_() && itemClass.isAssignableFrom(itemStack.m_41720_().getClass());
    }

    public static Predicate<ItemStack> of(Item item) {
        return itemStack -> !itemStack.m_41619_() && itemStack.m_150930_(item);
    }

    public static Predicate<ItemStack> of(Block block) {
        return itemStack -> !itemStack.m_41619_() && itemStack.m_150930_(block.m_5456_());
    }

    public static Predicate<ItemStack> anyMatch(ItemStack ... filters) {
        return StackFilter.anyMatch(Arrays.asList(filters));
    }

    public static Predicate<ItemStack> anyMatch(Collection<ItemStack> filters) {
        return itemStack -> filters.stream().anyMatch(f -> ContainerTools.matchesFilter(f, itemStack));
    }

    public static Predicate<ItemStack> anyMatch(ContainerManipulator<?> inv) {
        return itemStack -> inv.streamItems().anyMatch(f -> ContainerTools.matchesFilter(f, itemStack));
    }

    public static Predicate<ItemStack> none() {
        return itemStack -> false;
    }

    public static Predicate<ItemStack> noneOf(ItemStack ... stacks) {
        return StackFilter.noneOf(Arrays.asList(stacks));
    }

    public static Predicate<ItemStack> noneOf(Collection<ItemStack> stacks) {
        return itemStack -> {
            if (itemStack.m_41619_()) {
                return false;
            }
            return stacks.stream().filter(toTest -> !toTest.m_41619_()).noneMatch(filter -> ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)filter));
        };
    }

    public static Predicate<ItemStack> ofSize(int size) {
        return itemStack -> itemStack.m_41613_() == size;
    }

    public static Predicate<ItemStack> singleton() {
        return itemStack -> itemStack.m_41613_() == 1;
    }

    public static Predicate<ItemStack> nonEmpty() {
        return itemStack -> !itemStack.m_41619_();
    }

    public static Predicate<ItemStack> isCart(@Nullable AbstractMinecart cart) {
        return itemStack -> {
            if (itemStack.m_41619_()) {
                return false;
            }
            if (cart == null) {
                return false;
            }
            ItemStack cartItem = cart.m_142340_();
            boolean matches = ItemStack.m_41656_((ItemStack)cartItem, (ItemStack)itemStack);
            if (itemStack.m_41788_()) {
                return matches && itemStack.m_41611_().m_214077_().equals(cartItem.m_41611_().m_214077_());
            }
            return matches;
        };
    }
}

