/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import mods.railcraft.api.item.ActivationBlockingItem;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.util.ReflectionUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class PlayerUtil {
    public static Component getUsername(Level level, @NotNull GameProfile gameProfile) {
        Player player;
        UUID playerId = gameProfile.getId();
        if (playerId != null && (player = level.m_46003_(playerId)) != null) {
            return player.m_5446_();
        }
        String username = gameProfile.getName();
        return Component.m_237113_((String)(StringUtils.isEmpty((CharSequence)username) ? "[unknown]" : username));
    }

    public static boolean isOwnerOrOp(GameProfile owner, Player player) {
        return player.m_36316_().equals((Object)owner) || player.m_20310_(2);
    }

    public static boolean isSamePlayer(GameProfile a, GameProfile b) {
        if (a.isComplete() && b.isComplete()) {
            return a.equals((Object)b);
        }
        if (a.getId() != null && b.getId() != null) {
            return a.getId().equals(b.getId());
        }
        return a.getName() != null && a.getName().equals(b.getName());
    }

    public static boolean doesItemBlockActivation(Player player, InteractionHand hand) {
        if (player.m_6144_() || hand == InteractionHand.OFF_HAND) {
            return true;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_()) {
            return TrackUtil.isRail(heldItem) || ReflectionUtil.isAnnotatedDeepSearch(ActivationBlockingItem.class, heldItem.m_41720_());
        }
        return false;
    }
}

