/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.Function;
import mods.railcraft.Railcraft;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.renderer.blockentity.SignalAuraRenderUtil;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import mods.railcraft.world.level.block.signal.SignalBoxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public abstract class AbstractSignalBoxRenderer
implements BlockEntityRenderer<AbstractSignalBoxBlockEntity> {
    private static final Map<SignalAspect, ResourceLocation> ASPECT_TEXTURE_LOCATIONS = Map.of(SignalAspect.OFF, Railcraft.rl("entity/signal_box_aspect/off"), SignalAspect.RED, Railcraft.rl("entity/signal_box_aspect/red"), SignalAspect.YELLOW, Railcraft.rl("entity/signal_box_aspect/yellow"), SignalAspect.GREEN, Railcraft.rl("entity/signal_box_aspect/green"));
    private static final ResourceLocation SIDE_TEXTURE_LOCATION = Railcraft.rl("entity/signal_box/side");
    private static final ResourceLocation CONNECTED_SIDE_TEXTURE_LOCATION = Railcraft.rl("entity/signal_box/connected_side");
    private static final ResourceLocation BOTTOM_TEXTURE_LOCATION = Railcraft.rl("entity/signal_box/bottom");
    private final CuboidModel model = new CuboidModel(0.125f, 0.0f, 0.125f, 0.875f, 0.9375f, 0.875f);

    protected abstract ResourceLocation getTopTextureLocation();

    public int m_142163_() {
        return 512;
    }

    public void render(AbstractSignalBoxBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        SignalAuraRenderUtil.tryRenderSignalAura(blockEntity, poseStack, bufferSource);
        if (blockEntity.m_8077_()) {
            RenderUtil.renderBlockHoverText(blockEntity.m_58899_(), blockEntity.m_7770_(), poseStack, bufferSource, packedLight);
        }
        Function spriteGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        this.model.setPackedLight(packedLight);
        this.model.setPackedOverlay(packedOverlay);
        this.model.set(Direction.UP, new CuboidModel.Face(this.model).setSprite((TextureAtlasSprite)spriteGetter.apply(this.getTopTextureLocation())).setSize(16));
        this.model.set(Direction.DOWN, new CuboidModel.Face(this.model).setSprite((TextureAtlasSprite)spriteGetter.apply(BOTTOM_TEXTURE_LOCATION)).setSize(16));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean isConnected = SignalBoxBlock.isConnected(blockEntity.m_58900_(), direction);
            this.model.set(direction, new CuboidModel.Face(this.model).setSprite((TextureAtlasSprite)spriteGetter.apply(isConnected ? CONNECTED_SIDE_TEXTURE_LOCATION : SIDE_TEXTURE_LOCATION)).setSize(16));
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)InventoryMenu.f_39692_));
        CuboidModelRenderer.render(this.model, poseStack, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (SignalBoxBlock.isConnected(blockEntity.m_58900_(), direction)) {
                this.model.disable(direction);
                continue;
            }
            SignalAspect aspect = blockEntity.getSignalAspect(direction).getDisplayAspect();
            int skyLight = LightTexture.m_109894_((int)packedLight);
            int facePackedLight = LightTexture.m_109885_((int)aspect.getLampLight(), (int)skyLight);
            this.model.set(direction, new CuboidModel.Face(this.model).setSprite((TextureAtlasSprite)spriteGetter.apply(ASPECT_TEXTURE_LOCATIONS.get((Object)aspect))).setSize(16).setPackedLight(facePackedLight).setPackedOverlay(packedOverlay));
        }
        CuboidModelRenderer.render(this.model, poseStack, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
    }
}

