/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetLauncherTrackAttributesMessage;
import mods.railcraft.world.level.block.entity.track.LauncherTrackBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class LauncherTrackScreen
extends IngameWindowScreen {
    private final LauncherTrackBlockEntity track;

    public LauncherTrackScreen(LauncherTrackBlockEntity track) {
        super((Component)track.m_58900_().m_60734_().m_49954_());
        this.track = track;
    }

    public void m_7856_() {
        int centredX = (this.f_96543_ - this.windowWidth) / 2;
        int centredY = (this.f_96544_ - this.windowHeight) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-10"), __ -> this.incrementForce(-10)).m_252987_(centredX + 13, centredY + 50, 30, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-1"), __ -> this.incrementForce(-1)).m_252987_(centredX + 53, centredY + 50, 30, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+1"), __ -> this.incrementForce(1)).m_252987_(centredX + 93, centredY + 50, 30, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+10"), __ -> this.incrementForce(10)).m_252987_(centredX + 133, centredY + 50, 30, 20).m_253136_());
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent componentForce = Component.m_237110_((String)Translations.Screen.LAUNCHER_TRACK_LAUNCH_FORCE, (Object[])new Object[]{this.track.getLaunchForce()});
        GuiUtil.drawCenteredString(guiGraphics, this.f_96547_, (Component)componentForce, this.windowWidth, 25);
    }

    private void incrementForce(int incrementAmount) {
        byte force = (byte)Mth.m_14045_((int)(this.track.getLaunchForce() + incrementAmount), (int)5, (int)((Integer)RailcraftConfig.SERVER.maxLauncherTrackForce.get()));
        if (this.track.getLaunchForce() != force) {
            this.track.setLaunchForce(force);
            this.sendAttributes();
        }
    }

    private void sendAttributes() {
        NetworkChannel.GAME.sendToServer(new SetLauncherTrackAttributesMessage(this.track.m_58899_(), this.track.getLaunchForce()));
    }
}

