/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.track;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import mods.railcraft.api.core.RailcraftFakePlayer;
import mods.railcraft.api.item.TrackPlacer;
import mods.railcraft.api.item.TrackTypeLike;
import mods.railcraft.api.track.LockingTrack;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class TrackUtil {
    private TrackUtil() {
    }

    public static BlockState setShape(BaseRailBlock block, @Nullable RailShape trackShape) {
        Property property = block.m_7978_();
        BlockState state = block.m_49966_();
        if (trackShape != null && property.m_6908_().contains(trackShape)) {
            state = (BlockState)state.m_61124_(property, (Comparable)trackShape);
        }
        return state;
    }

    public static boolean placeRailAt(ItemStack stack, ServerLevel level, BlockPos pos, RailShape railShape) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        if (item instanceof TrackPlacer) {
            TrackPlacer placer = (TrackPlacer)item;
            return placer.placeTrack(stack.m_41777_(), (Player)RailcraftFakePlayer.get(level, pos.m_121945_(Direction.UP)), (Level)level, pos, railShape);
        }
        Item item2 = stack.m_41720_();
        if (item2 instanceof BlockItem && (item2 = (blockItem = (BlockItem)item2).m_40614_()) instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)item2;
            BlockState blockState = TrackUtil.setShape(railBlock, railShape);
            boolean success = level.m_46597_(pos, blockState);
            if (success) {
                SoundType soundType = railBlock.getSoundType(blockState, (LevelReader)level, pos, null);
                level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
            return success;
        }
        return false;
    }

    public static boolean placeRailAt(ItemStack stack, ServerLevel level, BlockPos pos) {
        return TrackUtil.placeRailAt(stack, level, pos, RailShape.NORTH_SOUTH);
    }

    public static boolean isTrackItem(@Nullable ItemStack stack) {
        return stack != null && stack.m_41720_() instanceof TrackPlacer;
    }

    public static boolean isCartLocked(AbstractMinecart cart) {
        LockingTrack lockingTrack;
        BlockState blockState;
        Block block;
        BlockPos pos = cart.m_20183_();
        if (BaseRailBlock.m_49364_((Level)cart.m_9236_(), (BlockPos)pos.m_7495_())) {
            pos = pos.m_7495_();
        }
        return (block = (blockState = cart.m_9236_().m_8055_(pos)).m_60734_()) instanceof LockingTrack && (lockingTrack = (LockingTrack)block).isCartLocked(cart);
    }

    public static int countAdjacentTracks(Level level, BlockPos pos) {
        return (int)Direction.Plane.HORIZONTAL.m_122557_().filter(side -> TrackUtil.isTrackFuzzyAt(level, pos.m_121945_(side))).count();
    }

    public static boolean isTrackFuzzyAt(Level level, BlockPos pos) {
        return BaseRailBlock.m_49364_((Level)level, (BlockPos)pos) || BaseRailBlock.m_49364_((Level)level, (BlockPos)pos.m_7494_()) || BaseRailBlock.m_49364_((Level)level, (BlockPos)pos.m_7495_());
    }

    public static TrackType getTrackType(ItemStack stack) {
        TrackType trackType;
        Item item = stack.m_41720_();
        if (item instanceof TrackTypeLike) {
            TrackTypeLike trackTypeLike = (TrackTypeLike)item;
            trackType = trackTypeLike.getTrackType(stack);
        } else {
            trackType = null;
        }
        return trackType;
    }

    public static boolean isStraightTrackAt(BlockGetter level, BlockPos pos) {
        return BaseRailBlock.m_49416_((BlockState)level.m_8055_(pos)) && !RailShapeUtil.isTurn(TrackUtil.getTrackDirection(level, pos));
    }

    public static boolean isRail(ItemStack stack) {
        return TrackUtil.isRail(stack.m_41720_());
    }

    public static boolean isRail(Item item) {
        BlockItem blockItem;
        return item instanceof TrackPlacer || item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof BaseRailBlock && blockItem.m_40614_().m_204297_().m_203656_(BlockTags.f_13034_);
    }

    public static RailShape getTrackDirection(BlockGetter level, BlockPos pos, BlockState state) {
        return TrackUtil.getTrackDirection(level, pos, state, null);
    }

    public static RailShape getTrackDirection(BlockGetter level, BlockPos pos) {
        return TrackUtil.getTrackDirection(level, pos, (AbstractMinecart)null);
    }

    public static RailShape getTrackDirection(BlockGetter level, BlockPos pos, @Nullable AbstractMinecart cart) {
        return TrackUtil.getTrackDirection(level, pos, level.m_8055_(pos), cart);
    }

    public static RailShape getTrackDirection(BlockGetter level, BlockPos pos, BlockState state, @Nullable AbstractMinecart cart) {
        return TrackUtil.asRailBlock(state.m_60734_()).getRailDirection(state, level, pos, cart);
    }

    public static RailShape getRailShapeRaw(BlockGetter level, BlockPos pos) {
        return TrackUtil.getRailShapeRaw(level.m_8055_(pos));
    }

    public static RailShape getRailShapeRaw(BlockState blockState) {
        return (RailShape)blockState.m_61143_(TrackUtil.getRailShapeProperty(blockState.m_60734_()));
    }

    public static Property<RailShape> getRailShapeProperty(Block block) {
        return TrackUtil.asRailBlock(block).m_7978_();
    }

    public static BaseRailBlock asRailBlock(Block block) {
        if (block instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)block;
            return railBlock;
        }
        throw new IllegalArgumentException(ForgeRegistries.BLOCKS.getKey((Object)block).toString() + " is not a rail block.");
    }

    public static boolean setRailShape(Level level, BlockPos pos, RailShape railShape) {
        BlockState blockState = level.m_8055_(pos);
        Property<RailShape> prop = TrackUtil.getRailShapeProperty(blockState.m_60734_());
        if (!prop.m_6908_().contains(railShape)) {
            return false;
        }
        blockState = (BlockState)blockState.m_61124_(prop, (Comparable)railShape);
        return level.m_46597_(pos, blockState);
    }

    public static void traverseConnectedTracks(Level level, BlockPos pos, BiFunction<Level, BlockPos, Boolean> action) {
        TrackUtil.traverseConnectedTracks(level, pos, action, new HashSet<BlockPos>());
    }

    private static void traverseConnectedTracks(Level level, BlockPos pos, BiFunction<Level, BlockPos, Boolean> action, Set<BlockPos> visited) {
        visited.add(pos);
        if (!action.apply(level, pos).booleanValue()) {
            return;
        }
        TrackUtil.getConnectedTracks((LevelReader)level, pos).stream().filter(p -> !visited.contains(p)).forEach(p -> TrackUtil.traverseConnectedTracks(level, p, action, visited));
    }

    public static Set<BlockPos> getConnectedTracks(LevelReader level, BlockPos pos) {
        RailShape shape = BaseRailBlock.m_49416_((BlockState)level.m_8055_(pos)) ? TrackUtil.getRailShapeRaw((BlockGetter)level, pos) : RailShape.NORTH_SOUTH;
        return Direction.Plane.HORIZONTAL.m_122557_().flatMap(side -> TrackUtil.getTrackConnectedTrackAt(level, pos.m_121945_(side), shape).stream()).collect(Collectors.toSet());
    }

    public static Optional<BlockPos> getTrackConnectedTrackAt(LevelReader level, BlockPos pos, RailShape shape) {
        if (BaseRailBlock.m_49416_((BlockState)level.m_8055_(pos))) {
            return Optional.of(pos);
        }
        BlockPos up = pos.m_7494_();
        if (shape.m_61745_() && BaseRailBlock.m_49416_((BlockState)level.m_8055_(up))) {
            return Optional.of(up);
        }
        BlockPos down = pos.m_7495_();
        if (BaseRailBlock.m_49416_((BlockState)level.m_8055_(down)) && TrackUtil.getRailShapeRaw((BlockGetter)level, down).m_61745_()) {
            return Optional.of(down);
        }
        return Optional.empty();
    }

    public static RailShape getAxisAlignedDirection(Direction.Axis axis) {
        return switch (axis) {
            case Direction.Axis.X -> RailShape.EAST_WEST;
            case Direction.Axis.Z -> RailShape.NORTH_SOUTH;
            default -> throw new IllegalArgumentException("No corresponding direction for other axes.");
        };
    }

    public static RailShape getAxisAlignedDirection(Direction facing) {
        return TrackUtil.getAxisAlignedDirection(facing.m_122434_());
    }

    public static Optional<Direction> getSideFacingTrack(Level level, BlockPos pos) {
        return Arrays.stream(Direction.values()).filter(dir -> BaseRailBlock.m_49364_((Level)level, (BlockPos)pos.m_121945_(dir))).findFirst();
    }
}

