/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.google.gson.JsonObject;
import mods.railcraft.Railcraft;
import mods.railcraft.util.JsonUtil;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class UseTrackKitTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = Railcraft.rl("use_track_kit");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
        ItemPredicate used = JsonUtil.getAsJsonObject(json, "item").map(ItemPredicate::m_45051_).orElse(ItemPredicate.f_45028_);
        LocationPredicate location = JsonUtil.getAsJsonObject(json, "location").map(LocationPredicate::m_52629_).orElse(LocationPredicate.f_52592_);
        return new Instance(contextAwarePredicate, used, location);
    }

    public void trigger(ServerPlayer playerEntity, ServerLevel serverLevel, BlockPos blockPos, ItemStack stack) {
        this.m_66234_(playerEntity, criterionInstance -> criterionInstance.matches(serverLevel, blockPos, stack));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final LocationPredicate location;

        private Instance(ContextAwarePredicate contextAwarePredicate, ItemPredicate itemPredicate, LocationPredicate locationPredicate) {
            super(ID, contextAwarePredicate);
            this.item = itemPredicate;
            this.location = locationPredicate;
        }

        public static Instance hasUsedTrackKit() {
            return new Instance(ContextAwarePredicate.f_285567_, ItemPredicate.f_45028_, LocationPredicate.f_52592_);
        }

        public boolean matches(ServerLevel level, BlockPos blockPos, ItemStack stack) {
            return this.item.m_45049_(stack) && this.location.m_52617_(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject json = new JsonObject();
            json.add("item", this.item.m_45048_());
            json.add("location", this.location.m_52616_());
            return json;
        }
    }
}

