/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeNBTChangerRecipe;
import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.common.recipe.ItemConversionRecipe;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeHelper {
    private static final Map<String, List<BlockConversionRecipe>> blockConversionRecipeMap = new HashMap<String, List<BlockConversionRecipe>>();
    private static final Map<String, List<ItemConversionRecipe>> itemConversionRecipeMap = new HashMap<String, List<ItemConversionRecipe>>();
    private static final Map<String, List<BeeNBTChangerRecipe>> nbtChangerRecipeMap = new HashMap<String, List<BeeNBTChangerRecipe>>();

    public static Entity itemInteract(Bee entity, ItemStack itemStack, ServerLevel level, CompoundTag nbt, Player player) {
        Entity bee = null;
        if (!entity.m_6162_()) {
            IdentifierInventory beeInv = new IdentifierInventory(entity, "" + ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()));
            ArrayList<BeeConversionRecipe> recipes = new ArrayList<BeeConversionRecipe>();
            Map allRecipes = level.m_7465_().m_44054_((RecipeType)ModRecipeTypes.BEE_CONVERSION_TYPE.get());
            for (Map.Entry entry : allRecipes.entrySet()) {
                BeeConversionRecipe recipe = (BeeConversionRecipe)entry.getValue();
                if (!recipe.m_5818_(beeInv, (Level)level)) continue;
                recipes.add(recipe);
            }
            if (!recipes.isEmpty()) {
                BeeConversionRecipe recipe = (BeeConversionRecipe)recipes.get(level.f_46441_.m_188503_(recipes.size()));
                if (level.f_46441_.m_188503_(100) < recipe.chance) {
                    bee = ((BeeIngredient)recipe.result.get()).getBeeEntity().m_20615_((Level)level);
                    if (bee instanceof ConfigurableBee) {
                        ((ConfigurableBee)bee).setBeeType(((BeeIngredient)recipe.result.get()).getBeeType().toString());
                        ((ConfigurableBee)bee).setDefaultAttributes();
                    }
                    if (bee instanceof ProductiveBee && entity instanceof ProductiveBee) {
                        BeeHelper.setOffspringAttributes((ProductiveBee)bee, (ProductiveBee)entity, (AgeableMob)entity);
                    }
                }
            }
        }
        if (bee != null) {
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            BlockPos pos = entity.m_20183_();
            bee.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
            if (bee instanceof LivingEntity) {
                ((LivingEntity)bee).m_21153_(entity.m_21223_());
                ((LivingEntity)bee).f_20883_ = entity.f_20883_;
            }
            if (bee instanceof Animal && entity.m_146764_() > 0) {
                ((Animal)bee).m_146762_(entity.m_146764_());
            }
            return bee;
        }
        return null;
    }

    @Nullable
    public static Entity getBreedingResult(Bee beeEntity, AgeableMob targetEntity, ServerLevel world) {
        ResourceLocation type;
        CompoundTag nbt;
        BeeIngredient beeIngredient;
        BeeBreedingRecipe recipe = BeeHelper.getRandomBreedingRecipe(beeEntity, targetEntity, world);
        if (recipe != null && recipe.offspring != null && (beeIngredient = (BeeIngredient)recipe.offspring.get()) != null) {
            Entity newBee = beeIngredient.getBeeEntity().m_20615_((Level)world);
            if (newBee instanceof ConfigurableBee) {
                ((ConfigurableBee)newBee).setBeeType(beeIngredient.getBeeType().toString());
                ((ConfigurableBee)newBee).setDefaultAttributes();
            }
            return newBee;
        }
        if (beeEntity instanceof ProductiveBee && !((ProductiveBee)beeEntity).canSelfBreed() || targetEntity instanceof ProductiveBee && !((ProductiveBee)targetEntity).canSelfBreed()) {
            return null;
        }
        if (beeEntity instanceof ConfigurableBee && (nbt = BeeReloadListener.INSTANCE.getData((type = new ResourceLocation(((ConfigurableBee)beeEntity).getBeeType())).toString())) != null && ((ConfigurableBee)beeEntity).canSelfBreed()) {
            ConfigurableBee newBee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_((Level)world);
            newBee.setBeeType(type.toString());
            newBee.setDefaultAttributes();
            return newBee;
        }
        if (beeEntity != null && (!(beeEntity instanceof ProductiveBee) || ((ProductiveBee)beeEntity).canSelfBreed())) {
            return ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(beeEntity.m_20078_()))).m_20615_((Level)world);
        }
        return null;
    }

    public static BeeBreedingRecipe getRandomBreedingRecipe(Bee beeEntity, AgeableMob targetEntity, ServerLevel level) {
        List<BeeBreedingRecipe> recipes = BeeHelper.getBreedingRecipes(beeEntity, targetEntity, level);
        if (!recipes.isEmpty()) {
            return recipes.get(level.f_46441_.m_188503_(recipes.size()));
        }
        return null;
    }

    public static List<BeeBreedingRecipe> getBreedingRecipes(Bee beeEntity, AgeableMob targetEntity, ServerLevel level) {
        ProductiveBee peeBee;
        IdentifierInventory beeInv = new IdentifierInventory(beeEntity, (Bee)targetEntity);
        ArrayList<BeeBreedingRecipe> recipes = new ArrayList<BeeBreedingRecipe>();
        Map allRecipes = level.m_7465_().m_44054_((RecipeType)ModRecipeTypes.BEE_BREEDING_TYPE.get());
        for (Map.Entry entry : allRecipes.entrySet()) {
            BeeBreedingRecipe recipe = (BeeBreedingRecipe)entry.getValue();
            if (!recipe.m_5818_(beeInv, (Level)level)) continue;
            recipes.add(recipe);
        }
        if (beeEntity.m_6095_().equals(targetEntity.m_6095_()) && (!(beeEntity instanceof ProductiveBee) || (peeBee = (ProductiveBee)beeEntity).canSelfBreed() && peeBee.getBeeType().equals(((ProductiveBee)targetEntity).getBeeType()))) {
            Lazy beeIngredient = Lazy.of(BeeIngredientFactory.getIngredient(beeInv.getIdentifier()));
            recipes.add(new BeeBreedingRecipe(new ResourceLocation("productivebees", "bee_breeding_" + new ResourceLocation(beeInv.getIdentifier()).m_135815_() + "_self"), List.of(beeIngredient, beeIngredient), (Lazy<BeeIngredient>)beeIngredient));
        }
        return recipes;
    }

    public static BlockConversionRecipe getBlockConversionRecipe(Bee beeEntity, BlockState flowerBlockState) {
        List<Object> recipes = new ArrayList();
        BlockStateInventory beeInv = new BlockStateInventory(beeEntity, flowerBlockState);
        String cacheKey = beeInv.getIdentifier(0) + beeInv.getIdentifier(1);
        if (blockConversionRecipeMap.containsKey(cacheKey)) {
            recipes = blockConversionRecipeMap.get(cacheKey);
        } else if (beeEntity.m_9236_() instanceof ServerLevel) {
            List allRecipes = beeEntity.m_9236_().m_7465_().m_44013_((RecipeType)ModRecipeTypes.BLOCK_CONVERSION_TYPE.get());
            for (BlockConversionRecipe recipe : allRecipes) {
                if (!recipe.m_5818_(beeInv, beeEntity.m_9236_())) continue;
                recipes.add(recipe);
            }
            blockConversionRecipeMap.put(cacheKey, recipes);
        }
        if (!recipes.isEmpty()) {
            return (BlockConversionRecipe)recipes.get(beeEntity.m_9236_().f_46441_.m_188503_(recipes.size()));
        }
        return null;
    }

    public static boolean hasBlockConversionRecipe(Bee beeEntity, BlockState flowerBlockState) {
        return BeeHelper.getBlockConversionRecipe(beeEntity, flowerBlockState) != null;
    }

    public static ItemConversionRecipe getItemConversionRecipe(Bee beeEntity, ItemStack item) {
        List<Object> recipes = new ArrayList();
        ItemInventory beeInv = new ItemInventory(beeEntity, item);
        String cacheKey = beeInv.getIdentifier(0) + beeInv.getIdentifier(1);
        if (itemConversionRecipeMap.containsKey(cacheKey)) {
            recipes = itemConversionRecipeMap.get(cacheKey);
        } else if (beeEntity.m_9236_() instanceof ServerLevel) {
            List allRecipes = beeEntity.m_9236_().m_7465_().m_44013_((RecipeType)ModRecipeTypes.ITEM_CONVERSION_TYPE.get());
            for (ItemConversionRecipe recipe : allRecipes) {
                if (!recipe.m_5818_(beeInv, beeEntity.m_9236_())) continue;
                recipes.add(recipe);
            }
            itemConversionRecipeMap.put(cacheKey, recipes);
        }
        if (!recipes.isEmpty()) {
            return (ItemConversionRecipe)recipes.get(beeEntity.m_9236_().f_46441_.m_188503_(recipes.size()));
        }
        return null;
    }

    public static boolean hasItemConversionRecipe(Bee beeEntity, ItemStack item) {
        return BeeHelper.getItemConversionRecipe(beeEntity, item) != null;
    }

    public static BeeNBTChangerRecipe getNBTChangerRecipe(Bee beeEntity, ItemStack item) {
        List<Object> recipes = new ArrayList();
        ItemInventory inv = new ItemInventory(beeEntity, item);
        String cacheKey = inv.getIdentifier(0) + inv.getIdentifier(1);
        if (nbtChangerRecipeMap.containsKey(cacheKey)) {
            recipes = nbtChangerRecipeMap.get(cacheKey);
        } else if (beeEntity.m_9236_() instanceof ServerLevel) {
            List allRecipes = beeEntity.m_9236_().m_7465_().m_44013_((RecipeType)ModRecipeTypes.BEE_NBT_CHANGER_TYPE.get());
            for (BeeNBTChangerRecipe recipe : allRecipes) {
                if (!recipe.m_5818_(inv, beeEntity.m_9236_())) continue;
                recipes.add(recipe);
            }
            nbtChangerRecipeMap.put(cacheKey, recipes);
        }
        if (!recipes.isEmpty()) {
            return (BeeNBTChangerRecipe)recipes.get(beeEntity.m_9236_().f_46441_.m_188503_(recipes.size()));
        }
        return null;
    }

    public static boolean hasNBTChangerRecipe(Bee beeEntity, ItemStack item) {
        return BeeHelper.getNBTChangerRecipe(beeEntity, item) != null;
    }

    public static List<ItemStack> getBeeProduce(Level level, Bee beeEntity, boolean hasCombBlockUpgrade, double modifier) {
        AdvancedBeehiveRecipe matchedRecipe = null;
        BlockPos flowerPos = beeEntity.m_27851_();
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        String beeId = beeEntity.m_20078_();
        if (beeId == null) {
            return outputList;
        }
        if (beeEntity instanceof ConfigurableBee) {
            beeId = ((ConfigurableBee)beeEntity).getBeeType();
        }
        Map allRecipes = level.m_7465_().m_44054_((RecipeType)ModRecipeTypes.ADVANCED_BEEHIVE_TYPE.get());
        IdentifierInventory beeInv = new IdentifierInventory(beeId);
        for (Map.Entry entry : allRecipes.entrySet()) {
            AdvancedBeehiveRecipe recipe = (AdvancedBeehiveRecipe)entry.getValue();
            if (!recipe.m_5818_(beeInv, level)) continue;
            matchedRecipe = recipe;
        }
        int rolls = Math.max(1, (int)modifier);
        if (matchedRecipe != null) {
            matchedRecipe.getRecipeOutputs().forEach((itemStack, bounds) -> {
                for (int i = 0; i < rolls; ++i) {
                    if (level.f_46441_.m_188503_(100) > bounds.get(2).m_7047_()) continue;
                    ItemStack stack = itemStack.m_41777_();
                    int count = Mth.m_216271_((RandomSource)level.f_46441_, (int)Mth.m_14143_((float)bounds.get(0).m_7047_()), (int)Mth.m_14143_((float)bounds.get(1).m_7047_()));
                    if (hasCombBlockUpgrade && itemStack.m_41720_() instanceof HoneycombItem) {
                        stack = BeeHelper.getCombBlockFromHoneyComb(itemStack);
                    }
                    stack.m_41764_(count);
                    outputList.add(stack);
                }
            });
        } else if (beeId.equals("productivebees:lumber_bee")) {
            if (flowerPos != null && (flowerBlock = BeeHelper.getFloweringBlockFromTag(level, flowerPos, ModTags.LUMBER, (ProductiveBee)beeEntity)) != null && !flowerBlock.m_204297_().m_203656_(ModTags.DUPE_BLACKLIST)) {
                outputList.add(new ItemStack((ItemLike)flowerBlock.m_5456_(), rolls));
            }
        } else if (beeId.equals("productivebees:quarry_bee")) {
            if (flowerPos != null && (flowerBlock = BeeHelper.getFloweringBlockFromTag(level, flowerPos, ModTags.QUARRY, (ProductiveBee)beeEntity)) != null && !flowerBlock.m_204297_().m_203656_(ModTags.DUPE_BLACKLIST)) {
                outputList.add(new ItemStack((ItemLike)flowerBlock.m_5456_(), rolls));
            }
        } else if (beeId.equals("productivebees:dye_bee")) {
            Item flowerItem;
            ItemStack dye;
            if (flowerPos != null && (flowerBlock = BeeHelper.getFloweringBlockFromTag(level, flowerPos, (TagKey<Block>)BlockTags.f_13041_, (ProductiveBee)beeEntity)) != null && !(dye = BeeHelper.getRecipeOutputFromInput(level, flowerItem = flowerBlock.m_5456_())).m_41619_()) {
                dye.m_41764_(rolls);
                outputList.add(dye);
            }
        } else if (beeId.equals("productivebees:wanna") && flowerPos != null && level instanceof ServerLevel) {
            FeederBlockEntity feederBlockEntity;
            ItemStack amberItem;
            CompoundTag tag;
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = null;
            BlockEntity blockEntity = level.m_7702_(flowerPos);
            if (blockEntity instanceof AmberBlockEntity) {
                AmberBlockEntity amberBlockEntity = (AmberBlockEntity)blockEntity;
                entity = amberBlockEntity.getCachedEntity();
            } else if (blockEntity instanceof FeederBlockEntity && (tag = (amberItem = (feederBlockEntity = (FeederBlockEntity)blockEntity).getSpecificItemFromInventory(((Block)ModBlocks.AMBER.get()).m_5456_(), level.f_46441_)).m_41783_()) != null && tag.m_128441_("EntityData")) {
                entity = AmberBlockEntity.createEntity((Level)serverLevel, tag.m_128469_("EntityData"));
            }
            if (entity instanceof PathfinderMob) {
                PathfinderMob pathfinderMob = (PathfinderMob)entity;
                LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(pathfinderMob.m_5743_());
                if (!lootTable.equals(LootTable.f_79105_)) {
                    FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(ModEntities.WANNA_BEE_UUID, "wanna_bee"));
                    LootParams.Builder lootContextBuilder = new LootParams.Builder(serverLevel);
                    lootContextBuilder.m_287286_(LootContextParams.f_81456_, (Object)fakePlayer);
                    lootContextBuilder.m_287286_(LootContextParams.f_81457_, (Object)level.m_269111_().m_269264_());
                    lootContextBuilder.m_287289_(LootContextParams.f_81459_, (Object)fakePlayer);
                    lootContextBuilder.m_287289_(LootContextParams.f_81458_, (Object)fakePlayer);
                    lootContextBuilder.m_287286_(LootContextParams.f_81455_, (Object)entity);
                    lootContextBuilder.m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)flowerPos.m_123341_(), (double)flowerPos.m_123342_(), (double)flowerPos.m_123343_()));
                    List<ItemStack> list = lootTable.m_287195_(lootContextBuilder.m_287235_(LootContextParamSets.f_81415_)).stream().filter(itemStack -> !itemStack.m_204117_(ModTags.WANNABEE_LOOT_BLACKLIST)).toList();
                    if (list.size() > 0) {
                        for (int i = 0; i < rolls; ++i) {
                            outputList.add(list.get(level.f_46441_.m_188503_(list.size())));
                        }
                    }
                }
            }
        }
        return outputList;
    }

    public static ItemStack getCombBlockFromHoneyComb(ItemStack itemStack) {
        ItemStack stack = ItemStack.f_41583_;
        if (itemStack.m_41720_() instanceof Honeycomb) {
            stack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            stack.m_41751_(itemStack.m_41783_());
        } else {
            stack = switch (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString()) {
                case "productivebees:honeycomb_ghostly" -> new ItemStack((ItemLike)ModBlocks.COMB_GHOSTLY.get());
                case "productivebees:honeycomb_milky" -> new ItemStack((ItemLike)ModBlocks.COMB_MILKY.get());
                case "productivebees:honeycomb_powdery" -> new ItemStack((ItemLike)ModBlocks.COMB_POWDERY.get());
                case "minecraft:honeycomb" -> new ItemStack((ItemLike)Blocks.f_50720_);
                default -> stack;
            };
        }
        return stack;
    }

    public static ItemStack getRecipeOutputFromInput(Level level, Item input) {
        Map recipes = level.m_7465_().m_44054_(RecipeType.f_44107_);
        for (Map.Entry entry : recipes.entrySet()) {
            Ingredient ingredient;
            ItemStack[] stacks;
            Recipe recipe = (Recipe)entry.getValue();
            NonNullList ingredients = recipe.m_7527_();
            if (ingredients.size() != 1 || (stacks = (ingredient = (Ingredient)ingredients.get(0)).m_43908_()).length <= 0 || !stacks[0].m_41720_().equals(input)) continue;
            return recipe.m_8043_(level.m_9598_()).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static CentrifugeRecipe getCentrifugeRecipe(Level level, IItemHandlerModifiable inputHandler) {
        return level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get(), (Container)new RecipeWrapper(inputHandler), level).orElse(null);
    }

    private static Block getFloweringBlockFromTag(Level level, BlockPos flowerPos, TagKey<Block> tag, ProductiveBee bee) {
        BlockEntity feederTile;
        BlockState flowerBlockState = level.m_8055_(flowerPos);
        Block flowerBlock = flowerBlockState.m_60734_();
        if (flowerBlock instanceof Feeder && (feederTile = level.m_7702_(flowerPos)) instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)feederTile;
            if (ProductiveBee.isValidFeeder(bee, feederTile, bee::isFlowerBlock, bee::isFlowerItem)) {
                return feederBlockEntity.getRandomBlockFromInventory(tag, level.f_46441_);
            }
        }
        return flowerBlockState.m_204336_(tag) ? flowerBlock : null;
    }

    public static void encaseMob(Mob target, Level level, Direction direction) {
        if (target != null && !target.m_6095_().m_204039_(ModTags.BEE_ENCASE_BLACKLIST) && target.m_6084_()) {
            TamableAnimal tamableAnimal;
            if (target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).m_21824_()) {
                return;
            }
            if (level.m_46859_(target.m_20183_()) && !target.m_213877_()) {
                level.m_46597_(target.m_20183_(), (BlockState)((Block)ModBlocks.AMBER.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction));
                BlockEntity blockEntity = level.m_7702_(target.m_20183_());
                if (blockEntity instanceof AmberBlockEntity) {
                    AmberBlockEntity amberBlockEntity = (AmberBlockEntity)blockEntity;
                    amberBlockEntity.setEntity(target);
                    target.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    public static void setOffspringAttributes(ProductiveBee newBee, ProductiveBee parent1, AgeableMob parent2) {
        Map<BeeAttribute<Integer>, Object> attributeMapParent1 = parent1.getBeeAttributes();
        Map<Object, Object> attributeMapParent2 = new HashMap<BeeAttribute<Integer>, Integer>();
        if (parent2 instanceof ProductiveBee) {
            attributeMapParent2 = ((ProductiveBee)parent2).getBeeAttributes();
        } else {
            attributeMapParent2.put(BeeAttributes.PRODUCTIVITY, 0);
            attributeMapParent2.put(BeeAttributes.ENDURANCE, 0);
            attributeMapParent2.put(BeeAttributes.TEMPER, 1);
            attributeMapParent2.put(BeeAttributes.BEHAVIOR, 0);
            attributeMapParent2.put(BeeAttributes.WEATHER_TOLERANCE, 0);
        }
        Map<BeeAttribute<Integer>, Object> attributeMapChild = newBee.getBeeAttributes();
        if (!attributeMapChild.containsKey(BeeAttributes.PRODUCTIVITY)) {
            newBee.setDefaultAttributes();
            attributeMapChild = newBee.getBeeAttributes();
        }
        int parentProductivity = Mth.m_216271_((RandomSource)newBee.m_9236_().f_46441_, (int)((Integer)attributeMapParent1.get(BeeAttributes.PRODUCTIVITY)), (int)((Integer)attributeMapParent2.get(BeeAttributes.PRODUCTIVITY)));
        newBee.setAttributeValue(BeeAttributes.PRODUCTIVITY, Math.max((Integer)attributeMapChild.get(BeeAttributes.PRODUCTIVITY), parentProductivity));
        int parentEndurance = Mth.m_216271_((RandomSource)newBee.m_9236_().f_46441_, (int)((Integer)attributeMapParent1.get(BeeAttributes.ENDURANCE)), (int)((Integer)attributeMapParent2.get(BeeAttributes.ENDURANCE)));
        newBee.setAttributeValue(BeeAttributes.ENDURANCE, Math.max((Integer)attributeMapChild.get(BeeAttributes.ENDURANCE), parentEndurance));
        int parentTemper = Mth.m_216271_((RandomSource)newBee.m_9236_().f_46441_, (int)((Integer)attributeMapParent1.get(BeeAttributes.TEMPER)), (int)((Integer)attributeMapParent2.get(BeeAttributes.TEMPER)));
        newBee.setAttributeValue(BeeAttributes.TEMPER, Math.min((Integer)attributeMapChild.get(BeeAttributes.TEMPER), parentTemper));
        int parentBehavior = Mth.m_216271_((RandomSource)newBee.m_9236_().f_46441_, (int)((Integer)attributeMapParent1.get(BeeAttributes.BEHAVIOR)), (int)((Integer)attributeMapParent2.get(BeeAttributes.BEHAVIOR)));
        newBee.setAttributeValue(BeeAttributes.BEHAVIOR, Math.max((Integer)attributeMapChild.get(BeeAttributes.BEHAVIOR), parentBehavior));
        int parentWeatherTolerance = Mth.m_216271_((RandomSource)newBee.m_9236_().f_46441_, (int)((Integer)attributeMapParent1.get(BeeAttributes.WEATHER_TOLERANCE)), (int)((Integer)attributeMapParent2.get(BeeAttributes.WEATHER_TOLERANCE)));
        newBee.setAttributeValue(BeeAttributes.WEATHER_TOLERANCE, Math.max((Integer)attributeMapChild.get(BeeAttributes.WEATHER_TOLERANCE), parentWeatherTolerance));
    }

    public static CompoundTag getBeeAsCompoundTag(BeeIngredient beeIngredient) throws CommandSyntaxException {
        CompoundTag bee;
        if (beeIngredient.isConfigurable()) {
            String type = beeIngredient.getBeeType().m_135815_();
            bee = TagParser.m_129359_((String)("{id:\"productivebees:configurable_bee\",bee_type: \"hive\", type: \"productivebees:" + type + "\", HasConverted: false}"));
        } else {
            bee = TagParser.m_129359_((String)("{id:\"" + beeIngredient.getBeeType().toString() + "\",bee_type: \"solitary\", HasConverted: false}"));
        }
        Random random = new Random();
        bee.m_128405_("bee_productivity", random.nextInt(3));
        bee.m_128405_("bee_temper", 1);
        bee.m_128405_("bee_endurance", random.nextInt(3));
        bee.m_128405_("bee_behavior", 0);
        bee.m_128405_("bee_weather_tolerance", 0);
        switch (beeIngredient.getBeeType().m_135815_()) {
            case "mason_bee": 
            case "blue_banded_bee": {
                bee.m_128405_("bee_temper", 0);
                break;
            }
            case "sweat_bee": {
                bee.m_128405_("bee_temper", 2);
            }
        }
        if (beeIngredient.isConfigurable()) {
            CompoundTag data = BeeReloadListener.INSTANCE.getData(beeIngredient.getBeeType().toString());
            if (data.m_128441_("productivity")) {
                bee.m_128405_("bee_productivity", data.m_128451_("productivity"));
            }
            if (data.m_128441_("temper")) {
                bee.m_128405_("bee_temper", data.m_128451_("temper"));
            }
            if (data.m_128441_("endurance")) {
                bee.m_128405_("bee_endurance", data.m_128451_("endurance"));
            }
            if (data.m_128441_("behavior")) {
                bee.m_128405_("bee_behavior", data.m_128451_("behavior"));
            }
            if (data.m_128441_("weather_tolerance")) {
                bee.m_128405_("bee_weather_tolerance", data.m_128451_("weather_tolerance"));
            }
        }
        return bee;
    }

    public static void populateBeeInfoFromEntity(Bee bee, List<Component> list) {
        CompoundTag tag = new CompoundTag();
        bee.m_20240_(tag);
        if (bee instanceof ProductiveBee) {
            tag.m_128379_("isProductiveBee", true);
        }
        BeeHelper.populateBeeInfoFromTag(tag, list);
    }

    public static List<Component> populateBeeInfoFromTag(CompoundTag tag, @Nullable List<Component> list) {
        if (list == null) {
            list = new ArrayList<Component>();
        }
        list.add((Component)Component.m_237115_((String)(tag.m_128451_("Age") < 0 ? "productivebees.information.age.child" : "productivebees.information.age.adult")).m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.ITALIC));
        if (tag.m_128471_("isProductiveBee")) {
            float current = tag.m_128457_("Health");
            float max = tag.m_128441_("MaxHealth") ? tag.m_128457_("MaxHealth") : 10.0f;
            list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.health", (Object[])new Object[]{Float.valueOf(current), Float.valueOf(max)}).m_130940_(ChatFormatting.DARK_GRAY));
            String type = tag.m_128461_("bee_type");
            MutableComponent type_value = Component.m_237115_((String)("productivebees.information.attribute.type." + type)).m_130940_(ColorUtil.getBeeTypeColor(type));
            list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.type", (Object[])new Object[]{type_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int productivity = tag.m_128451_("bee_productivity");
            MutableComponent productivity_value = Component.m_237115_((String)BeeAttributes.keyMap.get(BeeAttributes.PRODUCTIVITY).get(productivity)).m_130940_(ColorUtil.getAttributeColor(productivity));
            list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.productivity", (Object[])new Object[]{productivity_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int tolerance = tag.m_128451_("bee_weather_tolerance");
            MutableComponent tolerance_value = Component.m_237115_((String)BeeAttributes.keyMap.get(BeeAttributes.WEATHER_TOLERANCE).get(tolerance)).m_130940_(ColorUtil.getAttributeColor(tolerance));
            list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.weather_tolerance", (Object[])new Object[]{tolerance_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int behavior = tag.m_128451_("bee_behavior");
            MutableComponent behavior_value = Component.m_237115_((String)BeeAttributes.keyMap.get(BeeAttributes.BEHAVIOR).get(behavior)).m_130940_(ColorUtil.getAttributeColor(behavior));
            list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.behavior", (Object[])new Object[]{behavior_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int endurance = tag.m_128451_("bee_endurance");
            MutableComponent endurance_value = Component.m_237115_((String)BeeAttributes.keyMap.get(BeeAttributes.ENDURANCE).get(endurance)).m_130940_(ColorUtil.getAttributeColor(endurance));
            list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.endurance", (Object[])new Object[]{endurance_value}).m_130940_(ChatFormatting.DARK_GRAY));
            int temper = tag.m_128451_("bee_temper");
            MutableComponent temper_value = Component.m_237115_((String)BeeAttributes.keyMap.get(BeeAttributes.TEMPER).get(temper)).m_130940_(ColorUtil.getAttributeColor(temper));
            list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.temper", (Object[])new Object[]{temper_value}).m_130940_(ChatFormatting.DARK_GRAY));
            CompoundTag beeData = BeeReloadListener.INSTANCE.getData(tag.m_128461_("type"));
            MutableComponent breedingItemText = Component.m_237115_((String)"productivebees.information.breeding_item_default");
            if (beeData != null && beeData.m_128441_("breedingItem") && !beeData.m_128461_("breedingItem").isEmpty()) {
                Item breedingItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(beeData.m_128461_("breedingItem")));
                breedingItemText = Component.m_237113_((String)(beeData.m_128451_("breedingItemCount") + " " + Component.m_237115_((String)breedingItem.m_5524_()).getString()));
            }
            list.add((Component)Component.m_237110_((String)"productivebees.information.breeding_item", (Object[])new Object[]{breedingItemText.m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
            if (beeData != null && !beeData.m_128471_("selfbreed")) {
                list.add((Component)Component.m_237115_((String)"productivebees.information.selfbreed_disabled").m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128441_("HivePos")) {
                BlockPos hivePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("HivePos"));
                list.add((Component)Component.m_237110_((String)"productivebees.information.home_position", (Object[])new Object[]{hivePos.m_123341_(), hivePos.m_123342_(), hivePos.m_123343_()}));
            }
        } else {
            list.add((Component)Component.m_237113_((String)("Mod: " + tag.m_128461_("mod"))).m_130940_(ChatFormatting.DARK_AQUA));
        }
        return list;
    }

    public static class IdentifierInventory
    implements Container {
        private final List<String> identifiers = new ArrayList<String>();

        public IdentifierInventory(String identifier) {
            this.identifiers.add(identifier);
        }

        public IdentifierInventory(Bee bee1, Bee bee2) {
            String identifier1 = bee1.m_20078_();
            if (bee1 instanceof ConfigurableBee) {
                identifier1 = ((ConfigurableBee)bee1).getBeeType();
            }
            String identifier2 = bee2.m_20078_();
            if (bee2 instanceof ConfigurableBee) {
                identifier2 = ((ConfigurableBee)bee2).getBeeType();
            }
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public IdentifierInventory(Bee bee1, String identifier2) {
            String identifier1 = bee1.m_20078_();
            if (bee1 instanceof ConfigurableBee) {
                identifier1 = ((ConfigurableBee)bee1).getBeeType();
            }
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public IdentifierInventory(String identifier1, String identifier2) {
            this.identifiers.add(identifier1);
            this.identifiers.add(identifier2);
        }

        public String getIdentifier() {
            return this.getIdentifier(0);
        }

        public String getIdentifier(int index) {
            return this.identifiers.get(index);
        }

        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            return this.identifiers.isEmpty();
        }

        @Nonnull
        public ItemStack m_8020_(int i) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack m_7407_(int i, int i1) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack m_8016_(int i) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int i, @Nonnull ItemStack itemStack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(@Nonnull Player playerEntity) {
            return false;
        }

        public void m_6211_() {
            this.identifiers.clear();
        }
    }

    public static class BlockStateInventory
    extends IdentifierInventory {
        private BlockState state;

        public BlockStateInventory(Bee bee1, BlockState state) {
            super(bee1, state.toString());
            this.state = state;
        }

        public BlockState getState() {
            return this.state;
        }
    }

    public static class ItemInventory
    extends IdentifierInventory {
        private ItemStack input;

        public ItemInventory(Bee bee1, ItemStack input) {
            super(bee1, input.toString());
            this.input = input;
        }

        public ItemStack getInput() {
            return this.input;
        }
    }
}

