/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee;

import cy.jdkdigital.productivebees.client.particle.NectarParticleType;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.IEffectBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.compat.sussy.SussyCompatHandler;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeEffect;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigurableBee
extends ProductiveBee
implements IEffectBeeEntity {
    private int attackCooldown = 0;
    public int breathCollectionCooldown = 600;
    private int teleportCooldown = 250;
    public Mob target = null;
    public static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(ConfigurableBee.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public ConfigurableBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.beehiveInterests = poi -> poi.m_203656_(PoiTypeTags.f_215877_) || poi.m_203334_() == ModPointOfInterestTypes.NETHER_NEST.get() || poi.m_203334_() == ModPointOfInterestTypes.SOLITARY_HIVE.get() && this.isWild() || poi.m_203334_() == ModPointOfInterestTypes.SOLITARY_NEST.get() && this.isWild() || poi.m_203334_() == ModPointOfInterestTypes.DRACONIC_NEST.get() && this.isDraconic() || poi.m_203334_() == ModPointOfInterestTypes.SUGARBAG_NEST.get() && this.getBeeType().equals("productivebees:sugarbag");
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData livingEntityData, @Nullable CompoundTag tag) {
        String type = "";
        if (tag != null) {
            RandomSource random = level.m_213780_();
            String string = tag.m_128441_("type") ? tag.m_128461_("type") : (type = tag.m_128441_("EntityTag") ? tag.m_128469_("EntityTag").m_128461_("type") : "");
            if (type.equals("productivebees:ghostly") && random.m_188501_() < 0.02f) {
                this.m_6593_((Component)Component.m_237113_((String)"BooBee"));
            } else if (type.equals("productivebees:blitz") && random.m_188501_() < 0.02f) {
                this.m_6593_((Component)Component.m_237113_((String)"King BitzBee"));
            } else if (type.equals("productivebees:basalz") && random.m_188501_() < 0.02f) {
                this.m_6593_((Component)Component.m_237113_((String)"Queen BazBee"));
            } else if (type.equals("productivebees:blizz") && random.m_188501_() < 0.02f) {
                this.m_6593_((Component)Component.m_237113_((String)"Shiny BizBee"));
            } else if (type.equals("productivebees:redstone") && random.m_188501_() < 0.01f) {
                this.m_6593_((Component)Component.m_237113_((String)"Redastone Bee"));
            } else if (type.equals("productivebees:destabilized_redstone") && random.m_188501_() < 0.1f) {
                this.m_6593_((Component)Component.m_237113_((String)"Destabilized RedaStone Bee"));
            } else if (type.equals("productivebees:compressed_iron") && random.m_188501_() < 0.05f) {
                this.m_6593_((Component)Component.m_237113_((String)"Depressed Iron Bee"));
            } else if (type.equals("productivebees:sponge") && random.m_188501_() < 0.05f) {
                this.m_6593_((Component)Component.m_237113_((String)"SpongeBee BlockPants"));
            } else if (type.equals("productivebees:infinity") && random.m_188501_() < 0.25f) {
                this.m_6593_((Component)Component.m_237113_((String)"Infinibee"));
            } else if (type.equals("productivebees:water") && random.m_188501_() < 0.05f) {
                switch (random.m_188503_(5)) {
                    case 0: {
                        this.m_6593_((Component)Component.m_237113_((String)"Wet Bee"));
                        break;
                    }
                    case 1: {
                        this.m_6593_((Component)Component.m_237113_((String)"Splashy Bee"));
                        break;
                    }
                    case 2: {
                        this.m_6593_((Component)Component.m_237113_((String)"Fishy Bee"));
                        break;
                    }
                    case 3: {
                        this.m_6593_((Component)Component.m_237113_((String)"Moist Bee"));
                        break;
                    }
                    case 4: {
                        this.m_6593_((Component)Component.m_237113_((String)"Dripping Bee"));
                    }
                }
            }
        }
        return super.m_6518_(level, difficulty, spawnReason, livingEntityData, tag);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            --this.teleportCooldown;
            if (--this.attackCooldown < 0) {
                this.attackCooldown = 0;
            }
            if (this.attackCooldown == 0 && this.m_21660_() && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 4.0) {
                this.attackCooldown = this.getEffectCooldown(this.getAttributeValue(BeeAttributes.TEMPER));
                this.attackTarget(this.m_5448_());
            }
            if (!this.m_27856_() && this.m_9236_().m_46472_() == Level.f_46430_ && this.isDraconic() && --this.breathCollectionCooldown <= 0) {
                this.breathCollectionCooldown = 600;
                this.internalSetHasNectar(true);
            }
            if (this.f_19797_ % 21 == 0 && this.m_27856_() && this.isRedstoned()) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos beePosDown = this.m_20183_().m_6625_(i);
                    if (!this.m_9236_().m_46859_(beePosDown)) continue;
                    BlockState redstoneState = ((Block)ModBlocks.INVISIBLE_REDSTONE_BLOCK.get()).m_49966_();
                    this.m_9236_().m_46597_(beePosDown, redstoneState);
                    this.m_9236_().m_186460_(beePosDown, redstoneState.m_60734_(), 20);
                }
            }
            if (this.target != null) {
                if (!this.m_27856_()) {
                    this.target.m_21573_().m_26517_(0.01);
                } else {
                    this.target.m_6710_((LivingEntity)this);
                    this.target = null;
                }
            }
            if (this.f_19797_ > 100 && this.getBeeType().isEmpty() && this.m_6084_()) {
                this.m_6074_();
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.f_19797_ % 120 == 0 && this.canSelfHeal() && this.m_21223_() < this.m_21233_()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1));
        }
    }

    public boolean m_7327_(Entity entity) {
        AttributeInstance attackDamage = this.m_21051_(Attributes.f_22281_);
        if (attackDamage != null && this.getDamage() != 2.0) {
            attackDamage.m_22118_(new AttributeModifier("Extra Damage", this.getDamage(), AttributeModifier.Operation.ADDITION));
        }
        return super.m_7327_(entity);
    }

    public void m_27779_(Level worldIn, double xMin, double xMax, double zMin, double zMax, double posY, ParticleOptions particleData) {
        NectarParticleType particle;
        switch (this.getParticleType()) {
            case "pop": {
                NectarParticleType nectarParticleType = (NectarParticleType)((Object)ModParticles.COLORED_POPPING_NECTAR.get());
                break;
            }
            case "lava": {
                NectarParticleType nectarParticleType = (NectarParticleType)((Object)ModParticles.COLORED_LAVA_NECTAR.get());
                break;
            }
            case "portal": {
                NectarParticleType nectarParticleType = (NectarParticleType)((Object)ModParticles.COLORED_PORTAL_NECTAR.get());
                break;
            }
            case "rising": {
                NectarParticleType nectarParticleType = (NectarParticleType)((Object)ModParticles.COLORED_RISING_NECTAR.get());
                break;
            }
            default: {
                NectarParticleType nectarParticleType = particle = (NectarParticleType)((Object)ModParticles.COLORED_FALLING_NECTAR.get());
            }
        }
        if (this.hasParticleColor()) {
            particle.setColor(this.getParticleColor());
        } else {
            particle.setColor(new float[]{0.92f, 0.782f, 0.72f});
        }
        worldIn.m_7106_((ParticleOptions)particle, Mth.m_14139_((double)worldIn.f_46441_.m_188500_(), (double)xMin, (double)xMax), posY, Mth.m_14139_((double)worldIn.f_46441_.m_188500_(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }

    protected void m_8024_() {
        if (this.teleportCooldown <= 0) {
            if (null != this.f_21344_.m_26570_() && this.isTeleporting()) {
                int antiTeleportUpgrades;
                BlockEntity te;
                if (this.m_27854_() && (te = this.m_9236_().m_7702_(this.m_27855_())) instanceof AdvancedBeehiveBlockEntity && (antiTeleportUpgrades = ((AdvancedBeehiveBlockEntity)te).getUpgradeCount((Item)ModItems.UPGRADE_ANTI_TELEPORT.get())) > 0) {
                    this.teleportCooldown = 10000;
                    super.m_8024_();
                    return;
                }
                BlockPos pos = this.f_21344_.m_26570_().m_77406_();
                this.teleport(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
            this.teleportCooldown = 250;
        }
        super.m_8024_();
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplierIn) {
        if (!this.isStringy() || state.m_60734_() != Blocks.f_50033_) {
            super.m_7601_(state, motionMultiplierIn);
        }
    }

    public boolean m_142079_() {
        return !this.isColdResistant() && super.m_142079_();
    }

    @Override
    public void attackTarget(LivingEntity target) {
        if (this.m_6084_() && this.getNBTData().m_128441_("attackResponse")) {
            String attackResponse;
            switch (attackResponse = this.getNBTData().m_128461_("attackResponse")) {
                case "fire": {
                    target.m_7311_(200);
                }
                case "lava": {
                    this.m_9236_().m_7731_(target.m_20183_(), Blocks.f_49991_.m_49966_(), 11);
                }
            }
        }
    }

    public void setBeeType(String data) {
        this.f_19804_.m_135381_(TYPE, (Object)data);
    }

    @Override
    public String getBeeType() {
        return (String)this.f_19804_.m_135370_(TYPE);
    }

    public float m_6113_() {
        return super.m_6113_() * this.getSpeedModifier();
    }

    @Override
    public void m_27925_(boolean hasStung) {
        if (!this.isStingless()) {
            super.m_27925_(hasStung);
        }
    }

    public void m_7350_(EntityDataAccessor<?> param) {
        if (TYPE.equals(param)) {
            this.m_6210_();
        }
        super.m_7350_(param);
    }

    @Override
    public void setDefaultAttributes() {
        if (!this.hasBeeAttributes()) {
            super.setDefaultAttributes();
            CompoundTag nbt = this.getNBTData();
            if (nbt.m_128441_("productivity")) {
                this.setAttributeValue(BeeAttributes.PRODUCTIVITY, nbt.m_128451_("productivity"));
            }
            if (nbt.m_128441_("temper")) {
                this.setAttributeValue(BeeAttributes.TEMPER, nbt.m_128451_("temper"));
            }
            if (nbt.m_128441_("endurance")) {
                this.setAttributeValue(BeeAttributes.ENDURANCE, nbt.m_128451_("endurance"));
            }
            if (nbt.m_128441_("behavior")) {
                this.setAttributeValue(BeeAttributes.BEHAVIOR, nbt.m_128451_("behavior"));
            }
            if (nbt.m_128441_("weather_tolerance")) {
                this.setAttributeValue(BeeAttributes.WEATHER_TOLERANCE, nbt.m_128451_("weather_tolerance"));
            }
        } else {
            super.setDefaultAttributes();
        }
    }

    @Override
    public float[] getColor(int tintIndex, float partialTicks) {
        CompoundTag nbt = this.getNBTData();
        if (nbt.m_128441_("primaryColor")) {
            if (nbt.m_128471_("colorCycle") && !nbt.m_128461_("renderer").contains("crystal")) {
                return ColorUtil.getCycleColor(nbt.m_128451_("primaryColor"), nbt.m_128451_("tertiaryColor"), this.f_19797_, partialTicks);
            }
            return ColorUtil.getCacheColor(tintIndex == 0 ? nbt.m_128451_("primaryColor") : nbt.m_128451_("secondaryColor"));
        }
        return super.getColor(tintIndex, partialTicks);
    }

    public float[] getParticleColor() {
        return ColorUtil.getCacheColor(this.getNBTData().m_128451_("particleColor"));
    }

    public float[] getTertiaryColor(float partialTicks) {
        CompoundTag nbt = this.getNBTData();
        if (nbt.m_128471_("colorCycle") && nbt.m_128461_("renderer").contains("crystal")) {
            return ColorUtil.getCycleColor(nbt.m_128451_("primaryColor"), nbt.m_128451_("tertiaryColor"), this.f_19797_, partialTicks);
        }
        return ColorUtil.getCacheColor(nbt.m_128451_("tertiaryColor"));
    }

    @Override
    public boolean isColored() {
        return !this.hasBeeTexture();
    }

    @Nonnull
    protected Component m_5677_() {
        CompoundTag nbt = this.getNBTData();
        if (nbt != null) {
            return Component.m_237115_((String)("entity.productivebees." + this.getBeeName() + "_bee"));
        }
        return super.m_5677_();
    }

    @Override
    public float getSizeModifier() {
        CompoundTag nbt = this.getNBTData();
        return nbt != null ? (this.m_27856_() ? nbt.m_128457_("pollinatedSize") : nbt.m_128457_("size")) : super.getSizeModifier();
    }

    public float getSpeedModifier() {
        CompoundTag nbt = this.getNBTData();
        return nbt != null ? nbt.m_128457_("speed") : 1.0f;
    }

    public double getDamage() {
        CompoundTag nbt = this.getNBTData();
        return nbt != null ? nbt.m_128459_("attack") : 2.0;
    }

    @Override
    public boolean canSelfBreed() {
        CompoundTag nbt = this.getNBTData();
        return nbt.m_128471_("selfbreed");
    }

    @Override
    public boolean m_27896_(BlockPos pos) {
        if (!this.m_9236_().m_46749_(pos)) {
            return false;
        }
        if (this.getFlowerType().equals("entity_types")) {
            CompoundTag nbt = this.getNBTData();
            if (nbt != null && nbt.m_128441_("flowerTag")) {
                Object e;
                TagKey<EntityType<?>> entityTag = ModTags.getEntityTag(new ResourceLocation(nbt.m_128461_("flowerTag")));
                BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
                if (blockEntity instanceof AmberBlockEntity) {
                    AmberBlockEntity amberBlockEntity = (AmberBlockEntity)blockEntity;
                    Entity entity2 = amberBlockEntity.getCachedEntity();
                    return entity2 != null && entity2.m_6095_().m_204039_(entityTag);
                }
                List entities = this.m_9236_().m_6249_((Entity)this, new AABB(pos).m_82377_(1.0, 1.0, 1.0), entity -> nbt.m_128471_("inverseFlower") != entity.m_6095_().m_204039_(entityTag));
                if (!entities.isEmpty() && (e = entities.get(0)) instanceof Mob) {
                    Mob mob;
                    this.target = mob = (Mob)e;
                    this.target.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 400));
                    return true;
                }
            }
            return false;
        }
        return super.isFlowerValid(pos, this::isFlowerBlock, this::isFlowerItem);
    }

    @Override
    public boolean isFlowerBlock(BlockState flowerBlock) {
        if (flowerBlock.m_60795_()) {
            return false;
        }
        boolean canConvertBlock = BeeHelper.hasBlockConversionRecipe(this, flowerBlock);
        if (canConvertBlock) {
            return true;
        }
        CompoundTag nbt = this.getNBTData();
        if (nbt != null && this.getFlowerType().equals("blocks")) {
            if (nbt.m_128441_("flowerTag")) {
                TagKey<Block> flowerTag = ModTags.getBlockTag(new ResourceLocation(nbt.m_128461_("flowerTag")));
                return flowerBlock.m_204336_(flowerTag);
            }
            if (nbt.m_128441_("flowerBlock")) {
                return ForgeRegistries.BLOCKS.getKey((Object)flowerBlock.m_60734_()).toString().equals(nbt.m_128461_("flowerBlock"));
            }
            if (nbt.m_128441_("flowerFluid") && !flowerBlock.m_60819_().m_76178_()) {
                if (nbt.m_128461_("flowerFluid").contains("#")) {
                    TagKey<Fluid> flowerFluid = ModTags.getFluidTag(new ResourceLocation(nbt.m_128461_("flowerFluid").replace("#", "")));
                    return flowerBlock.m_60819_().m_205070_(flowerFluid);
                }
                return ForgeRegistries.FLUIDS.getKey((Object)flowerBlock.m_60819_().m_76152_()).toString().equals(nbt.m_128461_("flowerFluid"));
            }
        }
        return super.isFlowerBlock(flowerBlock);
    }

    @Override
    public boolean isFlowerItem(ItemStack flowerItem) {
        if (flowerItem.m_41619_()) {
            return false;
        }
        CompoundTag nbt = this.getNBTData();
        if (nbt != null && this.getFlowerType().equals("blocks")) {
            if (nbt.m_128441_("flowerTag")) {
                TagKey<Item> flowerTag = ModTags.getItemTag(new ResourceLocation(nbt.m_128461_("flowerTag")));
                return flowerItem.m_204117_(flowerTag);
            }
            if (nbt.m_128441_("flowerItem")) {
                return flowerItem.m_150930_((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_("flowerItem"))));
            }
        }
        return super.isFlowerItem(flowerItem);
    }

    @Override
    public Ingredient getBreedingIngredient() {
        String id = this.getNBTData().m_128461_("breedingItem");
        if (id.isEmpty()) {
            return super.getBreedingIngredient();
        }
        if (id.startsWith("#")) {
            return Ingredient.m_204132_(ModTags.getItemTag(new ResourceLocation(id.substring(1))));
        }
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id))});
    }

    @Override
    public Integer getBreedingItemCount() {
        return this.getNBTData().m_128451_("breedingItemCount");
    }

    @Override
    public TagKey<Block> getNestingTag() {
        CompoundTag nbt = this.getNBTData();
        if (nbt != null && nbt.m_128441_("nestingPreference")) {
            return ModTags.getBlockTag(new ResourceLocation(nbt.m_128461_("nestingPreference")));
        }
        return super.getNestingTag();
    }

    @Override
    public BeeEffect getBeeEffect() {
        CompoundTag nbt = this.getNBTData();
        if (nbt.m_128441_("effect")) {
            return new BeeEffect(nbt.m_128469_("effect"));
        }
        return super.getBeeEffect();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)"");
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.setBeeType(compound.m_128461_("type"));
        this.breathCollectionCooldown = compound.m_128451_("breathCollectionCooldown");
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("type", this.getBeeType());
        compound.m_128405_("breathCollectionCooldown", this.breathCollectionCooldown);
    }

    public CompoundTag getNBTData() {
        CompoundTag nbt = BeeReloadListener.INSTANCE.getData(this.getBeeType());
        return nbt != null ? nbt : new CompoundTag();
    }

    public boolean hasBeeTexture() {
        return this.getNBTData().m_128441_("beeTexture");
    }

    public String getBeeTexture() {
        return this.getNBTData().m_128461_("beeTexture");
    }

    @Override
    public String getRenderer() {
        return this.getNBTData().m_128461_("renderer");
    }

    public String getRenderTransform() {
        return this.getNBTData().m_128461_("renderTransform");
    }

    public boolean useGlowLayer() {
        return this.getNBTData().m_128471_("useGlowLayer") || this.isRedstoned() && this.m_27856_();
    }

    private boolean isWild() {
        return this.getNBTData().m_128441_("nestingPreference");
    }

    public boolean isFireproof() {
        return this.getNBTData().m_128471_("fireproof");
    }

    public boolean isWithered() {
        return this.getNBTData().m_128471_("withered");
    }

    public boolean isTranslucent() {
        return this.getNBTData().m_128471_("translucent");
    }

    public boolean isBlinding() {
        return this.getNBTData().m_128471_("blinding");
    }

    public boolean isDraconic() {
        return this.getNBTData().m_128471_("draconic");
    }

    public boolean isRedstoned() {
        return this.getNBTData().m_128471_("redstoned");
    }

    public boolean isSlimy() {
        return this.getNBTData().m_128471_("slimy");
    }

    public boolean isTeleporting() {
        return this.getNBTData().m_128471_("teleporting");
    }

    public boolean isStringy() {
        return this.getNBTData().m_128471_("stringy");
    }

    public boolean isStingless() {
        return this.getNBTData().m_128471_("stingless");
    }

    public boolean hasMunchies() {
        return this.getNBTData().m_128471_("munchies");
    }

    public boolean isWaterproof() {
        return this.getNBTData().m_128471_("waterproof");
    }

    public boolean isColdResistant() {
        return this.getNBTData().m_128471_("coldResistant");
    }

    public boolean isIrradiated() {
        return this.getNBTData().m_128471_("irradiated");
    }

    public String getParticleType() {
        return this.getNBTData().m_128461_("particleType");
    }

    public boolean hasParticleColor() {
        return this.getNBTData().m_128441_("particleColor");
    }

    public boolean canSelfHeal() {
        return this.getNBTData().m_128471_("selfheal");
    }

    @Override
    public String getFlowerType() {
        return this.getNBTData().m_128461_("flowerType");
    }

    @Override
    public Map<MobEffect, Integer> getAggressiveEffects() {
        if (this.isWithered()) {
            return new HashMap<MobEffect, Integer>(){
                {
                    this.put(MobEffects.f_19615_, 350);
                }
            };
        }
        if (this.hasMunchies()) {
            return new HashMap<MobEffect, Integer>(){
                {
                    this.put(MobEffects.f_19612_, 530);
                }
            };
        }
        if (this.isBlinding()) {
            return new HashMap<MobEffect, Integer>(){
                {
                    this.put(MobEffects.f_19610_, 450);
                }
            };
        }
        return null;
    }

    public List<String> getInvulnerabilities() {
        Tag inv = this.getNBTData().m_128423_("invulnerability");
        ArrayList<String> list = new ArrayList<String>();
        if (inv instanceof ListTag) {
            ListTag listInv = (ListTag)inv;
            listInv.forEach(tag -> list.add(tag.m_7916_()));
        }
        return list;
    }

    @Override
    public boolean m_6673_(@Nonnull DamageSource source) {
        if (this.isWithered() && source.equals(this.m_9236_().m_269111_().m_269251_())) {
            return true;
        }
        if (this.isDraconic() && source.equals(this.m_9236_().m_269111_().m_269254_())) {
            return true;
        }
        if (this.isTranslucent() && source.equals(this.m_9236_().m_269111_().m_269230_((Entity)this))) {
            return true;
        }
        if (this.isWaterproof() && source.equals(this.m_9236_().m_269111_().m_269063_())) {
            return true;
        }
        if (this.isColdResistant() && source.equals(this.m_9236_().m_269111_().m_269109_())) {
            return true;
        }
        if (this.isFireproof() && (source.equals(this.m_9236_().m_269111_().m_269047_()) || source.equals(this.m_9236_().m_269111_().m_269387_()) || source.equals(this.m_9236_().m_269111_().m_269549_()) || source.equals(this.m_9236_().m_269111_().m_269233_()))) {
            return true;
        }
        return super.m_6673_(source) || this.getInvulnerabilities().contains(source.m_19385_());
    }

    public boolean m_7301_(MobEffectInstance effect) {
        if (this.isWithered()) {
            return effect.m_19544_() != MobEffects.f_19615_ && super.m_7301_(effect);
        }
        return super.m_7301_(effect);
    }

    private void teleport(double x, double y, double z) {
        EntityTeleportEvent.EnderEntity event;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)pos).m_280555_()) {
            pos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)pos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1 && !(event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z)).isCanceled()) {
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void postPollinate() {
        super.postPollinate();
        if (this.getNBTData().m_128441_("postPollination")) {
            switch (this.getNBTData().m_128461_("postPollination")) {
                case "amber_encase": {
                    BeeHelper.encaseMob(this.target, this.m_9236_(), this.m_6350_());
                    this.target = null;
                    break;
                }
                case "sus": {
                    ServerLevel level;
                    Level level2;
                    if (this.f_27697_ == null || !((level2 = this.m_9236_()) instanceof ServerLevel) || !((level2 = (level = (ServerLevel)level2).m_7702_(this.f_27697_)) instanceof BrushableBlockEntity)) break;
                    BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)level2;
                    List<ResourceLocation> possibleTables = SussyCompatHandler.getLootTables(level, this.f_27697_);
                    if (possibleTables.size() <= 0) break;
                    brushableBlockEntity.m_277049_(possibleTables.get(level.m_213780_().m_188503_(possibleTables.size())), level.m_213780_().m_188505_());
                    this.f_27697_ = null;
                }
            }
        }
    }
}

