/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.network.NetworkHooks;

public class Feeder
extends SlabBlock
implements EntityBlock {
    public static final BooleanProperty HONEYLOGGED = BooleanProperty.m_61465_((String)"honeylogged");

    public Feeder(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HONEYLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : FeederBlockEntity::tick;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HONEYLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (fluidstate.m_205070_(ModTags.HONEY) && fluidstate.m_76170_() && state != null) {
            return (BlockState)state.m_61124_((Property)HONEYLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_((Property)f_56353_) != SlabType.DOUBLE && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && (fluidIn == Fluids.f_76193_ || fluidIn.m_6212_((Fluid)ModFluids.HONEY.get()));
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            boolean isHoney;
            boolean bl = isHoney = fluidState.m_76152_().m_6212_((Fluid)ModFluids.HONEY.get()) && fluidState.m_76170_();
            if (fluidState.m_76152_() == Fluids.f_76193_ || isHoney) {
                BlockEntity blockEntity;
                if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FeederBlockEntity) {
                    FeederBlockEntity feederBlockEntity = (FeederBlockEntity)blockEntity;
                    CompoundTag nbt = new CompoundTag();
                    feederBlockEntity.savePacketNBT(nbt);
                    level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HONEYLOGGED, (Comparable)Boolean.valueOf(isHoney)), 3);
                    level.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
                    feederBlockEntity.loadPacketNBT(nbt);
                }
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)HONEYLOGGED) != false ? ((ForgeFlowingFluid)ModFluids.HONEY.get()).m_76068_(false) : super.m_5888_(state);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        super.onBlockStateChange(level, pos, oldState, newState);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)blockEntity;
            feederBlockEntity.refreshInventoryHandler();
        }
    }

    @Nonnull
    public ItemStack m_142598_(LevelAccessor world, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)HONEYLOGGED)).booleanValue()) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)HONEYLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)ModItems.HONEY_BUCKET.get());
        }
        return super.m_142598_(world, pos, state);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof MenuProvider ? (MenuProvider)tile : null;
    }

    public void m_6810_(BlockState oldState, @Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.m_60734_() != newState.m_60734_() && (tileEntity = worldIn.m_7702_(pos)) instanceof FeederBlockEntity) {
            tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(slot));
                }
            });
        }
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity;
        BlockEntity blockEntity;
        Block heldBlock;
        ItemStack heldItem = player.m_21120_(handIn);
        if (heldItem.m_41720_() instanceof BlockItem && (heldBlock = ((BlockItem)heldItem.m_41720_()).m_40614_()) instanceof SlabBlock && !(heldBlock instanceof Feeder) && (blockEntity = world.m_7702_(pos)) instanceof FeederBlockEntity) {
            ((FeederBlockEntity)blockEntity).baseBlock = heldBlock instanceof Feeder ? null : heldBlock;
            blockEntity.m_6596_();
            return InteractionResult.SUCCESS;
        }
        if (!world.m_5776_() && (tileEntity = world.m_7702_(pos)) instanceof FeederBlockEntity) {
            this.openGui((ServerPlayer)player, (FeederBlockEntity)tileEntity);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FeederBlockEntity(pos, state);
    }

    public void openGui(ServerPlayer player, FeederBlockEntity tileEntity) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)tileEntity, packetBuffer -> packetBuffer.m_130064_(tileEntity.m_58899_()));
    }
}

