/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.client.render.entity.layers.BeeBodyLayer;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BumbleBee;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ProductiveBeeRenderer
extends MobRenderer<ProductiveBee, ProductiveBeeModel<ProductiveBee>> {
    private static Map<String, ResourceLocation> resLocCache = new HashMap<String, ResourceLocation>();
    public static final ModelLayerLocation PB_MAIN_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "main"), "main");
    public static final ModelLayerLocation PB_HOARDER_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "hoarder"), "main");
    public static final ModelLayerLocation PB_RANCHER_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "rancher"), "main");
    public static final ModelLayerLocation PB_THICC_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "thicc"), "main");
    public static final ModelLayerLocation PB_DEFAULT_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "default"), "main");
    public static final ModelLayerLocation PB_DEFAULT_CRYSTAL_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "default_crystal"), "main");
    public static final ModelLayerLocation PB_DEFAULT_SHELL_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "default_shell"), "main");
    public static final ModelLayerLocation PB_DEFAULT_FOLIAGE_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "default_foliage"), "main");
    public static final ModelLayerLocation PB_ELVIS_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "elvis"), "main");
    public static final ModelLayerLocation PB_SMALL_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "small"), "main");
    public static final ModelLayerLocation PB_SLIM_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "slim"), "main");
    public static final ModelLayerLocation PB_TINY_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "tiny"), "main");
    public static final ModelLayerLocation PB_SLIMY_LAYER = new ModelLayerLocation(new ResourceLocation("productivebees", "translucent_with_center"), "main");
    protected boolean isChristmas;

    public ProductiveBeeRenderer(EntityRendererProvider.Context context) {
        this(context, new ProductiveBeeModel<ProductiveBee>(context.m_174023_(PB_MAIN_LAYER)));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_THICC_LAYER), "thicc", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_DEFAULT_LAYER), "default", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_DEFAULT_CRYSTAL_LAYER), "default_crystal", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_DEFAULT_SHELL_LAYER), "default_shell", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_DEFAULT_FOLIAGE_LAYER), "default_foliage", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_ELVIS_LAYER), "elvis", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_SMALL_LAYER), "small", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_SLIM_LAYER), "slim", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_TINY_LAYER), "tiny", this.isChristmas));
        this.m_115326_(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.m_174023_(PB_SLIMY_LAYER), "translucent_with_center", this.isChristmas));
    }

    public ProductiveBeeRenderer(EntityRendererProvider.Context context, ProductiveBeeModel<ProductiveBee> model) {
        super(context, model, 0.4f);
        Calendar calendar = Calendar.getInstance();
        if (((Boolean)ProductiveBeesConfig.CLIENT.alwaysChristmas.get()).booleanValue() || calendar.get(2) + 1 == 12 && calendar.get(5) >= 21 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    protected void setupRotations(ProductiveBee entity, PoseStack matrixStack, float f1, float f2, float f3) {
        ConfigurableBee configurableBee;
        super.m_7523_((LivingEntity)entity, matrixStack, f1, f2, f3);
        if (entity instanceof ConfigurableBee && (configurableBee = (ConfigurableBee)entity).getRenderTransform().equals("flipped")) {
            matrixStack.m_85837_(0.0, (double)(entity.m_20206_() + 0.1f), 0.0);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    @Nullable
    protected RenderType getRenderType(ProductiveBee bee, boolean b1, boolean b2, boolean b3) {
        if (bee instanceof ConfigurableBee && ((ConfigurableBee)bee).isTranslucent()) {
            return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(bee));
        }
        return super.m_7225_((LivingEntity)bee, b1, b2, b3);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(ProductiveBee bee) {
        Object textureLocation = "productivebees:textures/entity/bee/" + bee.getBeeName() + "/bee";
        if (bee instanceof BumbleBee && bee.m_8077_() && bee.m_7770_().getString().equals("Bleh")) {
            textureLocation = "productivebees:textures/entity/bee/" + bee.getBeeName() + "_bleh/bee";
        }
        if (bee.isColored()) {
            String modelType = bee.getRenderer();
            textureLocation = "productivebees:textures/entity/bee/base/" + modelType + "/bee";
        }
        if (bee instanceof ConfigurableBee && ((ConfigurableBee)bee).hasBeeTexture()) {
            textureLocation = ((ConfigurableBee)bee).getBeeTexture();
        }
        if (bee.m_21660_()) {
            textureLocation = (String)textureLocation + "_angry";
        }
        if (bee.m_27856_()) {
            textureLocation = (String)textureLocation + "_nectar";
        }
        return ProductiveBeeRenderer.resLoc((String)textureLocation + ".png");
    }

    public static ResourceLocation resLoc(String key) {
        if (!resLocCache.containsKey(key)) {
            resLocCache.put(key, new ResourceLocation(key));
        }
        return resLocCache.get(key);
    }
}

