/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import cy.jdkdigital.productivebees.ProductiveBees;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class OptionalCopyBlockState
extends LootItemConditionalFunction {
    final Block block;
    final Set<Property<?>> properties;

    OptionalCopyBlockState(LootItemCondition[] lootItemConditions, Block pBlock, Set<Property<?>> pStatePredicate) {
        super(lootItemConditions);
        this.block = pBlock;
        this.properties = pStatePredicate;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ProductiveBees.OPTIONAL_BLOCK_STATE_PROPERTY.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81461_);
    }

    protected ItemStack m_7372_(ItemStack p_80060_, LootContext p_80061_) {
        BlockState blockstate = (BlockState)p_80061_.m_78953_(LootContextParams.f_81461_);
        if (blockstate != null) {
            CompoundTag compoundtag1;
            CompoundTag compoundtag = p_80060_.m_41784_();
            if (compoundtag.m_128425_("BlockStateTag", 10)) {
                compoundtag1 = compoundtag.m_128469_("BlockStateTag");
            } else {
                compoundtag1 = new CompoundTag();
                compoundtag.m_128365_("BlockStateTag", (Tag)compoundtag1);
            }
            this.properties.stream().filter(arg_0 -> ((BlockState)blockstate).m_61138_(arg_0)).forEach(p_80072_ -> compoundtag1.m_128359_(p_80072_.m_61708_(), OptionalCopyBlockState.serialize(blockstate, p_80072_)));
        }
        return p_80060_;
    }

    public static Builder copyState(Block p_80063_) {
        return new Builder(p_80063_);
    }

    private static <T extends Comparable<T>> String serialize(BlockState p_80065_, Property<T> p_80066_) {
        Comparable t = p_80065_.m_61143_(p_80066_);
        return p_80066_.m_6940_(t);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Block block;
        private final Set<Property<?>> properties = Sets.newHashSet();

        Builder(Block p_80079_) {
            this.block = p_80079_;
        }

        public Builder copy(Property<?> property) {
            if (!this.block.m_49965_().m_61092_().contains(property)) {
                throw new IllegalStateException("Property " + property + " is not present on block " + this.block);
            }
            this.properties.add(property);
            return this;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new OptionalCopyBlockState(this.m_80699_(), this.block, this.properties);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<OptionalCopyBlockState> {
        public void serialize(JsonObject json, OptionalCopyBlockState optionalCopyBlockState, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)optionalCopyBlockState, serializationContext);
            json.addProperty("block", BuiltInRegistries.f_256975_.m_7981_((Object)optionalCopyBlockState.block).toString());
            JsonArray jsonarray = new JsonArray();
            optionalCopyBlockState.properties.forEach(property -> {
                if (property != null) {
                    jsonarray.add(property.m_61708_());
                }
            });
            json.add("properties", (JsonElement)jsonarray);
        }

        public OptionalCopyBlockState deserialize(JsonObject p_80093_, JsonDeserializationContext p_80094_, LootItemCondition[] p_80095_) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)p_80093_, (String)"block"));
            Block block = BuiltInRegistries.f_256975_.m_6612_(resourcelocation).orElse(Blocks.f_50016_);
            StateDefinition statedefinition = block.m_49965_();
            HashSet set = Sets.newHashSet();
            JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)p_80093_, (String)"properties", (JsonArray)null);
            if (jsonarray != null) {
                jsonarray.forEach(json -> set.add(statedefinition.m_61081_(GsonHelper.m_13805_((JsonElement)json, (String)"property"))));
            }
            return new OptionalCopyBlockState(p_80095_, block, set);
        }
    }
}

