/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.setup.HiveType;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockstateProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, BlockStateGenerator> blockstates = new HashMap<ResourceLocation, BlockStateGenerator>();
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();
    protected final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = this.models::put;

    public BlockstateProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ModBlocks.HIVELIST.forEach((modid, strings) -> strings.forEach((id, type) -> {
            String name = id;
            id = modid.equals("productivebees") ? id : modid + "_" + id;
            ProductiveBees.LOGGER.info("\"block.productivebees.advanced_" + id + "_beehive\": \"Advanced " + this.capName(name) + " Beehive\",");
            ProductiveBees.LOGGER.info("\"block.productivebees.expansion_box_" + id + "\": \"" + this.capName(name) + " Expansion Box\",");
        }));
        ModBlocks.hiveStyles.forEach(style -> {
            ProductiveBees.LOGGER.info("\"block.productivebees.advanced_" + style + "_canvas_beehive\": \"Advanced Canvas Beehive\",");
            ProductiveBees.LOGGER.info("\"block.productivebees.expansion_box_" + style + "_canvas\": \"Canvas Expansion Box\",");
        });
        try {
            this.registerStatesAndModels();
        }
        catch (Exception e) {
            ProductiveBees.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        this.blockstates.forEach((id, stateGenerator) -> {
            Path path = blockstatePathProvider.m_245731_(id);
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)stateGenerator.get()), (Path)path));
        });
        for (Map.Entry<ResourceLocation, Supplier<JsonElement>> e : this.models.entrySet()) {
            ResourceLocation modelId = e.getKey();
            Path path = modelPathProvider.m_245731_(modelId);
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)e.getValue().get(), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Productive Bees Blockstate and Model generator";
    }

    protected void registerStatesAndModels() {
        ArrayList completedTypes = new ArrayList();
        ModBlocks.HIVELIST.forEach((modid, strings) -> {
            if (ProductiveBees.isDevEnv || ModList.get().isLoaded(modid)) {
                strings.forEach((name, type) -> {
                    String string = name = modid.equals("productivebees") ? name : modid + "_" + name;
                    if (!completedTypes.contains(name)) {
                        completedTypes.add(name);
                        Block hive = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees", "advanced_" + name + "_beehive"));
                        Block box = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees", "expansion_box_" + name));
                        BlockstateProvider.generateModels(hive, box, name, type, this.blockstates, this.modelOutput);
                    }
                });
            }
        });
        ModBlocks.hiveStyles.forEach(style -> {
            Block hive = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees", "advanced_" + style + "_canvas_beehive"));
            Block box = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivebees", "expansion_box_" + style + "_canvas"));
            BlockstateProvider.generateModels(hive, box, style + "_canvas", new HiveType(false, "", (String)style, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42647_})), this.blockstates, this.modelOutput);
        });
        for (DyeColor color : DyeColor.values()) {
            this.generateHoneyModels(color);
        }
    }

    public static void generateModels(Block hive, Block box, String name, HiveType type, Map<ResourceLocation, BlockStateGenerator> blockstates, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        String modId = ForgeRegistries.BLOCKS.getKey((Object)hive).m_135827_();
        ModelTemplate hiveTemplate = BlockstateProvider.getHiveModelTemplate();
        ModelTemplate expansionTemplate = BlockstateProvider.getExpansionModelTemplate();
        TextureMapping textureMap = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.NONE, name, false) : new TextureMapping();
        TextureMapping textureMapUp = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.UP, name, false) : new TextureMapping();
        TextureMapping textureMapDown = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.DOWN, name, false) : new TextureMapping();
        TextureMapping textureMapLeft = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.LEFT, name, false) : new TextureMapping();
        TextureMapping textureMapRight = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.RIGHT, name, false) : new TextureMapping();
        TextureMapping textureMapBack = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.BACK, name, false) : new TextureMapping();
        TextureMapping textureMapHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.NONE, name, true) : new TextureMapping();
        TextureMapping textureMapUpHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.UP, name, true) : new TextureMapping();
        TextureMapping textureMapDownHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.DOWN, name, true) : new TextureMapping();
        TextureMapping textureMapLeftHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.LEFT, name, true) : new TextureMapping();
        TextureMapping textureMapRightHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.RIGHT, name, true) : new TextureMapping();
        TextureMapping textureMapBackHoney = type.hasTexture() ? BlockstateProvider.getHiveTextureMap(VerticalHive.BACK, name, true) : new TextureMapping();
        String hiveModelBase = "block/hives/advanced_" + name + "_beehive";
        ResourceLocation singleModel = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase), textureMap, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/small");
        ResourceLocation upModel = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_up"), textureMapUp, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/up");
        ResourceLocation downModel = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_down"), textureMapDown, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/down");
        ResourceLocation leftModel = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_left"), textureMapLeft, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/left");
        ResourceLocation rightModel = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_right"), textureMapRight, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/right");
        ResourceLocation backModel = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_back"), textureMapBack, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/back");
        ResourceLocation singleModelHoney = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_honey"), textureMapHoney, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/small_honey");
        ResourceLocation upModelHoney = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_up_honey"), textureMapUpHoney, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/up_honey");
        ResourceLocation downModelHoney = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_down_honey"), textureMapDownHoney, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/down_honey");
        ResourceLocation leftModelHoney = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_left_honey"), textureMapLeftHoney, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/left_honey");
        ResourceLocation rightModelHoney = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_right_honey"), textureMapRightHoney, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/right_honey");
        ResourceLocation backModelHoney = type.hasTexture() ? hiveTemplate.m_125612_(new ResourceLocation("productivebees", hiveModelBase + "_back_honey"), textureMapBackHoney, modelOutput) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/back_honey");
        blockstates.put(new ResourceLocation(modId, "advanced_" + name + "_beehive"), (BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)hive).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125329_((Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125329_((Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125329_((Comparable)Direction.NORTH, Variant.m_125501_())).m_125271_(PropertyDispatch.m_125296_(AdvancedBeehive.EXPANDED, (Property)BlockStateProperties.f_61421_).m_125362_((expanded, level) -> switch (expanded) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalHive.NONE -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(level.compareTo(5) >= 0 ? singleModelHoney : singleModel));
            case VerticalHive.UP -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(level.compareTo(5) >= 0 ? upModelHoney : upModel));
            case VerticalHive.DOWN -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(level.compareTo(5) >= 0 ? downModelHoney : downModel));
            case VerticalHive.LEFT -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(level.compareTo(5) >= 0 ? leftModelHoney : leftModel));
            case VerticalHive.RIGHT -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(level.compareTo(5) >= 0 ? rightModelHoney : rightModel));
            case VerticalHive.BACK -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(level.compareTo(5) >= 0 ? backModelHoney : backModel));
        })));
        BlockstateProvider.getItemTemplate(type.hasTexture() ? new ResourceLocation(modId, hiveModelBase) : new ResourceLocation("productivebees", "block/tinted_hive/" + type.style() + "/small")).m_125612_(new ResourceLocation(modId, "item/advanced_" + name + "_beehive"), new TextureMapping(), modelOutput);
        TextureMapping expansionTextureMap = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.NONE, name) : new TextureMapping();
        TextureMapping expansionTextureMapUp = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.UP, name) : new TextureMapping();
        TextureMapping expansionTextureMapDown = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.DOWN, name) : new TextureMapping();
        TextureMapping expansionTextureMapLeft = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.LEFT, name) : new TextureMapping();
        TextureMapping expansionTextureMapRight = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.RIGHT, name) : new TextureMapping();
        TextureMapping expansionTextureMapBack = type.hasTexture() ? BlockstateProvider.getExpansionTextureMap(VerticalHive.BACK, name) : new TextureMapping();
        String boxModelBase = "block/expansion_boxes/expansion_box_" + name;
        ResourceLocation expansionSingleModel = type.hasTexture() ? expansionTemplate.m_125612_(new ResourceLocation("productivebees", boxModelBase), expansionTextureMap, modelOutput) : new ResourceLocation("productivebees", "block/tinted_expansion_box/" + type.style() + "/small");
        ResourceLocation expansionUpModel = type.hasTexture() ? expansionTemplate.m_125612_(new ResourceLocation("productivebees", boxModelBase + "_up"), expansionTextureMapUp, modelOutput) : new ResourceLocation("productivebees", "block/tinted_expansion_box/" + type.style() + "/up");
        ResourceLocation expansionDownModel = type.hasTexture() ? expansionTemplate.m_125612_(new ResourceLocation("productivebees", boxModelBase + "_down"), expansionTextureMapDown, modelOutput) : new ResourceLocation("productivebees", "block/tinted_expansion_box/" + type.style() + "/down");
        ResourceLocation expansionLeftModel = type.hasTexture() ? expansionTemplate.m_125612_(new ResourceLocation("productivebees", boxModelBase + "_left"), expansionTextureMapLeft, modelOutput) : new ResourceLocation("productivebees", "block/tinted_expansion_box/" + type.style() + "/left");
        ResourceLocation expansionRightModel = type.hasTexture() ? expansionTemplate.m_125612_(new ResourceLocation("productivebees", boxModelBase + "_right"), expansionTextureMapRight, modelOutput) : new ResourceLocation("productivebees", "block/tinted_expansion_box/" + type.style() + "/right");
        ResourceLocation expansionBackModel = type.hasTexture() ? expansionTemplate.m_125612_(new ResourceLocation("productivebees", boxModelBase + "_back"), expansionTextureMapBack, modelOutput) : new ResourceLocation("productivebees", "block/tinted_expansion_box/" + type.style() + "/back");
        blockstates.put(new ResourceLocation(modId, "expansion_box_" + name), (BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)box).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125329_((Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125329_((Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125329_((Comparable)Direction.NORTH, Variant.m_125501_())).m_125271_(PropertyDispatch.m_125294_(AdvancedBeehive.EXPANDED).m_125335_(expanded -> switch (expanded) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalHive.NONE -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)expansionSingleModel);
            case VerticalHive.UP -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)expansionUpModel);
            case VerticalHive.DOWN -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)expansionDownModel);
            case VerticalHive.LEFT -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)expansionLeftModel);
            case VerticalHive.RIGHT -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)expansionRightModel);
            case VerticalHive.BACK -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)expansionBackModel);
        })));
        BlockstateProvider.getItemTemplate(type.hasTexture() ? new ResourceLocation(modId, boxModelBase) : new ResourceLocation("productivebees", "block/tinted_expansion_box/" + type.style() + "/small")).m_125612_(new ResourceLocation(modId, "item/expansion_box_" + name), new TextureMapping(), modelOutput);
    }

    private void generateHoneyModels(DyeColor color) {
        ResourceLocation id = new ResourceLocation("productivebees", color.m_7912_() + "_petrified_honey");
        ResourceLocation modelLocation = new ResourceLocation("productivebees", "block/petrified_honey/" + color.m_7912_());
        Block honey = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
        ModelTemplate modelTemplate = BlockstateProvider.getHoneyBlockModelTemplate();
        modelTemplate.m_266561_(new ResourceLocation("productivebees", "block/petrified_honey/" + color.m_7912_()), this.getHoneyBlockTextureMap(color), this.modelOutput, (rLoc, textureMap) -> {
            JsonObject json = modelTemplate.m_266532_(rLoc, textureMap);
            json.addProperty("render_type", "translucent");
            return json;
        });
        this.blockstates.put(id, (BlockStateGenerator)BlockstateProvider.createSimpleBlock(honey, modelLocation));
        BlockstateProvider.getItemTemplate(modelLocation).m_125612_(new ResourceLocation("productivebees", "item/" + id.m_135815_()), new TextureMapping(), this.modelOutput);
    }

    public static TextureMapping getHiveTextureMap(VerticalHive expand, String type, boolean hasHoney) {
        ResourceLocation top;
        ResourceLocation front = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_front" + (hasHoney ? "_honey" : ""));
        ResourceLocation back = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side");
        ResourceLocation right = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side");
        ResourceLocation left = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side");
        ResourceLocation bottom = top = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_end");
        switch (expand) {
            case UP: 
            case DOWN: {
                front = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_front_" + expand + (hasHoney ? "_honey" : ""));
                right = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand);
                left = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand);
                back = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand);
                break;
            }
            case LEFT: 
            case RIGHT: {
                front = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_front_" + expand.opposite() + (hasHoney ? "_honey" : ""));
                back = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand);
                bottom = top = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_end_" + expand);
                break;
            }
            case BACK: {
                right = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_left");
                left = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_right");
                top = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_end_front");
                bottom = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_end_back");
            }
        }
        return new TextureMapping().m_125758_(TextureSlot.f_125878_, right).m_125758_(TextureSlot.f_125879_, left).m_125758_(TextureSlot.f_125873_, front).m_125758_(TextureSlot.f_125872_, top).m_125758_(TextureSlot.f_125871_, bottom).m_125758_(TextureSlot.f_125874_, back).m_176477_(TextureSlot.f_125878_, TextureSlot.f_125869_);
    }

    public static TextureMapping getExpansionTextureMap(VerticalHive expand, String type) {
        ResourceLocation top;
        ResourceLocation front = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side");
        ResourceLocation back = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side");
        ResourceLocation left = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side");
        ResourceLocation right = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side");
        ResourceLocation bottom = top = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_end");
        switch (expand) {
            case UP: 
            case DOWN: {
                front = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand.opposite());
                left = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand.opposite());
                right = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand.opposite());
                back = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand.opposite());
                break;
            }
            case LEFT: 
            case RIGHT: {
                front = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand);
                back = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_" + expand.opposite());
                bottom = top = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_end_" + expand.opposite());
                break;
            }
            case BACK: {
                left = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_left");
                right = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_side_right");
                top = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_end_back");
                bottom = new ResourceLocation("productivebees", "block/advanced_beehive/" + type + "_beehive_end_front");
            }
        }
        return new TextureMapping().m_125758_(TextureSlot.f_125878_, right).m_125758_(TextureSlot.f_125879_, left).m_125758_(TextureSlot.f_125873_, front).m_125758_(TextureSlot.f_125872_, top).m_125758_(TextureSlot.f_125871_, bottom).m_125758_(TextureSlot.f_125874_, back).m_176477_(TextureSlot.f_125878_, TextureSlot.f_125869_);
    }

    private TextureMapping getHoneyBlockTextureMap(DyeColor color) {
        return new TextureMapping().m_125758_(TextureSlot.f_125880_, new ResourceLocation("productivebees", "block/petrified_honey/" + color.m_7912_() + "_top")).m_125758_(TextureSlot.f_125881_, new ResourceLocation("productivebees", "block/petrified_honey/" + color.m_7912_() + "_bottom")).m_125758_(TextureSlot.f_125875_, new ResourceLocation("productivebees", "block/petrified_honey/" + color.m_7912_() + "_side")).m_176477_(TextureSlot.f_125880_, TextureSlot.f_125869_);
    }

    public static ModelTemplate getHiveModelTemplate() {
        return new ModelTemplate(Optional.of(new ResourceLocation("productivebees", "block/advanced_beehive_template")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125871_, TextureSlot.f_125878_, TextureSlot.f_125879_, TextureSlot.f_125873_, TextureSlot.f_125874_});
    }

    public static ModelTemplate getExpansionModelTemplate() {
        return new ModelTemplate(Optional.of(new ResourceLocation("productivebees", "block/expansion_box_template")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125871_, TextureSlot.f_125878_, TextureSlot.f_125879_, TextureSlot.f_125873_, TextureSlot.f_125874_});
    }

    public static ModelTemplate getHoneyBlockModelTemplate() {
        return new ModelTemplate(Optional.of(new ResourceLocation("block/honey_block")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125881_, TextureSlot.f_125880_, TextureSlot.f_125875_, TextureSlot.f_125869_});
    }

    public static ModelTemplate getItemTemplate(ResourceLocation parent) {
        return new ModelTemplate(Optional.of(parent), Optional.empty(), new TextureSlot[0]);
    }

    public static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation id) {
        return MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id));
    }

    private String capName(String name) {
        CharSequence[] nameParts = name.split("_");
        for (int i = 0; i < nameParts.length; ++i) {
            nameParts[i] = ((String)nameParts[i]).substring(0, 1).toUpperCase() + ((String)nameParts[i]).substring(1);
        }
        return String.join((CharSequence)" ", nameParts);
    }
}

