/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CombineGeneRecipe
implements CraftingRecipe {
    public final ResourceLocation id;

    public CombineGeneRecipe(ResourceLocation id) {
        this.id = id;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        int numberOfIngredients = 0;
        Pair addedGene = null;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_().equals(ModItems.GENE.get())) {
                ++numberOfIngredients;
                String attribute = Gene.getAttributeName(itemstack);
                if (addedGene == null) {
                    addedGene = Pair.of((Object)attribute, (Object)Gene.getValue(itemstack));
                    continue;
                }
                if (((String)addedGene.getFirst()).equals(attribute) && ((Integer)addedGene.getSecond()).equals(Gene.getValue(itemstack)) && Gene.getPurity(itemstack) != 100) continue;
                return false;
            }
            return false;
        }
        return numberOfIngredients > 1;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            stacks.add(inv.m_8020_(j));
        }
        return CombineGeneRecipe.mergeGenes(stacks);
    }

    public static ItemStack mergeGenes(List<ItemStack> stacks) {
        String attribute = null;
        int value = 0;
        int purity = 0;
        for (ItemStack stack : stacks) {
            if (stack.m_41619_() || !stack.m_41720_().equals(ModItems.GENE.get())) continue;
            attribute = Gene.getAttributeName(stack);
            value = Gene.getValue(stack);
            purity = Math.min(100, purity + Gene.getPurity(stack));
        }
        if (attribute != null) {
            return Gene.getStack(attribute, value, 1, purity);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)ModItems.GENE.get());
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.GENE.get())}));
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.GENE.get())}));
        return list;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.GENE_GENE.get();
    }

    public static class Serializer<T extends CombineGeneRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            return this.factory.create(id);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading gene recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
        }

        public static interface IRecipeFactory<T extends CombineGeneRecipe> {
            public T create(ResourceLocation var1);
        }
    }
}

