/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.recipe.TagOutputRecipe;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.items.ItemHandlerHelper;

public class CentrifugeRecipe
extends TagOutputRecipe
implements Recipe<Container>,
TimedRecipeInterface {
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final Map<String, Integer> fluidOutput;
    private final Integer processingTime;

    public CentrifugeRecipe(ResourceLocation id, Ingredient ingredient, Map<Ingredient, IntArrayTag> itemOutput, Map<String, Integer> fluidOutput, int processingTime) {
        super(itemOutput);
        this.id = id;
        this.ingredient = ingredient;
        this.fluidOutput = fluidOutput;
        this.processingTime = processingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime > 0 ? this.processingTime : (Integer)ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.get();
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (this.ingredient.m_43908_().length > 0) {
            ItemStack invStack = inv.m_8020_(1);
            if (!this.ingredient.test(invStack)) {
                return false;
            }
            for (ItemStack stack : this.ingredient.m_43908_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)invStack, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nullable
    public Pair<Fluid, Integer> getFluidOutputs() {
        for (Map.Entry<String, Integer> entry : this.fluidOutput.entrySet()) {
            Fluid fluid = CentrifugeRecipe.getPreferredFluidByMod(entry.getKey());
            if (fluid == Fluids.f_76191_) continue;
            return Pair.of((Object)fluid, (Object)entry.getValue());
        }
        return null;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.CENTRIFUGE.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get();
    }

    public static class Serializer<T extends CentrifugeRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"outputs");
            LinkedHashMap<Ingredient, IntArrayTag> itemOutputs = new LinkedHashMap<Ingredient, IntArrayTag>();
            LinkedHashMap<String, Integer> fluidOutputs = new LinkedHashMap<String, Integer>();
            jsonArray.forEach(el -> {
                JsonObject jsonObject = el.getAsJsonObject();
                if (jsonObject.has("item")) {
                    int min = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"min", (int)1);
                    int max = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"max", (int)1);
                    int chance = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"chance", (int)100);
                    IntArrayTag nbt = new IntArrayTag(new int[]{min, max, chance});
                    Ingredient produce = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)jsonObject, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"item"));
                    itemOutputs.put(produce, nbt);
                } else if (jsonObject.has("fluid")) {
                    int amount = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"amount", (int)250);
                    JsonObject fluidJson = GsonHelper.m_13930_((JsonObject)jsonObject, (String)"fluid");
                    String fluidResourceLocation = "";
                    if (fluidJson.has("tag")) {
                        fluidResourceLocation = GsonHelper.m_13906_((JsonObject)fluidJson, (String)"tag");
                    } else if (fluidJson.has("fluid")) {
                        fluidResourceLocation = GsonHelper.m_13906_((JsonObject)fluidJson, (String)"fluid");
                    }
                    fluidOutputs.put(fluidResourceLocation, amount);
                }
            });
            int processingTime = json.has("processingTime") ? json.get("processingTime").getAsInt() : 0;
            return this.factory.create(id, ingredient, itemOutputs, fluidOutputs, processingTime);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                LinkedHashMap<Ingredient, IntArrayTag> itemOutput = new LinkedHashMap<Ingredient, IntArrayTag>();
                IntStream.range(0, buffer.readInt()).forEach(i -> itemOutput.put(Ingredient.m_43940_((FriendlyByteBuf)buffer), new IntArrayTag(new int[]{buffer.readInt(), buffer.readInt(), buffer.readInt()})));
                LinkedHashMap<String, Integer> fluidOutput = new LinkedHashMap<String, Integer>();
                IntStream.range(0, buffer.readInt()).forEach(i -> fluidOutput.put(buffer.m_130277_(), buffer.readInt()));
                return this.factory.create(id, ingredient, itemOutput, fluidOutput, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading centrifuge recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull T recipe) {
            try {
                ((CentrifugeRecipe)recipe).ingredient.m_43923_(buffer);
                buffer.writeInt(((CentrifugeRecipe)recipe).itemOutput.size());
                ((CentrifugeRecipe)recipe).itemOutput.forEach((key, value) -> {
                    key.m_43923_(buffer);
                    buffer.writeInt(value.get(0).m_7047_());
                    buffer.writeInt(value.get(1).m_7047_());
                    buffer.writeInt(value.get(2).m_7047_());
                });
                buffer.writeInt(((CentrifugeRecipe)recipe).fluidOutput.size());
                ((CentrifugeRecipe)recipe).fluidOutput.forEach((key, value) -> {
                    buffer.m_130070_(key);
                    buffer.writeInt(value.intValue());
                });
                buffer.writeInt(((CentrifugeRecipe)recipe).getProcessingTime());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing centrifuge recipe to packet. " + ((CentrifugeRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends CentrifugeRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Map<Ingredient, IntArrayTag> var3, Map<String, Integer> var4, Integer var5);
        }
    }
}

