/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.FilterUpgradeItem;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AdvancedBeehiveBlockEntity
extends AdvancedBeehiveBlockEntityAbstract
implements MenuProvider,
UpgradeableBlockEntity {
    protected int tickCounter = 0;
    private int abandonCountdown = 0;
    protected boolean hasTicked = false;
    protected LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(12, (BlockEntity)this){

        @Override
        public boolean isInputSlotItem(int slot, ItemStack item) {
            if (slot == 11 && this.isInputSlot(slot)) {
                return item.m_41720_() instanceof BeeCage;
            }
            if (slot == 0 && item.m_150930_(Blocks.f_50056_.m_5456_())) {
                return true;
            }
            return super.isInputSlotItem(slot, item);
        }

        @Override
        public boolean isInputSlot(int slot) {
            AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity;
            BlockEntity blockEntity;
            return super.isInputSlot(slot) || slot == 11 && (blockEntity = this.blockEntity) instanceof AdvancedBeehiveBlockEntity && (advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)blockEntity).isSim();
        }

        @Override
        protected void onContentsChanged(int slot) {
            Level level;
            ItemStack itemInBottleSlot;
            super.onContentsChanged(slot);
            if (slot == 0 && !(itemInBottleSlot = this.getStackInSlot(0)).m_41619_() && itemInBottleSlot.m_150930_(Blocks.f_50056_.m_5456_()) && (level = this.blockEntity.m_58904_()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_46597_(this.blockEntity.m_58899_(), (BlockState)level2.m_8055_(this.blockEntity.m_58899_()).m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)));
            }
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this));

    public AdvancedBeehiveBlockEntity(AdvancedBeehive hiveBlock, BlockPos pos, BlockState state) {
        this(hiveBlock.getBlockEntitySupplier().get(), pos, state);
    }

    public AdvancedBeehiveBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.MAX_BEES = 3;
    }

    @Nonnull
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new AdvancedBeehiveContainer(windowId, playerInventory, this);
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public boolean m_58777_() {
        return true;
    }

    public boolean isSim() {
        return (Boolean)ProductiveBeesConfig.BEES.allowBeeSimulation.get() != false && (this.getUpgradeCount((Item)ModItems.UPGRADE_SIMULATOR.get()) > 0 || this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY_3.get()) > 0 || this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY_4.get()) > 0);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AdvancedBeehiveBlockEntity blockEntity) {
        if (!blockEntity.hasTicked && ++blockEntity.tickCounter > (Integer)ProductiveBeesConfig.GENERAL.hiveTickRate.get()) {
            EntityType beeType;
            ConfigurableBee newBee;
            List bees;
            blockEntity.tickCounter = 0;
            BlockPos front = pos.m_121945_((Direction)state.m_61143_((Property)BeehiveBlock.f_49563_));
            if (level.f_46441_.m_188500_() <= (Double)ProductiveBeesConfig.BEES.spawnUndeadBeesChance.get() && level.m_46462_() && level.m_8055_(front).m_60812_((BlockGetter)level, front).m_83281_() && blockEntity.m_58776_() + blockEntity.beesOutsideHive() == 0 && level.m_45517_(LightLayer.BLOCK, front) == 0 && (bees = level.m_45976_(Bee.class, new AABB(pos).m_82377_(3.0, 3.0, 3.0))).size() < (Integer)ProductiveBeesConfig.UPGRADES.breedingMaxNearbyEntities.get() && (newBee = (ConfigurableBee)(beeType = (EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(level)) != null) {
                if (level.f_46441_.m_188499_()) {
                    newBee.setBeeType("productivebees:skeletal");
                } else {
                    newBee.setBeeType("productivebees:zombie");
                }
                newBee.setDefaultAttributes();
                newBee.f_27698_ = pos;
                blockEntity.m_58741_((Entity)newBee, false);
            }
        }
        if (!blockEntity.hasTicked && blockEntity.tickCounter % 23 == 0 && state.m_60734_() instanceof AdvancedBeehive) {
            int honeyLevel = (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_);
            if (honeyLevel >= 5) {
                int finalHoneyLevel = honeyLevel;
                blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
                    ItemStack bottles = inv.getStackInSlot(0);
                    if (!bottles.m_41619_() && bottles.m_41720_() instanceof BottleItem) {
                        boolean addedBottle;
                        ItemStack filledBottle = new ItemStack((ItemLike)Items.f_42787_);
                        boolean bl = addedBottle = ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(filledBottle).m_41613_() == 0;
                        if (addedBottle) {
                            ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(new ItemStack((ItemLike)Items.f_42784_));
                            bottles.m_41774_(1);
                            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(finalHoneyLevel - 5)));
                        }
                    }
                });
                honeyLevel = (Integer)level.m_8055_(pos).m_61143_((Property)BeehiveBlock.f_49564_);
            }
            if (state.m_61143_(AdvancedBeehive.EXPANDED) != VerticalHive.NONE && honeyLevel >= AdvancedBeehiveBlockEntity.getMaxHoneyLevel(state)) {
                ((AdvancedBeehive)state.m_60734_()).updateState(level, pos, state, false);
            }
            if (blockEntity.isSim()) {
                blockEntity.inventoryHandler.ifPresent(h -> {
                    if (h instanceof InventoryHandlerHelper.ItemHandler) {
                        InventoryHandlerHelper.ItemHandler invHelper = (InventoryHandlerHelper.ItemHandler)((Object)h);
                        ItemStack cageStack = h.getStackInSlot(11);
                        if (!cageStack.m_41619_() && cageStack.m_41720_() instanceof BeeCage) {
                            if (BeeCage.isFilled(cageStack) && (!cageStack.m_41720_().equals(ModItems.STURDY_BEE_CAGE.get()) || invHelper.canFitStacks(List.of(new ItemStack((ItemLike)cageStack.m_41720_()))))) {
                                Bee bee;
                                if (!blockEntity.m_58775_() && (bee = BeeCage.getEntityFromStack(cageStack, level, true)) != null && blockEntity.acceptsBee(bee) && !(bee instanceof SolitaryBee)) {
                                    blockEntity.m_58741_((Entity)bee, bee.m_27856_());
                                    if (cageStack.m_41720_().equals(ModItems.STURDY_BEE_CAGE.get())) {
                                        invHelper.addOutput(new ItemStack((ItemLike)cageStack.m_41720_()));
                                    }
                                    cageStack.m_41774_(1);
                                    level.m_7260_(pos, state, state, 3);
                                }
                            } else if (!blockEntity.m_58774_()) {
                                blockEntity.getCapability(CapabilityBee.BEE).ifPresent(inhabitantStorage -> {
                                    Iterator<AdvancedBeehiveBlockEntityAbstract.Inhabitant> inhabitantIterator = inhabitantStorage.getInhabitants().iterator();
                                    AdvancedBeehiveBlockEntityAbstract.Inhabitant inhabitant = inhabitantIterator.next();
                                    Entity entity = EntityType.m_20645_((CompoundTag)inhabitant.nbt, (Level)level, spawnedEntity -> spawnedEntity);
                                    if (entity instanceof Bee) {
                                        Bee beeEntity = (Bee)entity;
                                        beeEntity.f_27698_ = blockEntity.f_58858_;
                                        ItemStack filledCage = new ItemStack((ItemLike)cageStack.m_41720_());
                                        BeeCage.captureEntity(beeEntity, filledCage);
                                        if (invHelper.canFitStacks(List.of(new ItemStack((ItemLike)cageStack.m_41720_())))) {
                                            cageStack.m_41774_(1);
                                            invHelper.addOutput(filledCage);
                                            inhabitantIterator.remove();
                                            level.m_7260_(pos, state, state, 3);
                                        }
                                    }
                                });
                            }
                        }
                    }
                });
            }
        }
        if (--blockEntity.abandonCountdown < 0) {
            blockEntity.abandonCountdown = 0;
        }
        AdvancedBeehiveBlockEntityAbstract.tick(level, pos, state, blockEntity);
        blockEntity.hasTicked = false;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    protected int getTimeInHive(boolean hasNectar, @Nullable Bee beeEntity) {
        double timeUpgradeModifier = Math.max(0.0, 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get());
        return (int)((double)super.getTimeInHive(hasNectar, beeEntity) * timeUpgradeModifier + 20.0);
    }

    @Override
    protected void beeReleasePostAction(@Nonnull Level level, Bee beeEntity, BlockState state, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        super.beeReleasePostAction(level, beeEntity, state, beeState);
        if (beeState == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) {
            int samplerUpgrades;
            int breedingUpgrades;
            ProductiveBee productiveBee;
            if (!(beeEntity instanceof ProductiveBee) || !(productiveBee = (ProductiveBee)beeEntity).hasConverted()) {
                this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
                    BeeHelper.getBeeProduce(level, beeEntity, this.getUpgradeCount((Item)ModItems.UPGRADE_COMB_BLOCK.get()) + this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY_4.get()) > 0).forEach(stackIn -> {
                        ItemStack stack = stackIn.m_41777_();
                        if (!stack.m_41619_()) {
                            int productivity;
                            if (beeEntity instanceof ProductiveBee && (productivity = ((ProductiveBee)beeEntity).getAttributeValue(BeeAttributes.PRODUCTIVITY).intValue()) > 0) {
                                if (stack.m_41613_() == 1) {
                                    stack.m_41769_(productivity);
                                } else {
                                    float modifier = (1.0f / ((float)productivity + 2.0f) + ((float)productivity + 1.0f) / 2.0f) * (float)stack.m_41613_();
                                    stack.m_41769_(Math.round(modifier));
                                }
                            }
                            int ProductivityUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY.get());
                            int productivity2Upgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY_2.get());
                            int productivity3Upgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY_3.get());
                            int productivity4Upgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_PRODUCTIVITY_4.get());
                            double upgradeMod = (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier.get() * (double)ProductivityUpgrades;
                            upgradeMod += (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier2.get() * (double)productivity2Upgrades;
                            upgradeMod += (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier3.get() * (double)productivity3Upgrades;
                            if ((upgradeMod += (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier4.get() * (double)productivity4Upgrades) >= 1.0) {
                                double newStackSize = (double)stack.m_41613_() * upgradeMod;
                                stack.m_41764_(Math.round((float)newStackSize));
                            }
                            ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(stack);
                        }
                    });
                    ItemStack itemInBottleSlot = inv.getStackInSlot(0);
                    if (!itemInBottleSlot.m_41619_() && itemInBottleSlot.m_150930_(Blocks.f_50056_.m_5456_())) {
                        level.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)));
                    }
                });
            }
            if ((breedingUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_BREEDING.get())) > 0 && !beeEntity.m_6162_() && this.m_58776_() > 0 && (double)level.f_46441_.m_188501_() <= (Double)ProductiveBeesConfig.UPGRADES.breedingChance.get() * (double)breedingUpgrades) {
                List bees;
                boolean canBreed;
                boolean bl = canBreed = !(beeEntity instanceof ProductiveBee) || ((ProductiveBee)beeEntity).canSelfBreed();
                if (canBreed && (bees = level.m_45976_(Bee.class, new AABB(this.f_58858_).m_82377_(5.0, 5.0, 5.0))).size() < (Integer)ProductiveBeesConfig.UPGRADES.breedingMaxNearbyEntities.get()) {
                    Entity offspring;
                    AdvancedBeehiveBlockEntityAbstract.Inhabitant otherBeeInhabitant = this.getBeeList().get(level.f_46441_.m_188503_(this.m_58776_()));
                    Entity otherBee = EntityType.m_20645_((CompoundTag)otherBeeInhabitant.nbt, (Level)level, spawnedEntity -> spawnedEntity);
                    if (otherBee instanceof Bee && (offspring = BeeHelper.getBreedingResult(beeEntity, (AgeableMob)((Bee)otherBee), (ServerLevel)this.f_58857_)) != null) {
                        if (offspring instanceof ProductiveBee && beeEntity instanceof ProductiveBee) {
                            BeeHelper.setOffspringAttributes((ProductiveBee)offspring, (ProductiveBee)beeEntity, (AgeableMob)((Bee)otherBee));
                        }
                        if (offspring instanceof AgeableMob) {
                            ((AgeableMob)offspring).m_146762_(-24000);
                        }
                        BlockPos frontPos = this.m_58899_().m_121945_((Direction)state.m_61143_((Property)BeehiveBlock.f_49563_));
                        offspring.m_7678_((double)frontPos.m_123341_(), (double)((float)frontPos.m_123342_() + 0.5f), (double)frontPos.m_123343_(), 0.0f, 0.0f);
                        level.m_7967_(offspring);
                    }
                }
            }
            if ((samplerUpgrades = this.getUpgradeCount((Item)ModItems.UPGRADE_BEE_SAMPLER.get())) > 0 && !beeEntity.m_6162_() && beeEntity instanceof ProductiveBee && (double)level.f_46441_.m_188501_() <= (Double)ProductiveBeesConfig.UPGRADES.samplerChance.get() * (double)samplerUpgrades) {
                this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
                    Map<BeeAttribute<Integer>, Object> attributes = ((ProductiveBee)beeEntity).getBeeAttributes();
                    int attr = level.f_46441_.m_188503_(attributes.size() + 2);
                    if (attr >= BeeAttributes.attributeList().size()) {
                        String type = beeEntity instanceof ConfigurableBee ? ((ConfigurableBee)beeEntity).getBeeType() : beeEntity.m_20078_();
                        ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(Gene.getStack(type, level.f_46441_.m_188503_(4) + 1));
                    } else {
                        BeeAttribute<Integer> attribute = BeeAttributes.map.get(BeeAttributes.attributeList().get(attr));
                        Integer value = ((ProductiveBee)beeEntity).getAttributeValue(attribute);
                        ((InventoryHandlerHelper.ItemHandler)((Object)inv)).addOutput(Gene.getStack(attribute, (int)value, 1, level.f_46441_.m_188503_(4) + 1));
                    }
                });
            }
        }
        this.abandonCountdown += this.getTimeInHive(true, beeEntity);
    }

    protected int beesOutsideHive() {
        int timeInHive = this.getTimeInHive(true, null);
        return timeInHive > 0 ? (int)Math.ceil(this.abandonCountdown % timeInHive) : 0;
    }

    @Override
    public boolean acceptsUpgrades() {
        return this.m_58900_().m_61143_(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
    }

    @Override
    public boolean acceptsBee(Bee bee) {
        boolean isInFilters = false;
        List filters = this.getInstalledUpgrades((Item)ModItems.UPGRADE_FILTER.get());
        for (ItemStack filter : filters) {
            List<Supplier<BeeIngredient>> allowedBees = FilterUpgradeItem.getAllowedBees(filter);
            for (Supplier<BeeIngredient> allowedBee : allowedBees) {
                String type = BeeIngredientFactory.getIngredientKey(bee);
                if (!allowedBee.get().getBeeType().toString().equals(type)) continue;
                isInFilters = true;
            }
        }
        return filters.size() == 0 || isInFilters;
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        CompoundTag invTag = tag.m_128469_("inv");
        this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((Tag)invTag));
        CompoundTag upgradesTag = tag.m_128469_("upgrades");
        this.upgradeHandler.ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((Tag)upgradesTag));
        this.MAX_BEES = tag.m_128441_("max_bees") ? tag.m_128451_("max_bees") : this.MAX_BEES;
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)inv).serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        });
        this.upgradeHandler.ifPresent(inv -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)inv).serializeNBT();
            tag.m_128365_("upgrades", (Tag)compound);
        });
        tag.m_128405_("max_bees", this.MAX_BEES);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

