/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BumbleBee;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BeeBodyLayer
extends RenderLayer<ProductiveBee, ProductiveBeeModel<ProductiveBee>> {
    private final String modelType;
    private final EntityModel<ProductiveBee> model;
    private final boolean isChristmas;
    Map<String, Map<String, ResourceLocation>> baseTextures = new HashMap<String, Map<String, ResourceLocation>>(){
        {
            this.put("default", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", new ResourceLocation("productivebees", "textures/entity/bee/base/default/primary.png"));
                    this.put("abdomen", new ResourceLocation("productivebees", "textures/entity/bee/base/default/abdomen.png"));
                }
            });
            this.put("default_crystal", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", new ResourceLocation("productivebees", "textures/entity/bee/base/default_crystal/primary.png"));
                    this.put("abdomen", new ResourceLocation("productivebees", "textures/entity/bee/base/default_crystal/abdomen.png"));
                    this.put("crystals", new ResourceLocation("productivebees", "textures/entity/bee/base/default_crystal/crystals.png"));
                    this.put("crystals_clear", new ResourceLocation("productivebees", "textures/entity/bee/base/default_crystal/crystals_clear.png"));
                }
            });
            this.put("default_foliage", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", new ResourceLocation("productivebees", "textures/entity/bee/base/default_foliage/primary.png"));
                    this.put("abdomen", new ResourceLocation("productivebees", "textures/entity/bee/base/default_foliage/abdomen.png"));
                    this.put("crystals", new ResourceLocation("productivebees", "textures/entity/bee/base/default_foliage/crystals.png"));
                }
            });
            this.put("default_shell", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", new ResourceLocation("productivebees", "textures/entity/bee/base/default_shell/primary.png"));
                    this.put("abdomen", new ResourceLocation("productivebees", "textures/entity/bee/base/default_shell/abdomen.png"));
                    this.put("crystals", new ResourceLocation("productivebees", "textures/entity/bee/base/default_shell/crystals.png"));
                }
            });
            this.put("thicc", new HashMap<String, ResourceLocation>(){
                {
                    this.put("primary", new ResourceLocation("productivebees", "textures/entity/bee/base/thicc/primary.png"));
                    this.put("abdomen", new ResourceLocation("productivebees", "textures/entity/bee/base/thicc/abdomen.png"));
                }
            });
        }
    };

    public BeeBodyLayer(RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>> rendererIn, ModelPart layer, String modelType, boolean isChristmas) {
        super(rendererIn);
        this.modelType = modelType;
        this.model = new ProductiveBeeModel(layer, modelType);
        this.isChristmas = isChristmas;
    }

    public void render(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.getRenderer().equals(this.modelType) && !entity.m_20145_()) {
            ((ProductiveBeeModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (entity instanceof ConfigurableBee && ((ConfigurableBee)entity).isTranslucent()) {
                VertexConsumer vertexBuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_117347_((Entity)entity)));
                this.model.m_7695_(matrixStackIn, vertexBuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                BeeBodyLayer.m_117376_(this.model, (ResourceLocation)this.m_117347_((Entity)entity), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (entity.isColored()) {
                this.renderColoredLayers(matrixStackIn, bufferIn, packedLightIn, entity, partialTicks);
            } else if (entity instanceof ConfigurableBee) {
                ConfigurableBee cBee = (ConfigurableBee)entity;
                if (this.modelType.equals("default_crystal") && cBee.useGlowLayer()) {
                    this.renderCrystalLayer(matrixStackIn, bufferIn, packedLightIn, entity, partialTicks);
                }
            }
            if (entity.m_27856_() && !entity.hasConverted()) {
                this.renderNectarLayer(matrixStackIn, bufferIn, packedLightIn, entity);
            }
            this.renderChristmasHat(matrixStackIn, bufferIn, packedLightIn, entity);
            this.renderSaddle(matrixStackIn, bufferIn, packedLightIn, entity);
        }
    }

    private void renderColoredLayers(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity, float partialTicks) {
        float[] primaryColor = entity.getColor(0, partialTicks);
        ResourceLocation location = this.baseTextures.get(this.modelType).get("primary");
        BeeBodyLayer.m_117376_(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)primaryColor[0], (float)primaryColor[1], (float)primaryColor[2]);
        float[] secondaryColor = entity.getColor(1, partialTicks);
        ResourceLocation abdomenLocation = this.baseTextures.get(this.modelType).get("abdomen");
        BeeBodyLayer.m_117376_(this.model, (ResourceLocation)abdomenLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)secondaryColor[0], (float)secondaryColor[1], (float)secondaryColor[2]);
        if (this.modelType.equals("default_crystal")) {
            this.renderCrystalLayer(matrixStackIn, bufferIn, packedLightIn, entity, partialTicks);
        } else if (this.modelType.equals("default_foliage") || this.modelType.equals("default_shell")) {
            float[] color = primaryColor;
            if (entity instanceof ConfigurableBee) {
                color = ((ConfigurableBee)entity).getTertiaryColor(partialTicks);
            }
            ResourceLocation foliageLocation = this.baseTextures.get(this.modelType).get("crystals");
            BeeBodyLayer.m_117376_(this.model, (ResourceLocation)foliageLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)color[0], (float)color[1], (float)color[2]);
        }
    }

    private void renderCrystalLayer(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, ProductiveBee entity, float partialTicks) {
        boolean useGlowLayer;
        float[] color = entity.getColor(0, partialTicks);
        boolean bl = useGlowLayer = !entity.getRenderStatic();
        if (entity instanceof ConfigurableBee) {
            color = ((ConfigurableBee)entity).getTertiaryColor(partialTicks);
            useGlowLayer = useGlowLayer && ((ConfigurableBee)entity).useGlowLayer();
        }
        ResourceLocation crystalsLocation = this.baseTextures.get(this.modelType).get("crystals_clear");
        BeeBodyLayer.m_117376_(this.model, (ResourceLocation)crystalsLocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)color[0], (float)color[1], (float)color[2]);
        if (useGlowLayer) {
            ResourceLocation crystalsOverlayLocation = this.baseTextures.get(this.modelType).get("crystals");
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)crystalsOverlayLocation));
            this.model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        }
    }

    private void renderNectarLayer(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        if (entity.isColored()) {
            float[] colors = new float[]{1.0f, 1.0f, 1.0f};
            if (entity instanceof ConfigurableBee) {
                if (((ConfigurableBee)entity).hasBeeTexture()) {
                    return;
                }
                if (((ConfigurableBee)entity).hasParticleColor()) {
                    colors = ((ConfigurableBee)entity).getParticleColor();
                }
            }
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/base/" + this.modelType + "/pollen.png");
            BeeBodyLayer.m_117376_(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)colors[0], (float)colors[1], (float)colors[2]);
        }
    }

    private void renderChristmasHat(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        if (this.isChristmas && !entity.getRenderStatic() && this.modelType.contains("default")) {
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/base/" + this.modelType + "/santa_hat.png");
            BeeBodyLayer.m_117376_(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderSaddle(@Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull ProductiveBee entity) {
        BumbleBee bumbleBee;
        if (entity instanceof BumbleBee && (bumbleBee = (BumbleBee)entity).m_6254_()) {
            ResourceLocation location = ProductiveBeeRenderer.resLoc("productivebees:textures/entity/bee/bumble" + (bumbleBee.m_8077_() && bumbleBee.m_7770_().getString().equals("Bleh") ? "_bleh" : "") + "/saddle.png");
            BeeBodyLayer.m_117376_(this.model, (ResourceLocation)location, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

