/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncEntityHacks {
    private final int entityId;
    private final List<ResourceLocation> ids;

    public PacketSyncEntityHacks(Entity target, List<ResourceLocation> ids) {
        this.entityId = target.m_19879_();
        this.ids = ids;
    }

    public PacketSyncEntityHacks(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        int size = buf.m_130242_();
        this.ids = new ArrayList<ResourceLocation>(size);
        for (int i = 0; i < size; ++i) {
            this.ids.add(buf.m_130281_());
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130130_(this.ids.size());
        this.ids.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity e = ClientUtils.getClientLevel().m_6815_(this.entityId);
            if (e != null) {
                e.getCapability(PNCCapabilities.HACKING_CAPABILITY).ifPresent(hacking -> {
                    for (ResourceLocation id : this.ids) {
                        CommonArmorRegistry.getInstance().getHackableEntityForId(id).ifPresent(hacking::addHackable);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

