/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.AphorismTileBlock;
import me.desht.pneumaticcraft.common.block.entity.AphorismTileBlockEntity;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;

public class PacketAphorismTileUpdate
extends LocationIntPacket {
    private static final int MAX_LENGTH = 1024;
    private final String[] text;
    private final int textRotation;
    private final byte margin;
    private final boolean invis;

    public PacketAphorismTileUpdate(FriendlyByteBuf buffer) {
        super(buffer);
        this.textRotation = buffer.readByte();
        int lines = buffer.m_130242_();
        this.text = new String[lines];
        for (int i = 0; i < lines; ++i) {
            this.text[i] = buffer.m_130136_(1024);
        }
        this.margin = buffer.readByte();
        this.invis = buffer.readBoolean();
    }

    public PacketAphorismTileUpdate(AphorismTileBlockEntity tile) {
        super(tile.m_58899_());
        this.text = tile.getTextLines();
        this.textRotation = tile.textRotation;
        this.margin = tile.getMarginSize();
        this.invis = (Boolean)tile.m_58900_().m_61143_((Property)AphorismTileBlock.INVISIBLE);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeByte(this.textRotation);
        buffer.m_130130_(this.text.length);
        Arrays.stream(this.text).forEach(s -> buffer.m_130072_(s, 1024));
        buffer.writeByte((int)this.margin);
        buffer.writeBoolean(this.invis);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player = (Player)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender());
            if (PneumaticCraftUtils.canPlayerReach(player, this.pos)) {
                PneumaticCraftUtils.getTileEntityAt((BlockGetter)player.m_9236_(), this.pos, AphorismTileBlockEntity.class).ifPresent(te -> {
                    te.setTextLines(this.text, false);
                    te.textRotation = this.textRotation;
                    te.setMarginSize(this.margin);
                    te.setInvisible(this.invis);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

