/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.common.block.FluidMixerBlock;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class JEIFluidMixerCategory
extends AbstractPNCCategory<FluidMixerRecipe> {
    private final ITickTimer tickTimer = JEIFluidMixerCategory.guiHelper().createTickTimer(60, 60, false);
    private final IDrawableAnimated progressBar;

    public JEIFluidMixerCategory() {
        super(RecipeTypes.FLUID_MIXER, (Component)PneumaticCraftUtils.xlate(((FluidMixerBlock)ModBlocks.FLUID_MIXER.get()).m_7705_(), new Object[0]), (IDrawable)JEIFluidMixerCategory.guiHelper().createDrawable(Textures.GUI_JEI_FLUID_MIXER, 0, 0, 166, 70), JEIFluidMixerCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FLUID_MIXER.get())));
        IDrawableStatic d = JEIFluidMixerCategory.guiHelper().createDrawable(Textures.GUI_FLUID_MIXER, 180, 0, 44, 30);
        this.progressBar = JEIFluidMixerCategory.guiHelper().createAnimatedDrawable(d, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidMixerRecipe recipe, IFocusGroup focuses) {
        FluidStack in1 = recipe.getInput1().getFluidStacks().get(0);
        FluidStack in2 = recipe.getInput2().getFluidStacks().get(0);
        FluidStack outF = recipe.getOutputFluid();
        int[] amounts = new int[]{in1.getAmount(), in2.getAmount(), outF.getAmount()};
        int max = Arrays.stream(amounts).max().getAsInt();
        int inH1 = Math.min(64, in1.getAmount() * 64 / max);
        int inH2 = Math.min(64, in2.getAmount() * 64 / max);
        int outH = Math.min(64, outF.getAmount() * 64 / max);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 3 + (64 - inH1)).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getInput1().getFluidStacks())).setFluidRenderer((long)in1.getAmount(), false, 16, inH1).setOverlay(Helpers.makeTankOverlay(inH1), 0, 0);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 28, 3 + (64 - inH2)).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getInput2().getFluidStacks())).setFluidRenderer((long)in2.getAmount(), false, 16, inH2).setOverlay(Helpers.makeTankOverlay(inH2), 0, 0);
        if (!recipe.getOutputFluid().isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 3 + (64 - outH)).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singletonList(outF))).setFluidRenderer((long)outF.getAmount(), false, 16, outH).setOverlay(Helpers.makeTankOverlay(outH), 0, 0);
        }
        if (!recipe.getOutputItem().m_41619_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 64, 51).addItemStack(recipe.getOutputItem());
        }
    }

    public void draw(FluidMixerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        float pressure = recipe.getRequiredPressure() * ((float)this.tickTimer.getValue() / (float)this.tickTimer.getMaxValue());
        PressureGaugeRenderer2D.drawPressureGauge(graphics, Minecraft.m_91087_().f_91062_, -1.0f, 7.0f, 5.0f, recipe.getRequiredPressure(), pressure, 138, 35);
        this.progressBar.draw(graphics, 45, 20);
    }

    public List<Component> getTooltipStrings(FluidMixerRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> res = new ArrayList<Component>();
        if (recipe.getRequiredPressure() > 0.0f && mouseX >= 117.0 && mouseY >= 15.0 && mouseX <= 157.0 && mouseY <= 55.0) {
            res.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", Float.valueOf(recipe.getRequiredPressure())));
        } else if (mouseX >= 45.0 && mouseY >= 20.0 && mouseX <= 89.0 && mouseY <= 50.0) {
            res.add((Component)Component.m_237113_((String)((float)recipe.getProcessingTime() / 20.0f + "s")));
            res.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.processingTime", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        return res;
    }
}

