/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Calendar;
import java.util.Locale;
import me.desht.pneumaticcraft.common.core.ModParticleTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class AirParticleData
implements ParticleOptions {
    public static final AirParticleData NORMAL = new AirParticleData(0.1f);
    public static final AirParticleData DENSE = new AirParticleData(0.3f);
    public static final ParticleOptions.Deserializer<AirParticleData> DESERIALIZER = new ParticleOptions.Deserializer<AirParticleData>(){

        public AirParticleData fromCommand(ParticleType<AirParticleData> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float alpha = stringReader.readFloat();
            return new AirParticleData(alpha);
        }

        public AirParticleData fromNetwork(ParticleType<AirParticleData> particleType, FriendlyByteBuf packetBuffer) {
            return new AirParticleData(packetBuffer.readFloat());
        }
    };
    static final Codec<AirParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("alpha").forGetter(d -> Float.valueOf(d.alpha))).apply((Applicative)instance, AirParticleData::new));
    private static boolean checkedDate;
    private static boolean useAlt;
    private final float alpha;

    public AirParticleData(float alpha) {
        this.alpha = alpha;
    }

    public ParticleType<?> m_6012_() {
        return this.useAltParticles() ? (ParticleType)ModParticleTypes.AIR_PARTICLE_2.get() : (ParticleType)ModParticleTypes.AIR_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeFloat(this.alpha);
    }

    public String m_5942_() {
        ResourceLocation regName = PneumaticCraftUtils.getRegistryName(ForgeRegistries.PARTICLE_TYPES, this.m_6012_()).orElseThrow();
        return String.format(Locale.ROOT, "%s %f", regName, Float.valueOf(this.alpha));
    }

    public float getAlpha() {
        return useAlt ? this.alpha * 2.0f : this.alpha;
    }

    private boolean useAltParticles() {
        if (!checkedDate) {
            Calendar calendar = Calendar.getInstance();
            useAlt = calendar.get(2) == 3 && calendar.get(5) == 1;
            checkedDate = true;
        }
        return useAlt;
    }
}

