/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModSounds;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModVillagers {
    public static final DeferredRegister<PoiType> POI = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"pneumaticcraft");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"pneumaticcraft");
    public static final RegistryObject<PoiType> MECHANIC_POI = POI.register("mechanic", () -> new PoiType(ModVillagers.getAllStates((Block)ModBlocks.CHARGING_STATION.get()), 1, 1));
    public static final RegistryObject<VillagerProfession> MECHANIC = ModVillagers.registerProfession("mechanic", MECHANIC_POI, ModSounds.SHORT_HISS);

    private static RegistryObject<VillagerProfession> registerProfession(String name, RegistryObject<PoiType> poiType, RegistryObject<SoundEvent> sound) {
        return PROFESSIONS.register(name, () -> ModVillagers.register(PneumaticRegistry.RL(name), poiType, (SoundEvent)sound.get()));
    }

    private static VillagerProfession register(ResourceLocation name, RegistryObject<PoiType> poi, SoundEvent sound) {
        ResourceKey poiName = Objects.requireNonNull(poi.getKey());
        return new VillagerProfession(name.toString(), holder -> holder.m_203565_(poiName), holder -> holder.m_203565_(poiName), ImmutableSet.of(), ImmutableSet.of(), sound);
    }

    private static Set<BlockState> getAllStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_());
    }
}

