/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import it.unimi.dsi.fastutil.floats.FloatPredicate;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureHelper;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.capabilities.BasicAirHandler;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;

public class MachineAirHandler
extends BasicAirHandler
implements IAirHandlerMachine,
IManoMeasurable {
    private final PressureTier tier;
    private int volumeUpgrades = 0;
    private final BitSet connectedFaces = new BitSet(6);
    private Direction leakDir = null;
    private Direction prevLeakDir = null;
    private int prevAir;
    private final Map<Direction, LazyOptional<IAirHandlerMachine>> neighbourAirHandlers = new EnumMap<Direction, LazyOptional<IAirHandlerMachine>>(Direction.class);
    private boolean safetyLeaking;
    private Direction safetyLeakDir;
    private FloatPredicate safetyPredicate;

    public MachineAirHandler(PressureTier tier, int volume) {
        super(volume);
        this.tier = tier;
        for (Direction dir : DirectionUtil.VALUES) {
            this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)LazyOptional.empty());
        }
    }

    @Override
    public int getVolume() {
        return PressureHelper.getUpgradedVolume(this.getBaseVolume(), this.volumeUpgrades);
    }

    @Override
    public float getDangerPressure() {
        return this.tier.getDangerPressure();
    }

    @Override
    public float getCriticalPressure() {
        return this.tier.getCriticalPressure();
    }

    @Override
    public void setPressure(float pressure) {
        this.addAir((int)(pressure * (float)this.getVolume()) - this.getAir());
    }

    @Override
    public void setVolumeUpgrades(int newVolumeUpgrades) {
        int newVolume = PressureHelper.getUpgradedVolume(this.getBaseVolume(), newVolumeUpgrades);
        if (newVolume < this.getVolume()) {
            int newAir = (int)((float)this.getAir() * (float)newVolume / (float)this.getVolume());
            this.addAir(newAir - this.getAir());
        }
        this.volumeUpgrades = newVolumeUpgrades;
    }

    @Override
    public void enableSafetyVenting(FloatPredicate pressureCheck, Direction dir) {
        this.safetyLeakDir = dir;
        this.safetyPredicate = pressureCheck;
    }

    @Override
    public void disableSafetyVenting() {
        this.safetyLeakDir = null;
        this.safetyPredicate = null;
    }

    @Override
    public void setConnectedFaces(List<Direction> sides) {
        this.connectedFaces.clear();
        sides.forEach(side -> this.connectedFaces.set(side.m_122411_()));
        for (Direction dir : DirectionUtil.VALUES) {
            this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)LazyOptional.empty());
        }
    }

    @Override
    public void tick(BlockEntity ownerTE) {
        Level world = Objects.requireNonNull(ownerTE.m_58904_());
        Direction actualLeakDir = this.leakDir;
        if (!world.f_46443_) {
            this.disperseAir(ownerTE);
            BlockPos pos = ownerTE.m_58899_();
            if (this.safetyLeakDir != null) {
                float pressure = this.getPressure();
                if (!this.safetyLeaking && this.safetyPredicate.test(pressure)) {
                    this.safetyLeaking = true;
                } else if (this.safetyLeaking && !this.safetyPredicate.test(pressure + 0.2f)) {
                    this.safetyLeaking = false;
                }
                if (pressure >= this.getCriticalPressure()) {
                    int wanted = (int)(this.getCriticalPressure() * (float)this.getVolume());
                    this.addAir(wanted - this.getAir());
                }
            } else if (Objects.requireNonNull(world.m_7654_()).m_129921_() > 20) {
                this.doOverpressureChecks(ownerTE, world, pos);
            }
            Direction direction = actualLeakDir = this.safetyLeaking ? this.safetyLeakDir : this.leakDir;
            if (this.prevLeakDir != actualLeakDir || actualLeakDir != null && (world.m_46467_() & 0x1FL) == 0L) {
                NetworkHandler.sendToAllTracking((Object)new PacketUpdatePressureBlock(ownerTE, this.anyConnectedFace(), actualLeakDir, this.getAir()), ownerTE);
            }
            this.prevAir = this.getAir();
            this.prevLeakDir = actualLeakDir;
        }
        if (actualLeakDir != null && this.getAir() != 0) {
            this.handleAirLeak(ownerTE, actualLeakDir);
        }
    }

    private Direction anyConnectedFace() {
        for (Direction d : DirectionUtil.VALUES) {
            if (!this.connectedFaces.get(d.m_122411_())) continue;
            return d;
        }
        return null;
    }

    private void doOverpressureChecks(BlockEntity ownerTE, Level world, BlockPos pos) {
        float p = this.getPressure();
        if (this.getAir() > this.prevAir && p > this.getDangerPressure()) {
            float range = this.getCriticalPressure() - this.getDangerPressure();
            float delta = p - this.getDangerPressure();
            float rnd = world.f_46441_.m_188501_() * range;
            if (rnd < delta / 125.0f || p > this.getCriticalPressure()) {
                world.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.0f, Level.ExplosionInteraction.BLOCK);
                world.m_46961_(pos, false);
                PneumaticRegistry.getInstance().getMiscHelpers().forceClientShapeRecalculation(world, pos);
            } else if (rnd < delta / 25.0f) {
                world.m_5594_(null, ownerTE.m_58899_(), (SoundEvent)ModSounds.CREAK.get(), SoundSource.BLOCKS, 0.7f, 0.6f + world.f_46441_.m_188501_() * 0.8f);
            }
        }
    }

    private void handleAirLeak(BlockEntity ownerTE, Direction actualLeakDir) {
        Level world = Objects.requireNonNull(ownerTE.m_58904_());
        BlockPos pos = ownerTE.m_58899_();
        float pressure = this.getPressure();
        if (!world.f_46443_) {
            if (this.getAir() > 0) {
                int leakedAmount = (int)(pressure * 40.0f) + 20;
                if (leakedAmount > this.getAir()) {
                    leakedAmount = this.getAir();
                }
                this.onAirDispersion(ownerTE, this.leakDir, -leakedAmount);
                this.addAir(-leakedAmount);
            } else if (this.getAir() < 0) {
                int leakedAmount = -((int)(pressure * 40.0f)) + 20;
                if (this.getAir() > leakedAmount) {
                    leakedAmount = -this.getAir();
                }
                this.onAirDispersion(ownerTE, this.leakDir, leakedAmount);
                this.addAir(leakedAmount);
            }
        } else {
            double mx = actualLeakDir.m_122429_();
            double my = actualLeakDir.m_122430_();
            double mz = actualLeakDir.m_122431_();
            double speed = this.getPressure() * 0.1f;
            if (this.getAir() > 0) {
                if (pressure > 1.0f || pressure > 0.5f && world.f_46441_.m_188499_() || world.f_46441_.m_188503_(3) == 0) {
                    world.m_7106_((ParticleOptions)AirParticleData.DENSE, (double)pos.m_123341_() + 0.5 + mx * 0.6, (double)pos.m_123342_() + 0.5 + my * 0.6, (double)pos.m_123343_() + 0.5 + mz * 0.6, mx * speed, my * speed, mz * speed);
                }
            } else if (this.getAir() < 0 && world.f_46441_.m_188499_()) {
                world.m_7106_((ParticleOptions)AirParticleData.DENSE, (double)pos.m_123341_() + 0.5 + mx, (double)pos.m_123342_() + 0.5 + my, (double)pos.m_123343_() + 0.5 + mz, mx * speed, my * speed, mz * speed);
            }
            MovingSounds.playMovingSound(MovingSounds.Sound.AIR_LEAK, ownerTE.m_58899_(), this.anyConnectedFace());
        }
    }

    @Override
    public void setSideLeaking(@Nullable Direction dir) {
        this.leakDir = dir;
    }

    @Override
    @Nullable
    public Direction getSideLeaking() {
        return this.leakDir;
    }

    private LazyOptional<IAirHandlerMachine> getNeighbourAirHandler(BlockEntity ownerTE, Direction dir) {
        if (!this.connectedFaces.get(dir.m_122411_())) {
            return LazyOptional.empty();
        }
        if (!this.neighbourAirHandlers.get(dir).isPresent()) {
            BlockEntity te1 = Objects.requireNonNull(ownerTE.m_58904_()).m_7702_(ownerTE.m_58899_().m_121945_(dir));
            if (te1 != null) {
                LazyOptional cap = te1.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, dir.m_122424_());
                if (cap.isPresent()) {
                    this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)cap);
                    this.neighbourAirHandlers.get(dir).addListener(l -> this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)LazyOptional.empty()));
                }
            } else {
                this.neighbourAirHandlers.put(dir, (LazyOptional<IAirHandlerMachine>)LazyOptional.empty());
            }
        }
        return this.neighbourAirHandlers.get(dir);
    }

    private void disperseAir(BlockEntity ownerTE) {
        List<IAirHandlerMachine.Connection> neighbours = this.getConnectedAirHandlers(ownerTE, true);
        int totalVolume = this.getVolume();
        int totalAir = this.getAir();
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            totalVolume += neighbour.getAirHandler().getVolume();
            totalAir += neighbour.getAirHandler().getAir();
        }
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            int totalMachineAir = (int)((long)totalAir * (long)neighbour.getAirHandler().getVolume() / (long)totalVolume);
            neighbour.setMaxDispersion(this.getMaxDispersion(ownerTE, neighbour.getDirection()));
            neighbour.setAirToDisperse(Math.max(0, totalMachineAir - neighbour.getAirHandler().getAir()));
        }
        for (IAirHandlerMachine.Connection neighbour : neighbours) {
            int air = Math.min(neighbour.getMaxDispersion(), neighbour.getDispersedAir());
            if (air == 0) continue;
            this.onAirDispersion(ownerTE, neighbour.getDirection(), air);
            neighbour.getAirHandler().addAir(air);
            this.addAir(-air);
        }
    }

    private List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity ownerTE, boolean onlyLowerPressure) {
        ArrayList<IAirHandlerMachine.Connection> neighbours = new ArrayList<IAirHandlerMachine.Connection>();
        for (Direction dir : DirectionUtil.VALUES) {
            if (!this.connectedFaces.get(dir.m_122411_())) continue;
            this.getNeighbourAirHandler(ownerTE, dir).ifPresent(h -> {
                if (!onlyLowerPressure || h.getPressure() < this.getPressure()) {
                    neighbours.add(new ConnectedAirHandler(dir, (IAirHandlerMachine)h));
                }
            });
        }
        neighbours.addAll(this.addExtraConnectedHandlers(ownerTE).stream().filter(h -> !onlyLowerPressure || h.getPressure() < this.getPressure()).map(ConnectedAirHandler::new).toList());
        return neighbours;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.leakDir != null) {
            nbt.m_128344_("Leaking", (byte)this.leakDir.m_122411_());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.leakDir = nbt.m_128441_("Leaking") ? Direction.m_122376_((int)nbt.m_128445_("Leaking")) : null;
    }

    @Override
    public List<IAirHandlerMachine.Connection> getConnectedAirHandlers(BlockEntity ownerTE) {
        return this.getConnectedAirHandlers(ownerTE, false);
    }

    private List<IAirHandlerMachine> addExtraConnectedHandlers(BlockEntity ownerTE) {
        if (ownerTE instanceof IAirListener) {
            return ((IAirListener)ownerTE).addConnectedPneumatics(new ArrayList<IAirHandlerMachine>());
        }
        return Collections.emptyList();
    }

    private void onAirDispersion(BlockEntity ownerTE, Direction dir, int airDispersed) {
        if (ownerTE instanceof IAirListener) {
            ((IAirListener)ownerTE).onAirDispersion(this, dir, airDispersed);
        }
    }

    private int getMaxDispersion(BlockEntity ownerTE, Direction dir) {
        if (ownerTE instanceof IAirListener) {
            return ((IAirListener)ownerTE).getMaxDispersion(this, dir);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void printManometerMessage(Player player, List<Component> curInfo) {
        curInfo.add((Component)Component.m_237110_((String)"pneumaticcraft.gui.tooltip.pressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(this.getPressure(), 1)}));
    }

    private static class ConnectedAirHandler
    implements IAirHandlerMachine.Connection {
        final Direction direction;
        final IAirHandlerMachine airHandler;
        int maxDispersion;
        int toDisperse;

        ConnectedAirHandler(Direction direction, IAirHandlerMachine airHandler) {
            this.direction = direction;
            this.airHandler = airHandler;
        }

        ConnectedAirHandler(IAirHandlerMachine airHandler) {
            this(null, airHandler);
        }

        @Override
        public Direction getDirection() {
            return this.direction;
        }

        @Override
        public int getMaxDispersion() {
            return this.maxDispersion;
        }

        @Override
        public void setMaxDispersion(int maxDispersion) {
            this.maxDispersion = maxDispersion;
        }

        @Override
        public int getDispersedAir() {
            return this.toDisperse;
        }

        @Override
        public void setAirToDisperse(int toDisperse) {
            this.toDisperse = toDisperse;
        }

        @Override
        public IAirHandlerMachine getAirHandler() {
            return this.airHandler;
        }
    }
}

