/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.universal_sensor.IEventSensorSetting;
import me.desht.pneumaticcraft.api.universal_sensor.IPollSensorSetting;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorSetting;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.UniversalSensorScreen;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.UniversalSensorMenu;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ComputerEventManager;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.GlobalBlockEntityCacheManager;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class UniversalSensorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IGUITextFieldSensitive,
IMinWorkingPressure,
IRangedTE,
IRedstoneControl<UniversalSensorBlockEntity>,
MenuProvider {
    private static final List<RedstoneController.RedstoneMode<UniversalSensorBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<UniversalSensorBlockEntity>("universalSensor.normal", new ItemStack((ItemLike)Items.f_42451_), te -> true), new RedstoneController.EmittingRedstoneMode<UniversalSensorBlockEntity>("universalSensor.inverted", new ItemStack((ItemLike)Items.f_41978_), te -> true));
    private static final byte RS_MODE_NORMAL = 0;
    private static final byte RS_MODE_INVERTED = 1;
    private static final int BASE_RANGE = 8;
    @GuiSynced
    private String sensorSetting = "";
    private int tickTimer;
    public int redstoneStrength;
    private int redstonePulseCounter;
    public float dishRotation;
    public float oldDishRotation;
    private float dishSpeed;
    @GuiSynced
    private final RedstoneController<UniversalSensorBlockEntity> rsController = new RedstoneController<UniversalSensorBlockEntity>(this, REDSTONE_MODES);
    @DescSynced
    public boolean isSensorActive;
    @GuiSynced
    public String lastSensorExceptionText = "";
    @GuiSynced
    private String sensorGuiText = "";
    @GuiSynced
    public SensorStatus sensorStatus = SensorStatus.OK;
    private boolean requestPollPullEvent;
    private final Set<BlockPos> positions = new HashSet<BlockPos>();
    private final ItemStackHandler itemHandler = new UniversalSensorItemHandler();
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemHandler);
    @GuiSynced
    public int outOfRange;
    private final RangeManager rangeManager = new RangeManager(this, 1615876304);
    private UUID playerId;

    public UniversalSensorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.UNIVERSAL_SENSOR.get(), pos, state, PressureTier.TIER_ONE, 5000, 4);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.oldDishRotation = this.dishRotation;
        this.dishSpeed = this.isSensorActive ? Math.min(this.dishSpeed + 0.2f, 10.0f) : Math.max(this.dishSpeed - 0.2f, 0.0f);
        this.dishRotation += this.dishSpeed;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        boolean invertedRedstone = this.rsController.getCurrentMode() == 1;
        ++this.tickTimer;
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(this.sensorSetting);
        if (this.updateStatus(sensor) == SensorStatus.OK && this.getPressure() > this.getMinWorkingPressure()) {
            this.isSensorActive = true;
            this.addAir(-sensor.getAirUsage(this.m_58904_(), this.m_58899_()));
            if (sensor instanceof IPollSensorSetting) {
                IPollSensorSetting pollSensor = (IPollSensorSetting)sensor;
                if (this.tickTimer >= pollSensor.getPollFrequency(this)) {
                    try {
                        pollSensor.setPlayerContext(this.playerId);
                        int newRedstoneStrength = pollSensor.getRedstoneValue(this.m_58904_(), this.m_58899_(), this.getRange(), this.sensorGuiText);
                        if (invertedRedstone) {
                            newRedstoneStrength = 15 - newRedstoneStrength;
                        }
                        if (newRedstoneStrength != this.redstoneStrength) {
                            this.redstoneStrength = newRedstoneStrength;
                            if (this.requestPollPullEvent) {
                                this.notifyComputers(this.redstoneStrength);
                            }
                            this.updateNeighbours();
                        }
                        this.tickTimer = 0;
                    }
                    catch (Exception e) {
                        this.lastSensorExceptionText = e.getMessage() == null ? "" : e.getMessage();
                    }
                }
                this.redstonePulseCounter = 0;
            } else if (this.redstonePulseCounter > 0) {
                --this.redstonePulseCounter;
                if (this.redstonePulseCounter == 0 && this.redstoneStrength != (invertedRedstone ? 15 : 0)) {
                    this.redstoneStrength = invertedRedstone ? 15 : 0;
                    this.updateNeighbours();
                }
            }
        } else {
            this.isSensorActive = false;
            if (this.redstoneStrength != (invertedRedstone ? 15 : 0)) {
                this.redstoneStrength = invertedRedstone ? 15 : 0;
                this.updateNeighbours();
            }
        }
    }

    private void notifyComputers(Object ... params) {
        ComputerEventManager.getInstance().sendEvents(this, "universalSensor", params);
    }

    private SensorStatus updateStatus(ISensorSetting sensor) {
        this.sensorStatus = SensorStatus.OK;
        if (sensor != null) {
            if (sensor.needsGPSTool() && this.getPrimaryInventory().getStackInSlot(0).m_41619_()) {
                this.sensorStatus = SensorStatus.MISSING_GPS;
            } else {
                for (PNCUpgrade upgrade : sensor.getRequiredUpgrades()) {
                    if (this.getUpgrades(upgrade) != 0) continue;
                    this.sensorStatus = SensorStatus.MISSING_UPGRADE;
                    break;
                }
            }
        } else {
            this.sensorStatus = SensorStatus.NO_SENSOR;
        }
        return this.sensorStatus;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP;
    }

    public AABB getRenderBoundingBox() {
        return this.rangeManager.shouldShowRange() ? this.rangeManager.getExtents() : super.getRenderBoundingBox();
    }

    public void onEvent(Event event) {
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(this.sensorSetting);
        if (sensor instanceof IEventSensorSetting && this.getPressure() >= this.getMinWorkingPressure()) {
            int newRedstoneStrength = ((IEventSensorSetting)sensor).emitRedstoneOnEvent(event, this, this.getRange(), this.sensorGuiText);
            if (newRedstoneStrength != 0) {
                this.redstonePulseCounter = ((IEventSensorSetting)sensor).getRedstonePulseLength();
            }
            if (this.rsController.getCurrentMode() == 1) {
                newRedstoneStrength = 15 - newRedstoneStrength;
            }
            if (this.redstonePulseCounter > 0 && ThirdPartyManager.instance().isModTypeLoaded(ThirdPartyManager.ModType.COMPUTER)) {
                if (event instanceof PlayerInteractEvent) {
                    PlayerInteractEvent e = (PlayerInteractEvent)event;
                    this.notifyComputers(newRedstoneStrength, e.getPos().m_123341_(), e.getPos().m_123342_(), e.getPos().m_123343_());
                } else {
                    this.notifyComputers(newRedstoneStrength);
                }
            }
            if (newRedstoneStrength != this.redstoneStrength) {
                this.redstoneStrength = newRedstoneStrength;
                this.updateNeighbours();
            }
        }
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    private void setSensorSetting(String sensorPath) {
        this.sensorSetting = sensorPath;
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            UniversalSensorScreen.refreshIfOpen();
        }
    }

    private boolean setSensorSetting(ISensorSetting sensor) {
        if (this.areGivenUpgradesInserted(sensor.getRequiredUpgrades())) {
            this.setSensorSetting(sensor.getSensorPath());
            return true;
        }
        return false;
    }

    public String getSensorSetting() {
        return this.sensorSetting;
    }

    @Override
    public void onGuiUpdate() {
        this.setSensorSetting(this.sensorSetting);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        tag.m_128359_("sensorSetting", this.sensorSetting);
        tag.m_128350_("dishSpeed", this.dishSpeed);
        tag.m_128359_("sensorText", this.sensorGuiText);
        if (this.playerId != null) {
            tag.m_128359_("playerId", this.playerId.toString());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        this.setSensorSetting(tag.m_128461_("sensorSetting"));
        this.dishSpeed = tag.m_128457_("dishSpeed");
        this.sensorGuiText = tag.m_128461_("sensorText");
        if (tag.m_128425_("playerId", 8)) {
            this.playerId = UUID.fromString(tag.m_128461_("playerId"));
        }
        this.setupGPSPositions();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            this.redstoneStrength = 15 - this.redstoneStrength;
            this.updateNeighbours();
            return;
        }
        if (tag.equals("back")) {
            String[] folders = this.getSensorSetting().split("/");
            String newPath = this.getSensorSetting().replace(folders[folders.length - 1], "");
            if (newPath.endsWith("/")) {
                newPath = newPath.substring(0, newPath.length() - 1);
            }
            this.setSensorSetting(newPath);
            this.setText(0, "");
        } else if (tag.startsWith("set:")) {
            try {
                int t = Integer.parseInt(tag.split(":")[1]);
                String[] directories = SensorHandler.getInstance().getDirectoriesAtLocation(this.getSensorSetting());
                if (t / 10 <= directories.length) {
                    if (this.getSensorSetting().isEmpty()) {
                        this.setSensorSetting(directories[t / 10 - 1]);
                    } else {
                        this.setSensorSetting(this.getSensorSetting() + "/" + directories[t / 10 - 1]);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        this.rangeManager.setRange(this.getUpgrades(ModUpgrades.RANGE.get()) + 8);
        this.setupGPSPositions();
    }

    public boolean areGivenUpgradesInserted(Set<PNCUpgrade> requiredUpgrades) {
        for (PNCUpgrade upgrade : requiredUpgrades) {
            if (this.getUpgrades(upgrade) != 0) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Set<BlockPos> getGPSPositions() {
        return this.positions;
    }

    private void setupGPSPositions() {
        this.positions.clear();
        this.outOfRange = 0;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        Item item = stack.m_41720_();
        if (item instanceof IPositionProvider) {
            IPositionProvider p = (IPositionProvider)item;
            int sensorRange = this.getRange();
            List<BlockPos> posList = p.getStoredPositions(this.playerId, stack);
            List<BlockPos> gpsPositions = posList.stream().filter(pos -> pos != null && Math.abs(pos.m_123341_() - this.m_58899_().m_123341_()) <= sensorRange && Math.abs(pos.m_123342_() - this.m_58899_().m_123342_()) <= sensorRange && Math.abs(pos.m_123343_() - this.m_58899_().m_123343_()) <= sensorRange).toList();
            this.positions.addAll(gpsPositions);
            this.outOfRange = posList.size() - gpsPositions.size();
        }
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            UniversalSensorScreen.refreshIfOpen();
        }
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.sensorGuiText = text;
        ISensorSetting sensor = SensorHandler.getInstance().getSensorFromPath(this.sensorSetting);
        if (sensor != null) {
            try {
                this.lastSensorExceptionText = "";
                sensor.notifyTextChange(this.sensorGuiText);
            }
            catch (Exception e) {
                String string = this.lastSensorExceptionText = e.getMessage() == null ? "" : e.getMessage();
            }
        }
        if (!this.nonNullLevel().f_46443_) {
            this.scheduleDescriptionPacket();
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.sensorGuiText;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("getSensorNames"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return SensorHandler.getInstance().getSensorNames();
            }
        });
        registry.registerLuaMethod(new LuaMethod("setSensor"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 0, 1, "sensor_name?");
                if (args.length == 1) {
                    ISensorSetting sensor = args[0] instanceof String ? SensorHandler.getInstance().getSensorForName((String)args[0]) : SensorHandler.getInstance().getSensorByIndex(((Double)args[0]).intValue() - 1);
                    if (sensor != null) {
                        return new Object[]{UniversalSensorBlockEntity.this.setSensorSetting(sensor)};
                    }
                    throw new IllegalArgumentException("Invalid sensor name/index: " + args[0]);
                }
                UniversalSensorBlockEntity.this.setSensorSetting("");
                return new Object[]{true};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getSensor"){

            @Override
            public Object[] call(Object[] args) {
                Object[] objectArray;
                this.requireNoArgs(args);
                ISensorSetting curSensor = SensorHandler.getInstance().getSensorFromPath(UniversalSensorBlockEntity.this.getSensorSetting());
                if (curSensor == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = UniversalSensorBlockEntity.this.getSensorSetting().substring(UniversalSensorBlockEntity.this.getSensorSetting().lastIndexOf(47) + 1);
                }
                return objectArray;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setTextfield"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "textfield_value");
                UniversalSensorBlockEntity.this.setText(0, (String)args[0]);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getTextfield"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{UniversalSensorBlockEntity.this.getText(0)};
            }
        });
        registry.registerLuaMethod(new LuaMethod("isSensorEventBased"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{SensorHandler.getInstance().getSensorFromPath(UniversalSensorBlockEntity.this.getSensorSetting()) instanceof IEventSensorSetting};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getSensorValue"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                ISensorSetting s = SensorHandler.getInstance().getSensorFromPath(UniversalSensorBlockEntity.this.getSensorSetting());
                if (s instanceof IPollSensorSetting) {
                    UniversalSensorBlockEntity.this.requestPollPullEvent = true;
                    return new Object[]{UniversalSensorBlockEntity.this.redstoneStrength};
                }
                if (s != null) {
                    throw new IllegalArgumentException("The selected sensor is pull event based. You can't poll the value.");
                }
                throw new IllegalArgumentException("There's no sensor selected!");
            }
        });
        registry.registerLuaMethod(new LuaMethod("setGPSToolCoordinate"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 4, "slot, x, y, z");
                ItemStack stack = UniversalSensorBlockEntity.this.getUpgradeHandler().getStackInSlot(((Double)args[0]).intValue() - 1);
                if (stack.m_41720_() == ModItems.GPS_TOOL.get()) {
                    GPSToolItem.setGPSLocation(null, stack, BlockPos.m_274561_((double)((Double)args[1]), (double)((Double)args[2]), (double)((Double)args[3])));
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getGPSToolCoordinate"){

            /*
             * Exception decompiling
             */
            @Override
            public Object[] call(Object[] args) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.UnsupportedOperationException
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.inventoryCap;
    }

    @Override
    public RedstoneController<UniversalSensorBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f;
    }

    @Override
    public MutableComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.universalSensor.redstoneEmission", new Object[0]);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.m_58904_()).getUniversalSensors().remove(this);
    }

    public void m_6339_() {
        super.m_6339_();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.m_58904_()).getUniversalSensors().add(this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new UniversalSensorMenu(i, playerInventory, this.m_58899_());
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
    }

    public static enum SensorStatus implements ITranslatableEnum
    {
        OK,
        MISSING_GPS,
        MISSING_UPGRADE,
        NO_SENSOR;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.universalSensor.status." + this.toString().toLowerCase(Locale.ROOT);
        }
    }

    private class UniversalSensorItemHandler
    extends ItemStackHandler {
        UniversalSensorItemHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof IPositionProvider) {
                IPositionProvider p = (IPositionProvider)item;
                List<BlockPos> l = p.getStoredPositions(UniversalSensorBlockEntity.this.playerId, stack);
                return !l.isEmpty() && l.get(0) != null;
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            UniversalSensorBlockEntity.this.setupGPSPositions();
        }
    }
}

