/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.AbstractHopperBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.LiquidHopperMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class LiquidHopperBlockEntity
extends AbstractHopperBlockEntity<LiquidHopperBlockEntity>
implements ISerializableTanks {
    private int comparatorValue = -1;
    @DescSynced
    @GuiSynced
    private final HopperTank tank = new HopperTank(16000);
    private final LazyOptional<IFluidHandler> tankCap = LazyOptional.of(() -> this.tank);
    private final WrappedFluidTank inputWrapper = new WrappedFluidTank(this.tank, true);
    private final LazyOptional<IFluidHandler> inputCap = LazyOptional.of(() -> this.inputWrapper);
    private final WrappedFluidTank outputWrapper = new WrappedFluidTank(this.tank, false);
    private final LazyOptional<IFluidHandler> outputCap = LazyOptional.of(() -> this.outputWrapper);
    @GuiSynced
    private final RedstoneController<LiquidHopperBlockEntity> rsController = new RedstoneController<LiquidHopperBlockEntity>(this);

    public LiquidHopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.LIQUID_HOPPER.get()), pos, state);
    }

    @Override
    protected int getComparatorValueInternal() {
        if (this.comparatorValue < 0) {
            if (this.tank.getFluidAmount() == 0) {
                return 0;
            }
            FluidStack fluidStack = this.tank.getFluid();
            this.comparatorValue = (int)(1.0f + (float)fluidStack.getAmount() / (float)this.tank.getCapacity() * 14.0f);
        }
        return this.comparatorValue;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickServer() {
        FluidStack fluidStack;
        super.tickServer();
        if (this.getUpgrades(ModUpgrades.CREATIVE.get()) > 0 && !(fluidStack = this.tank.getFluid()).isEmpty() && fluidStack.getAmount() < 16000) {
            this.tank.fill(new FluidStack(fluidStack.getFluid(), 16000), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    protected boolean doExport(int maxItems) {
        if (this.tank.getFluid().isEmpty()) {
            return false;
        }
        Direction dir = this.getRotation();
        BlockEntity neighbor = this.getCachedNeighbor(dir);
        if (neighbor != null) {
            return IOHelper.getFluidHandlerForTE(neighbor, dir.m_122424_()).map(fluidHandler -> {
                int amount = Math.min(maxItems * 100, this.tank.getFluid().getAmount() - this.leaveMaterialCount * 1000);
                FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)amount, (boolean)true);
                return !transferred.isEmpty();
            }).orElse(false);
        }
        if (this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) > 0) {
            for (Entity e : this.cachedOutputEntities) {
                FluidStack transferred;
                if (!e.m_6084_() || (transferred = e.getCapability(ForgeCapabilities.FLUID_HANDLER, this.getRotation().m_122424_()).map(h -> {
                    int amount = Math.min(maxItems * 100, this.tank.getFluid().getAmount() - this.leaveMaterialCount * 1000);
                    return FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)this.tank, (int)amount, (boolean)true);
                }).orElse(FluidStack.EMPTY)).isEmpty()) continue;
                return true;
            }
        }
        for (Entity e : this.cachedOutputEntities) {
            if (!e.m_6084_() || !(e instanceof ItemEntity)) continue;
            ItemEntity entity = (ItemEntity)e;
            int maxFill = entity.m_32055_().m_41720_() instanceof BucketItem ? 1000 : maxItems * 100;
            FluidActionResult res = FluidUtil.tryFillContainer((ItemStack)entity.m_32055_(), (IFluidHandler)this.tank, (int)maxFill, null, (boolean)true);
            if (res.success) {
                entity.m_32045_(res.result);
            }
            if (!this.tank.isEmpty()) continue;
            break;
        }
        if (((Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get()).booleanValue() && this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0 && this.tank.getFluidAmount() >= this.leaveMaterialCount + 1000) {
            return FluidUtils.tryPourOutFluid(this.outputCap, this.nonNullLevel(), this.m_58899_().m_121945_(dir), false, false, IFluidHandler.FluidAction.EXECUTE);
        }
        return false;
    }

    @Override
    protected boolean doImport(int maxItems) {
        BlockEntity inputInv = this.getCachedNeighbor(this.inputDir);
        if (inputInv != null) {
            LazyOptional cap = inputInv.getCapability(ForgeCapabilities.FLUID_HANDLER, this.inputDir.m_122424_());
            if (cap.isPresent()) {
                return cap.map(fluidHandler -> {
                    int filledFluid;
                    FluidStack fluid = fluidHandler.drain(maxItems * 100, IFluidHandler.FluidAction.SIMULATE);
                    if (!fluid.isEmpty() && (filledFluid = this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                        fluidHandler.drain(filledFluid, IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        } else if (this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) > 0) {
            for (Entity e : this.cachedInputEntities) {
                FluidStack transferred;
                if (!e.m_6084_() || (transferred = e.getCapability(ForgeCapabilities.FLUID_HANDLER, this.inputDir.m_122424_()).map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)h, (int)(maxItems * 100), (boolean)true)).orElse(FluidStack.EMPTY)).isEmpty()) continue;
                return true;
            }
        }
        for (Entity e : this.cachedInputEntities) {
            if (!e.m_6084_() || !(e instanceof ItemEntity)) continue;
            ItemEntity entity = (ItemEntity)e;
            int max = entity.m_32055_().m_41720_() instanceof BucketItem ? 1000 : maxItems * 100;
            FluidActionResult res = FluidUtil.tryEmptyContainer((ItemStack)entity.m_32055_(), (IFluidHandler)this.tank, (int)max, null, (boolean)true);
            if (res.success) {
                entity.m_32045_(res.result);
            }
            if (this.tank.getFluidAmount() < this.tank.getCapacity()) continue;
            break;
        }
        if (((Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get()).booleanValue() && this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0) {
            BlockPos neighborPos = this.m_58899_().m_121945_(this.inputDir);
            return !FluidUtils.tryPickupFluid(this.inputCap, this.nonNullLevel(), neighborPos, false, IFluidHandler.FluidAction.EXECUTE).isEmpty();
        }
        return false;
    }

    @Override
    protected void setupInputOutputRegions() {
        this.inputAABB = new AABB(this.f_58858_.m_121945_(this.inputDir));
        this.outputAABB = new AABB(this.m_58899_().m_121945_(this.getRotation()));
        this.cachedInputEntities.clear();
        this.cachedOutputEntities.clear();
    }

    @Override
    boolean shouldScanForEntities(Direction dir) {
        BlockEntity te = this.getCachedNeighbor(dir);
        return (te == null || !te.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_()).isPresent()) && !this.isInputBlocked();
    }

    public HopperTank getTank() {
        return this.tank;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.comparatorValue = -1;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return LazyOptional.empty();
    }

    @Override
    @NotNull
    public LazyOptional<IFluidHandler> getFluidCap(Direction side) {
        if (side == this.inputDir) {
            return this.inputCap;
        }
        if (side == this.getRotation()) {
            return this.outputCap;
        }
        return this.tankCap;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new LiquidHopperMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    public RedstoneController<LiquidHopperBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    public class HopperTank
    extends SmartSyncTank {
        HopperTank(int capacity) {
            super(LiquidHopperBlockEntity.this, capacity);
        }

        @Override
        protected void onContentsChanged(Fluid prevFluid, int prevAmount) {
            super.onContentsChanged(prevFluid, prevAmount);
            LiquidHopperBlockEntity.this.comparatorValue = -1;
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            int filled = super.fill(resource, doFill);
            if (LiquidHopperBlockEntity.this.isCreative && this.getFluidAmount() > 0 && this.getFluid().getFluid() == resource.getFluid()) {
                return resource.getAmount();
            }
            return filled;
        }

        @Override
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return super.drain(resource, LiquidHopperBlockEntity.this.isCreative ? IFluidHandler.FluidAction.SIMULATE : doDrain);
        }

        @Override
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return super.drain(maxDrain, LiquidHopperBlockEntity.this.isCreative ? IFluidHandler.FluidAction.SIMULATE : doDrain);
        }
    }

    class WrappedFluidTank
    implements IFluidTank,
    IFluidHandler {
        private final IFluidTank wrappedTank;
        private final boolean inbound;

        WrappedFluidTank(IFluidTank wrappedTank, boolean inbound) {
            this.wrappedTank = wrappedTank;
            this.inbound = inbound;
        }

        public FluidStack getFluid() {
            return this.wrappedTank.getFluid();
        }

        public int getFluidAmount() {
            return this.wrappedTank.getFluidAmount();
        }

        public int getCapacity() {
            return this.wrappedTank.getCapacity();
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.wrappedTank.isFluidValid(stack);
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.wrappedTank.getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.wrappedTank.getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.wrappedTank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return this.inbound ? this.wrappedTank.fill(resource, doFill) : 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return this.inbound ? FluidStack.EMPTY : LiquidHopperBlockEntity.this.tank.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return this.inbound ? FluidStack.EMPTY : this.wrappedTank.drain(maxDrain, doDrain);
        }
    }
}

