/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaConstant;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractAirHandlingBlockEntity
extends AbstractTickingBlockEntity {
    @GuiSynced
    protected final IAirHandlerMachine airHandler;
    private final LazyOptional<IAirHandlerMachine> airHandlerCap;
    private final Map<IAirHandlerMachine, List<Direction>> airHandlerMap = new IdentityHashMap<IAirHandlerMachine, List<Direction>>();

    public AbstractAirHandlingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier pressureTier, int volume, int upgradeSlots) {
        super(type, pos, state, upgradeSlots);
        this.airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler(pressureTier, volume);
        this.airHandlerCap = LazyOptional.of(() -> this.airHandler);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.initializeHullAirHandlers();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.initializeHullAirHandlers();
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.airHandlerMap.keySet().forEach(handler -> handler.tick(this));
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.airHandlerMap.forEach((handler, sides) -> {
            if (!sides.isEmpty()) {
                this.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, (Direction)sides.get(0)).invalidate();
            }
        });
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        this.airHandler.setVolumeUpgrades(this.getUpgrades(ModUpgrades.VOLUME.get()));
        this.handleSecurityUpgrade(this.airHandler);
        this.airHandlerMap.keySet().forEach(h -> {
            h.setVolumeUpgrades(this.getUpgrades(ModUpgrades.VOLUME.get()));
            this.handleSecurityUpgrade((IAirHandlerMachine)h);
        });
    }

    private void handleSecurityUpgrade(IAirHandlerMachine handler) {
        if (this.getUpgrades(ModUpgrades.SECURITY.get()) > 0) {
            handler.enableSafetyVenting(p -> p > this.getDangerPressure(), Direction.UP);
        } else {
            handler.disableSafetyVenting();
        }
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.initializeHullAirHandlers();
        this.airHandlerMap.keySet().forEach(h -> h.setSideLeaking(null));
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY) {
            return this.f_58857_ != null && (side == null || this.canConnectPneumatic(side)) ? this.airHandlerCap.cast() : LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("AirHandler", this.airHandler.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.airHandler.deserializeNBT((Tag)tag.m_128469_("AirHandler"));
        this.airHandler.setVolumeUpgrades(this.getUpgrades(ModUpgrades.VOLUME.get()));
        if (tag.m_128441_("AirAmount")) {
            this.airHandler.addAir(tag.m_128451_("AirAmount"));
        }
    }

    public void initializeHullAirHandlers() {
        this.airHandlerMap.clear();
        for (Direction side : DirectionUtil.VALUES) {
            this.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, side).ifPresent(handler -> this.airHandlerMap.computeIfAbsent((IAirHandlerMachine)handler, k -> new ArrayList()).add(side));
        }
        this.airHandlerMap.forEach(IAirHandlerMachine::setConnectedFaces);
    }

    public void initializeHullAirHandlerClient(Direction dir, IAirHandlerMachine handler) {
        this.airHandlerMap.clear();
        List<Direction> l = Collections.singletonList(dir);
        this.airHandlerMap.put(handler, l);
        handler.setConnectedFaces(l);
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.initializeHullAirHandlers();
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        tag.m_128365_("AirHandler", this.airHandler.serializeNBT());
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.airHandler.deserializeNBT((Tag)tag.m_128469_("AirHandler"));
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("getPressure"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 0, 1, "face (down/up/north/south/west/east)");
                if (args.length == 0) {
                    return new Object[]{Float.valueOf(AbstractAirHandlingBlockEntity.this.airHandler.getPressure())};
                }
                LazyOptional<IAirHandlerMachine> cap = AbstractAirHandlingBlockEntity.this.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, this.getDirForString((String)args[0]));
                return new Object[]{cap.map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f))};
            }
        });
        AbstractAirHandlingBlockEntity abstractAirHandlingBlockEntity = this;
        if (abstractAirHandlingBlockEntity instanceof IMinWorkingPressure) {
            final IMinWorkingPressure mwp = (IMinWorkingPressure)((Object)abstractAirHandlingBlockEntity);
            registry.registerLuaMethod(new LuaMethod("getMinWorkingPressure"){

                @Override
                public Object[] call(Object[] args) {
                    this.requireNoArgs(args);
                    return new Object[]{Float.valueOf(mwp.getMinWorkingPressure())};
                }
            });
        }
        registry.registerLuaMethod(new LuaConstant("getDangerPressure", this.getDangerPressure()));
        registry.registerLuaMethod(new LuaConstant("getCriticalPressure", this.getCriticalPressure()));
        registry.registerLuaMethod(new LuaConstant("getDefaultVolume", this.getDefaultVolume()));
    }

    public float getPressure() {
        return this.airHandler.getPressure();
    }

    public float getDangerPressure() {
        return this.airHandler.getDangerPressure();
    }

    public float getCriticalPressure() {
        return this.airHandler.getCriticalPressure();
    }

    public void addAir(int air) {
        this.airHandler.addAir(air);
    }

    public boolean canConnectPneumatic(Direction side) {
        return true;
    }

    public int getDefaultVolume() {
        return this.airHandler.getBaseVolume();
    }

    public boolean hasNoConnectedAirHandlers() {
        return this.airHandler.getConnectedAirHandlers(this).isEmpty();
    }
}

