/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SecurityStationBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.or(Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)10.0, (double)9.0, (double)11.0, (double)11.0, (double)15.0), Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)7.0), Block.m_49796_((double)12.0, (double)10.0, (double)11.0, (double)15.0, (double)11.0, (double)15.0), Block.m_49796_((double)12.25, (double)10.0, (double)7.0, (double)12.75, (double)10.5, (double)11.0), Block.m_49796_((double)9.25, (double)10.0, (double)7.0, (double)9.75, (double)10.5, (double)9.0), Block.m_49796_((double)3.0, (double)10.5, (double)2.0, (double)13.0, (double)14.5, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0), Block.m_49796_((double)13.25, (double)10.0, (double)7.0, (double)13.75, (double)10.5, (double)11.0));
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public SecurityStationBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction d = (Direction)state.m_61143_((Property)this.directionProperty());
        return SHAPES[d.m_122416_()];
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entityLiving, ItemStack iStack) {
        if (entityLiving instanceof Player) {
            Player p = (Player)entityLiving;
            world.m_141902_(pos, (BlockEntityType)ModBlockEntities.SECURITY_STATION.get()).ifPresent(teSS -> teSS.sharedUsers.add(p.m_36316_()));
        }
        super.m_6402_(world, pos, state, entityLiving, iStack);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        BlockEntity te;
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_ && (te = world.m_7702_(pos)) instanceof SecurityStationBlockEntity) {
            SecurityStationBlockEntity teSS = (SecurityStationBlockEntity)te;
            if (teSS.isPlayerOnWhiteList(player)) {
                return super.m_6227_(state, world, pos, player, hand, brtr);
            }
            if (!teSS.hasValidNetwork()) {
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.outOfOrder", new Object[0]).m_130940_(ChatFormatting.RED), false);
            } else if (teSS.hasPlayerHacked(player)) {
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.alreadyHacked", new Object[0]).m_130940_(ChatFormatting.GOLD), false);
            } else if (this.getPlayerHackLevel(player) < teSS.getSecurityLevel()) {
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.cantHack", new Object[0]).m_130940_(ChatFormatting.GOLD), false);
                player.m_6469_(player.m_269291_().m_269341_(), 1.0f);
            } else if (((Boolean)ConfigHelper.common().machines.securityStationAllowHacking.get()).booleanValue()) {
                teSS.initiateHacking(player);
            } else {
                player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackDisabled", new Object[0]).m_130940_(ChatFormatting.GOLD), false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private int getPlayerHackLevel(Player player) {
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
        return handler.isArmorReady(EquipmentSlot.HEAD) && handler.getArmorPressure(EquipmentSlot.HEAD) > 0.0f ? handler.getUpgradeCount(EquipmentSlot.HEAD, ModUpgrades.SECURITY.get()) : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.m_141902_(pos, (BlockEntityType)ModBlockEntities.SECURITY_STATION.get()).map(teSS -> teSS.getRedstoneController().shouldEmit() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SecurityStationBlockEntity(pPos, pState);
    }
}

