/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.gui.widget.ITaggedWidget;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class WidgetButtonExtended
extends ExtendedButton
implements ITaggedWidget {
    private int iconSpacing = 18;
    private ItemStack[] renderedStacks;
    private ResourceLocation resLoc;
    private int invisibleHoverColor;
    private boolean thisVisible = true;
    private IconPosition iconPosition = IconPosition.MIDDLE;
    private String tag = null;
    private Supplier<String> tagSupplier = null;
    private boolean renderStackSize = false;
    private boolean highlightInactive = false;

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, Component buttonText, Button.OnPress pressable) {
        super(startX, startY, xSize, ySize, buttonText, pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, Component buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText, Button.OnPress pressable) {
        super(startX, startY, xSize, ySize, (Component)Component.m_237113_((String)buttonText), pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize) {
        this(startX, startY, xSize, ySize, (Component)Component.m_237119_(), b -> {});
    }

    public WidgetButtonExtended withTag(String tag) {
        this.tag = tag;
        this.tagSupplier = null;
        return this;
    }

    public WidgetButtonExtended withTag(Supplier<String> tagSupplier) {
        this.tag = null;
        this.tagSupplier = tagSupplier;
        return this;
    }

    public void m_5691_() {
        super.m_5691_();
        String tag1 = this.getTag();
        if (tag1 != null && !tag1.isEmpty()) {
            NetworkHandler.sendToServer(new PacketGuiButton(tag1));
        }
    }

    @Override
    public String getTag() {
        return this.tagSupplier == null ? this.tag : this.tagSupplier.get();
    }

    public WidgetButtonExtended setVisible(boolean visible) {
        this.thisVisible = visible;
        return this;
    }

    public WidgetButtonExtended setInvisibleHoverColor(int color) {
        this.invisibleHoverColor = color;
        return this;
    }

    public WidgetButtonExtended setIconPosition(IconPosition iconPosition) {
        this.iconPosition = iconPosition;
        return this;
    }

    public WidgetButtonExtended setRenderStacks(ItemStack ... renderedStacks) {
        this.renderedStacks = renderedStacks;
        this.resLoc = null;
        return this;
    }

    public WidgetButtonExtended setRenderedIcon(ResourceLocation resLoc) {
        this.resLoc = resLoc;
        this.renderedStacks = null;
        return this;
    }

    public WidgetButtonExtended setIconSpacing(int spacing) {
        this.iconSpacing = spacing;
        return this;
    }

    public WidgetButtonExtended setTexture(Object texture) {
        if (texture instanceof ItemStack) {
            this.setRenderStacks((ItemStack)texture);
        } else if (texture instanceof ResourceLocation) {
            this.setRenderedIcon((ResourceLocation)texture);
        } else {
            throw new IllegalArgumentException("texture must be an ItemStack or ResourceLocation!");
        }
        return this;
    }

    public void setHighlightWhenInactive(boolean highlight) {
        this.highlightInactive = highlight;
    }

    public void setRenderStackSize(boolean renderStackSize) {
        this.renderStackSize = renderStackSize;
    }

    public void m_87963_(GuiGraphics graphics, int x, int y, float partialTicks) {
        if (this.thisVisible && this.f_93624_ && !this.f_93623_ && this.highlightInactive) {
            graphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.m_5711_() + 1, this.m_252907_() + this.m_93694_() + 1, -16711681);
        }
        if (this.thisVisible) {
            super.m_87963_(graphics, x, y, partialTicks);
        }
        if (this.f_93624_) {
            if (this.renderedStacks != null) {
                int startX = this.getIconX();
                for (int i = this.renderedStacks.length - 1; i >= 0; --i) {
                    graphics.m_280480_(this.renderedStacks[i], startX + i * this.iconSpacing, this.m_252907_() + 2);
                    if (!this.renderStackSize) continue;
                    graphics.m_280302_(Minecraft.m_91087_().f_91062_, this.renderedStacks[i], startX + i * this.iconSpacing, this.m_252907_() + 2, null);
                }
            }
            if (this.resLoc != null) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                graphics.m_280163_(this.resLoc, this.m_252754_() + this.f_93618_ / 2 - 8, this.m_252907_() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.disableBlend();
            }
            if (this.f_93623_ && !this.thisVisible && x >= this.m_252754_() && y >= this.m_252907_() && x < this.m_252754_() + this.f_93618_ && y < this.m_252907_() + this.f_93619_) {
                graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.invisibleHoverColor);
            }
        }
    }

    private int getIconX() {
        return switch (this.iconPosition) {
            default -> throw new IncompatibleClassChangeError();
            case IconPosition.LEFT -> this.m_252754_() - 1 - 18 * this.renderedStacks.length;
            case IconPosition.RIGHT -> this.m_252754_() + this.f_93618_ + 1;
            case IconPosition.MIDDLE -> this.m_252754_() + this.f_93618_ / 2 - this.renderedStacks.length * 9 + 1;
        };
    }

    public WidgetButtonExtended setTooltipText(Component comp) {
        this.m_257544_(Tooltip.m_257550_((Component)comp));
        return this;
    }

    public WidgetButtonExtended setTooltipText(List<Component> comps) {
        this.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.combineComponents(comps)));
        return this;
    }

    public WidgetButtonExtended setTooltipKey(String tip) {
        this.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate(tip, new Object[0])));
        return this;
    }

    public static enum IconPosition {
        MIDDLE,
        LEFT,
        RIGHT;

    }
}

