/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetColorSelector;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToServer;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;

public class RedstoneModuleScreen
extends AbstractTubeModuleScreen<RedstoneModule> {
    private WidgetComboBox comboBox;
    private WidgetLabel constLabel;
    private WidgetTextFieldNumber constTextField;
    private WidgetLabel otherColorLabel;
    private WidgetColorSelector otherColorButton;
    private int ourColor;
    private int otherColor;
    private WidgetCheckBox invertCheckBox;
    private WidgetCheckBox comparatorInputCheckBox;
    private boolean upgraded;
    private boolean output;
    private final List<FormattedCharSequence> lowerText = new ArrayList<FormattedCharSequence>();

    public RedstoneModuleScreen(RedstoneModule module) {
        super(module);
        this.ySize = module.getRedstoneDirection() == RedstoneModule.EnumRedstoneDirection.OUTPUT ? 202 : 57;
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.output ? Textures.GUI_WIDGET_OPTIONS : Textures.GUI_MODULE_SIMPLE;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.upgraded = ((RedstoneModule)this.module).isUpgraded();
        this.output = ((RedstoneModule)this.module).getRedstoneDirection() == RedstoneModule.EnumRedstoneDirection.OUTPUT;
        this.ourColor = ((RedstoneModule)this.module).getColorChannel();
        this.otherColor = ((RedstoneModule)this.module).getOtherColor();
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.guiLeft + this.xSize - 22, this.guiTop + 2, 18, 12, this.getDirText((RedstoneModule)this.module), b -> this.toggleRedstoneDirection()).setTooltipText((List<Component>)ImmutableList.of((Object)PneumaticCraftUtils.xlate(((RedstoneModule)this.module).getRedstoneDirection().getTranslationKey(), new Object[0]), (Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.clickToToggle", new Object[0]).m_130940_(ChatFormatting.GRAY))));
        this.m_142416_((GuiEventListener)new WidgetLabel(this.guiLeft + this.xSize / 2, this.guiTop + 5, this.m_96636_()).setAlignment(WidgetLabel.Alignment.CENTRE));
        WidgetLabel ourColorLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 25, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.channel", new Object[0]));
        this.m_142416_((GuiEventListener)ourColorLabel);
        WidgetLabel opLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 45, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.operation", new Object[0]));
        this.m_142416_((GuiEventListener)opLabel);
        opLabel.f_93624_ = this.output;
        this.otherColorLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 65, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.otherChannel", new Object[0]));
        this.otherColorLabel.f_93624_ = this.output;
        this.m_142416_((GuiEventListener)this.otherColorLabel);
        this.constLabel = new WidgetLabel(this.guiLeft + 15, this.guiTop + 65, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.constant", new Object[0]));
        this.m_142416_((GuiEventListener)this.constLabel);
        this.constLabel.f_93624_ = this.output;
        int w = 0;
        for (WidgetLabel label : ImmutableList.of((Object)((Object)ourColorLabel), (Object)((Object)this.otherColorLabel), (Object)((Object)opLabel), (Object)((Object)this.constLabel))) {
            w = Math.max(label.m_5711_(), w);
        }
        int xBase = this.guiLeft + w + 15;
        this.m_142416_((GuiEventListener)new WidgetColorSelector(xBase, this.guiTop + 20, b -> {
            this.ourColor = b.getColor().m_41060_();
        }).withInitialColor(DyeColor.m_41053_((int)this.ourColor)));
        if (!this.output) {
            this.comparatorInputCheckBox = new WidgetCheckBox(this.guiLeft + 10, this.guiTop + 40, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.comparatorInput", new Object[0]));
            this.comparatorInputCheckBox.setChecked(((RedstoneModule)this.module).isComparatorInput());
            this.comparatorInputCheckBox.setTooltipKey("pneumaticcraft.gui.redstoneModule.comparatorInput.tooltip");
            this.comparatorInputCheckBox.f_93624_ = !this.output && this.upgraded;
            this.m_142416_((GuiEventListener)this.comparatorInputCheckBox);
        } else {
            this.comboBox = new WidgetComboBox(this.f_96547_, xBase, this.guiTop + 43, this.xSize - xBase + this.guiLeft - 10, 12).initFromEnum(((RedstoneModule)this.module).getOperation());
            this.comboBox.f_93623_ = this.upgraded;
            this.m_142416_((GuiEventListener)this.comboBox);
            this.otherColorButton = new WidgetColorSelector(xBase, this.guiTop + 60, b -> {
                this.otherColor = b.getColor().m_41060_();
            }).withInitialColor(DyeColor.m_41053_((int)this.otherColor));
            this.otherColorButton.f_93623_ = this.upgraded;
            this.m_142416_((GuiEventListener)this.otherColorButton);
            this.constTextField = new WidgetTextFieldNumber(this.f_96547_, xBase, this.guiTop + 63, 30, 12);
            this.constTextField.minValue = 0;
            this.constTextField.setDecimals(0);
            this.constTextField.setValue(((RedstoneModule)this.module).getConstantVal());
            this.constTextField.f_93623_ = this.upgraded;
            this.m_142416_((GuiEventListener)this.constTextField);
            this.invertCheckBox = new WidgetCheckBox(this.guiLeft + 10, this.guiTop + 85, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.invert", new Object[0])){

                public boolean m_6375_(double mouseX, double mouseY, int button) {
                    if (RedstoneModuleScreen.this.comboBox.m_93696_()) {
                        return true;
                    }
                    return super.m_6375_(mouseX, mouseY, button);
                }
            };
            this.invertCheckBox.setChecked(((RedstoneModule)this.module).isInverted());
            this.invertCheckBox.setTooltipKey("pneumaticcraft.gui.redstoneModule.invert.tooltip");
            this.m_142416_((GuiEventListener)this.invertCheckBox);
            this.updateWidgetVisibility();
        }
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.output) {
            if (this.upgraded) {
                this.updateWidgetVisibility();
            }
            this.updateLowerText();
        }
    }

    private void updateWidgetVisibility() {
        RedstoneModule.Operation op = this.getSelectedOp();
        this.constLabel.f_93624_ = op.useConstant();
        this.constTextField.m_94194_(op.useConstant());
        this.constTextField.setRange(op.getConstMin(), op.getConstMax());
        this.otherColorLabel.f_93624_ = op.useOtherColor();
        this.otherColorButton.f_93624_ = op.useOtherColor();
        this.otherColorButton.setVisible(op.useOtherColor());
    }

    private void updateLowerText() {
        this.lowerText.clear();
        RedstoneModule.Operation op = this.getSelectedOp();
        String key = op.getTranslationKey() + ".tooltip";
        ArrayList<Component> l = new ArrayList<Component>();
        if (op.useConstant()) {
            l.add((Component)PneumaticCraftUtils.xlate(key, PneumaticCraftUtils.dyeColorDesc(this.ourColor), this.constTextField.m_94155_()));
        } else if (op.useOtherColor()) {
            l.add((Component)PneumaticCraftUtils.xlate(key, PneumaticCraftUtils.dyeColorDesc(this.ourColor), PneumaticCraftUtils.dyeColorDesc(this.otherColor)));
        } else {
            l.add((Component)PneumaticCraftUtils.xlate(key, PneumaticCraftUtils.dyeColorDesc(this.ourColor)));
        }
        if (!this.upgraded) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstoneModule.addAdvancedPCB", new Object[0]).m_130940_(ChatFormatting.DARK_BLUE));
        }
        this.lowerText.addAll(GuiUtils.wrapTextComponentList(l, this.xSize - 20, this.f_96547_));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int n = this.lowerText.size();
        Objects.requireNonNull(this.f_96547_);
        int yBase = this.guiTop + this.ySize - n * 9 - 10;
        for (int i = 0; i < this.lowerText.size(); ++i) {
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280649_(this.f_96547_, this.lowerText.get(i), this.guiLeft + 10, yBase + i * 9, -12566464, false);
        }
    }

    private RedstoneModule.Operation getSelectedOp() {
        return RedstoneModule.Operation.values()[this.comboBox.getSelectedElementIndex()];
    }

    public void m_7861_() {
        super.m_7861_();
        ((RedstoneModule)this.module).setColorChannel(this.ourColor);
        if (this.output) {
            ((RedstoneModule)this.module).setInverted(this.invertCheckBox.checked);
            ((RedstoneModule)this.module).setOperation(this.getSelectedOp(), this.otherColor, this.constTextField.getIntValue());
        } else {
            ((RedstoneModule)this.module).setComparatorInput(this.comparatorInputCheckBox.checked);
        }
        NetworkHandler.sendToServer(new PacketSyncRedstoneModuleToServer((RedstoneModule)this.module));
    }

    private void toggleRedstoneDirection() {
        ((RedstoneModule)this.module).setRedstoneDirection(((RedstoneModule)this.module).getRedstoneDirection().toggle());
        this.m_7861_();
        this.f_96541_.m_91152_((Screen)new RedstoneModuleScreen((RedstoneModule)this.module));
        this.f_96541_.f_91074_.m_5496_((SoundEvent)ModSounds.INTERFACE_DOOR.get(), 0.7f, 2.0f);
    }

    private String getDirText(RedstoneModule module) {
        return module.getRedstoneDirection() == RedstoneModule.EnumRedstoneDirection.INPUT ? ChatFormatting.DARK_RED + "\u25c0" : ChatFormatting.RED + "\u25b6";
    }
}

