/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.parsing.BiomeCategories;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.uniforms.BiomeParameters;

public class IrisDefines {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.*(?<bugfix>\\d*)(.*)");

    private static void define(List<StringPair> defines, String key) {
        defines.add(new StringPair(key, ""));
    }

    private static void define(List<StringPair> defines, String key, String value) {
        defines.add(new StringPair(key, value));
    }

    public static ImmutableList<StringPair> createIrisReplacements() {
        ArrayList<StringPair> s = new ArrayList<StringPair>((Collection<StringPair>)StandardMacros.createStandardEnvironmentDefines());
        IrisDefines.define(s, "PPT_NONE", "0");
        IrisDefines.define(s, "PPT_RAIN", "1");
        IrisDefines.define(s, "PPT_SNOW", "2");
        IrisDefines.define(s, "BIOME_SWAMP_HILLS", "-1");
        BiomeParameters.getBiomeMap().forEach((biome, id) -> IrisDefines.define(s, "BIOME_" + biome.m_135782_().m_135815_().toUpperCase(Locale.ROOT), String.valueOf(id)));
        BiomeCategories[] categories = BiomeCategories.values();
        for (int i = 0; i < categories.length; ++i) {
            IrisDefines.define(s, "CAT_" + categories[i].name().toUpperCase(Locale.ROOT), String.valueOf(i));
        }
        return ImmutableList.copyOf(s);
    }
}

