/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.function.Supplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.joml.Vector2i;

public class Vector2IntegerJomlUniform
extends Uniform {
    private Vector2i cachedValue = null;
    private final Supplier<Vector2i> value;

    Vector2IntegerJomlUniform(int location, Supplier<Vector2i> value) {
        this(location, value, null);
    }

    Vector2IntegerJomlUniform(int location, Supplier<Vector2i> value, ValueUpdateNotifier notifier) {
        super(location, notifier);
        this.value = value;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        Vector2i newValue = this.value.get();
        if (this.cachedValue == null || !newValue.equals((Object)this.cachedValue)) {
            this.cachedValue = newValue;
            IrisRenderSystem.uniform2i(this.location, newValue.x, newValue.y);
        }
    }
}

