/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.occultism.datagen.CrushingRecipeProvider;
import com.klikli_dev.occultism.datagen.ItemModelsGenerator;
import com.klikli_dev.occultism.datagen.MinerRecipeProvider;
import com.klikli_dev.occultism.datagen.OccultismAdvancementProvider;
import com.klikli_dev.occultism.datagen.OccultismBookProvider;
import com.klikli_dev.occultism.datagen.PentacleProvider;
import com.klikli_dev.occultism.datagen.StandardBlockStateProvider;
import com.klikli_dev.occultism.datagen.lang.ENUSProvider;
import com.klikli_dev.occultism.datagen.loot.OccultismBlockLoot;
import com.klikli_dev.occultism.datagen.loot.OccultismEntityLoot;
import com.klikli_dev.occultism.datagen.worldgen.OccultismRegistries;
import java.util.List;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(generator.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(OccultismBlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(OccultismEntityLoot::new, LootContextParamSets.f_81415_))));
        generator.addProvider(event.includeServer(), (DataProvider)new PentacleProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismAdvancementProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new CrushingRecipeProvider(generator.getPackOutput()));
        generator.addProvider(event.includeServer(), (DataProvider)new MinerRecipeProvider(generator.getPackOutput()));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelsGenerator(generator.getPackOutput(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new StandardBlockStateProvider(generator.getPackOutput(), event.getExistingFileHelper()));
        ENUSProvider enUSProvider = new ENUSProvider(generator.getPackOutput());
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismBookProvider(generator.getPackOutput(), "occultism", enUSProvider, new LanguageProvider[0]));
        generator.addProvider(event.includeClient(), (DataProvider)enUSProvider);
        event.getGenerator().addProvider(event.includeServer(), output -> new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), OccultismRegistries.BUILDER, Set.of("occultism")));
    }
}

