/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class CrushingRecipeProvider
implements DataProvider {
    protected final PackOutput.PathProvider recipePathProvider;

    public CrushingRecipeProvider(PackOutput packOutput) {
        this.recipePathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "recipes/crushing");
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.buildRecipes(recipe -> {
            if (!set.add((ResourceLocation)recipe.getFirst())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.getFirst());
            }
            list.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)((JsonElement)recipe.getSecond()), (Path)this.recipePathProvider.m_245731_((ResourceLocation)recipe.getFirst())));
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected void buildRecipes(Consumer<Pair<ResourceLocation, JsonObject>> recipeConsumer) {
        this.buildCrushingRecipesForMetal("aluminum", recipeConsumer);
        this.buildCrushingRecipesForMetal("signalum", recipeConsumer);
        this.buildCrushingRecipesForMetal("uranium", recipeConsumer);
        this.buildCrushingRecipesForMetal("graphite", recipeConsumer);
        this.buildCrushingRecipesForMetal("azure_silver", recipeConsumer);
        this.buildCrushingRecipesForMetal("zinc", recipeConsumer);
        this.buildCrushingRecipesForMetal("lumium", recipeConsumer);
        this.buildCrushingRecipesForMetal("osmium", recipeConsumer);
        this.buildCrushingRecipesForMetal("nickel", recipeConsumer);
        this.buildCrushingRecipesForMetal("lead", recipeConsumer);
        this.buildCrushingRecipesForMetal("allthemodium", recipeConsumer);
        this.buildCrushingRecipesForMetal("bronze", recipeConsumer);
        this.buildCrushingRecipesForMetal("cobalt", recipeConsumer);
        this.buildCrushingRecipesForMetal("unobtainium", recipeConsumer);
        this.buildCrushingRecipesForMetal("tungsten", recipeConsumer);
        this.buildCrushingRecipesForMetal("iridium", recipeConsumer);
        this.buildCrushingRecipesForMetal("steel", recipeConsumer);
        this.buildCrushingRecipesForMetal("enderium", recipeConsumer);
        this.buildCrushingRecipesForMetal("electrum", recipeConsumer);
        this.buildCrushingRecipesForMetal("constantan", recipeConsumer);
        this.buildCrushingRecipesForMetal("tin", recipeConsumer);
        this.buildCrushingRecipesForMetal("netherite", recipeConsumer);
        this.buildCrushingRecipesForMetal("brass", recipeConsumer);
        this.buildCrushingRecipesForMetal("crimson_iron", recipeConsumer);
        this.buildCrushingRecipesForMetal("platinum", recipeConsumer);
        this.buildCrushingRecipesForMetal("invar", recipeConsumer);
        this.buildCrushingRecipesForMetal("vibranium", recipeConsumer);
        this.buildCrushingRecipesForMetal("silver", recipeConsumer);
        this.buildCrushingRecipesForMetal("copper", recipeConsumer);
        this.buildCrushingRecipesForMetal("pewter", recipeConsumer);
        this.buildCrushingRecipesForMetal("mithril", recipeConsumer);
        this.buildCrushingRecipesForMetal("gold", recipeConsumer);
        this.buildCrushingRecipesForMetal("quicksilver", recipeConsumer);
        this.buildCrushingRecipesForMetal("iron", recipeConsumer);
        this.buildCrushingRecipesForMetal("iesnium", recipeConsumer);
        this.buildCrushingRecipeForGem("diamond", recipeConsumer);
        this.buildCrushingRecipeForGem("emerald", recipeConsumer);
        this.buildCrushingRecipeForGem("lapis", recipeConsumer);
        this.buildCrushingRecipeForGem("quartz", recipeConsumer);
        this.buildCrushingRecipeForGem("coal", recipeConsumer);
        this.buildCrushingRecipeForGem("redstone", recipeConsumer);
        this.buildCrushingRecipeForGem("apatite", recipeConsumer);
        this.buildCrushingRecipeForGem("sulfur", recipeConsumer);
        this.buildCrushingRecipeForGem("fluorite", recipeConsumer);
        this.buildCrushingRecipeForGem("cinnabar", recipeConsumer);
        this.buildCrushingRecipeForGem("amber", recipeConsumer);
        this.buildCrushingRecipeForGem("certus_quartz", recipeConsumer);
        this.buildCrushingRecipeForGem("charged_certus_quartz", recipeConsumer);
        this.buildCrushingRecipeForGem("peridot", recipeConsumer);
        this.buildCrushingRecipeForGem("ruby", recipeConsumer);
        this.buildCrushingRecipeForGem("sapphire", recipeConsumer);
        this.buildCrushingRecipeForGem("topaz", recipeConsumer);
        this.buildCrushingRecipeForGem("arcane_crystal", recipeConsumer);
    }

    protected void buildCrushingRecipeForGem(String gem, Consumer<Pair<ResourceLocation, JsonObject>> recipeConsumer) {
        ResourceLocation gemDustId = new ResourceLocation("occultism", gem + "_dust");
        JsonObject gemDustRecipe = this.buildCrushingRecipe("forge:ores/" + gem, "forge:dusts/" + gem, 4, 200, false);
        recipeConsumer.accept((Pair<ResourceLocation, JsonObject>)new Pair((Object)gemDustId, (Object)gemDustRecipe));
        ResourceLocation gemDustFromGemId = new ResourceLocation("occultism", gem + "_dust_from_gem");
        JsonObject gemDustFromGemRecipe = this.buildCrushingRecipe("forge:gems/" + gem, "forge:dusts/" + gem, 1, 200, true);
        recipeConsumer.accept((Pair<ResourceLocation, JsonObject>)new Pair((Object)gemDustFromGemId, (Object)gemDustFromGemRecipe));
    }

    protected void buildCrushingRecipesForMetal(String metal, Consumer<Pair<ResourceLocation, JsonObject>> recipeConsumer) {
        ResourceLocation metalDustRecipeId = new ResourceLocation("occultism", metal + "_dust");
        JsonObject metalDustRecipe = this.buildCrushingRecipe("forge:ores/" + metal, "forge:dusts/" + metal, 2, 200, false);
        recipeConsumer.accept((Pair<ResourceLocation, JsonObject>)new Pair((Object)metalDustRecipeId, (Object)metalDustRecipe));
        ResourceLocation metalDustFromRawRecipeId = new ResourceLocation("occultism", metal + "_dust_from_raw");
        JsonObject metalDustFromRawRecipe = this.buildCrushingRecipe("forge:raw_materials/" + metal, "forge:dusts/" + metal, 2, 200, false);
        recipeConsumer.accept((Pair<ResourceLocation, JsonObject>)new Pair((Object)metalDustFromRawRecipeId, (Object)metalDustFromRawRecipe));
        ResourceLocation metalDustFromRawBlockRecipeId = new ResourceLocation("occultism", metal + "_dust_from_raw_block");
        JsonObject metalDustFromRawBlockRecipe = this.buildCrushingRecipe("forge:storage_blocks/raw_" + metal, "forge:dusts/" + metal, 18, 1600, false);
        recipeConsumer.accept((Pair<ResourceLocation, JsonObject>)new Pair((Object)metalDustFromRawBlockRecipeId, (Object)metalDustFromRawBlockRecipe));
        ResourceLocation metalDustFromIngotRecipeId = new ResourceLocation("occultism", metal + "_dust_from_ingot");
        JsonObject metalDustFromIngotRecipe = this.buildCrushingRecipe("forge:ingots/" + metal, "forge:dusts/" + metal, 1, 200, true);
        recipeConsumer.accept((Pair<ResourceLocation, JsonObject>)new Pair((Object)metalDustFromIngotRecipeId, (Object)metalDustFromIngotRecipe));
    }

    public JsonObject buildCrushingRecipe(String inputTag, String outputTag, int count, int crushingTime, boolean ignoreCrushingMultiplier) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "occultism:crushing");
        JsonArray conditions = this.buildCrushingCondition(inputTag, outputTag);
        recipe.add("conditions", (JsonElement)conditions);
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("tag", inputTag);
        recipe.add("ingredient", (JsonElement)ingredient);
        JsonObject result = new JsonObject();
        result.addProperty("tag", outputTag);
        result.addProperty("count", (Number)count);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("crushing_time", (Number)crushingTime);
        recipe.addProperty("ignore_crushing_multiplier", Boolean.valueOf(ignoreCrushingMultiplier));
        return recipe;
    }

    public JsonArray buildCrushingCondition(String inputTag, String outputTag) {
        JsonArray conditions = new JsonArray();
        JsonObject condition = new JsonObject();
        condition.addProperty("type", "forge:not");
        JsonObject value = new JsonObject();
        value.addProperty("type", "forge:tag_empty");
        value.addProperty("tag", inputTag);
        condition.add("value", (JsonElement)value);
        conditions.add((JsonElement)condition);
        condition = new JsonObject();
        condition.addProperty("type", "forge:not");
        value = new JsonObject();
        value.addProperty("type", "forge:tag_empty");
        value.addProperty("tag", outputTag);
        condition.add("value", (JsonElement)value);
        conditions.add((JsonElement)condition);
        return conditions;
    }

    public String m_6055_() {
        return "Crushing Recipes";
    }
}

