/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class OccultismServerConfig {
    public final StorageSettings storage;
    public final SpiritJobSettings spiritJobs;
    public final RitualSettings rituals;
    public final DimensionalMineshaftSettings dimensionalMineshaft;
    public final ItemSettings itemSettings;
    public final ForgeConfigSpec spec;

    public OccultismServerConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.storage = new StorageSettings(builder);
        this.spiritJobs = new SpiritJobSettings(builder);
        this.rituals = new RitualSettings(builder);
        this.dimensionalMineshaft = new DimensionalMineshaftSettings(builder);
        this.itemSettings = new ItemSettings(builder);
        this.spec = builder.build();
    }

    public static class StorageSettings {
        public final ForgeConfigSpec.ConfigValue<Integer> stabilizerTier1Slots;
        public final ForgeConfigSpec.ConfigValue<Integer> stabilizerTier2Slots;
        public final ForgeConfigSpec.ConfigValue<Integer> stabilizerTier3Slots;
        public final ForgeConfigSpec.ConfigValue<Integer> stabilizerTier4Slots;
        public final ForgeConfigSpec.ConfigValue<Integer> controllerBaseSlots;
        public final ForgeConfigSpec.ConfigValue<Integer> controllerStackSize;
        public final ForgeConfigSpec.BooleanValue overrideItemStackSizes;

        public StorageSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Storage Settings").push("storage");
            this.stabilizerTier1Slots = builder.comment("The amount of slots the storage stabilizer tier 1 provides.").define("stabilizerTier1Slots", (Object)256);
            this.stabilizerTier2Slots = builder.comment("The amount of slots the storage stabilizer tier 2 provides.").define("stabilizerTier2Slots", (Object)512);
            this.stabilizerTier3Slots = builder.comment("The amount of slots the storage stabilizer tier 3 provides.").define("stabilizerTier3Slots", (Object)1024);
            this.stabilizerTier4Slots = builder.comment("The amount of slots the storage stabilizer tier 4 provides.").define("stabilizerTier4Slots", (Object)2048);
            this.controllerBaseSlots = builder.comment("The amount of slots the storage actuator provides.").define("controllerBaseSlots", (Object)128);
            this.controllerStackSize = builder.comment("The stack size the storage actuator uses.").define("controllerStackSize", (Object)1024);
            this.overrideItemStackSizes = builder.comment("True to use the configured controllerStackSize for all items, instead of the stack sizes provided by item type (such as 16 for ender pearls, 64 for iron ingot). WARNING: Setting this to false may have a negative impact on performance.").define("overrideItemStackSizes", true);
            builder.pop();
        }
    }

    public static class SpiritJobSettings {
        public final ForgeConfigSpec.ConfigValue<Double> tier1CrusherTimeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> tier2CrusherTimeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> tier3CrusherTimeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> tier4CrusherTimeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> tier1CrusherOutputMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> tier2CrusherOutputMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> tier3CrusherOutputMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> tier4CrusherOutputMultiplier;
        public final ForgeConfigSpec.ConfigValue<Integer> drikwingFamiliarSlowFallingSeconds;
        public final ForgeConfigSpec.ConfigValue<Integer> crusherResultPickupDelay;
        public final ForgeConfigSpec.ConfigValue<Integer> blacksmithFamiliarUpgradeCost;
        public final ForgeConfigSpec.ConfigValue<Integer> blacksmithFamiliarUpgradeCooldown;
        public final ForgeConfigSpec.ConfigValue<Double> blacksmithFamiliarRepairChance;

        public SpiritJobSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Spirit Job Settings").push("spirit_job");
            this.drikwingFamiliarSlowFallingSeconds = builder.comment("The duration for the slow falling effect applied by a drikwing.").define("drikwingFamiliarSlowFallingSeconds", (Object)15);
            this.tier1CrusherTimeMultiplier = builder.comment("The multiplier to each crushing recipe's crushing_time for Tier 1 (Foliot) Crusher Spirits.").define("tier1CrusherTimeMultiplier", (Object)2.0);
            this.tier2CrusherTimeMultiplier = builder.comment("The multiplier to each crushing recipe's crushing_time for Tier 2 (Djinni) Crusher Spirits.").define("tier2CrusherTimeMultiplier", (Object)1.0);
            this.tier3CrusherTimeMultiplier = builder.comment("Currently unused. The multiplier to each crushing recipe's crushing_time for Tier 3 (Afrit) Crusher Spirits.").define("tier3CrusherTimeMultiplier", (Object)0.5);
            this.tier4CrusherTimeMultiplier = builder.comment("Currently unused. The multiplier to each crushing recipe's crushing_time for Tier 4 (Marid) Crusher Spirits.").define("tier4CrusherTimeMultiplier", (Object)0.2);
            this.tier1CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 1 (Foliot) Crusher Spirits.").define("tier1CrusherOutputMultiplier", (Object)1.0);
            this.tier2CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 2 (Djinni) Crusher Spirits.").define("tier2CrusherOutputMultiplier", (Object)1.5);
            this.tier3CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 3 (Afrit) Crusher Spirits.").define("tier3CrusherOutputMultiplier", (Object)2.0);
            this.tier4CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 4 (Marid) Crusher Spirits.").define("tier4CrusherOutputMultiplier", (Object)3.0);
            this.crusherResultPickupDelay = builder.comment("The minimum ticks before a crusher can pick up an item it dropped. Default is 3 Seconds = 3 * 20 Ticks.").define("crusherResultPickupDelay", (Object)60);
            this.blacksmithFamiliarRepairChance = builder.comment("The chance for a blacksmith familiar to repair an item (by 2 durability) whenever stone is picked up. 1.0 = 100%, 0.0 = 0%.").define("blacksmithFamiliarRepairChance", (Object)0.05);
            this.blacksmithFamiliarUpgradeCost = builder.comment("The amount of iron required for a blacksmith familiar to upgrade another familiar.").define("blacksmithFamiliarUpgradeCost", (Object)18);
            this.blacksmithFamiliarUpgradeCooldown = builder.comment("The cooldown for a blacksmith familiar to upgrade another familiar.").define("blacksmithFamiliarUpgradeCooldown", (Object)400);
            builder.pop();
        }
    }

    public static class RitualSettings {
        public final ForgeConfigSpec.BooleanValue enableClearWeatherRitual;
        public final ForgeConfigSpec.BooleanValue enableRainWeatherRitual;
        public final ForgeConfigSpec.BooleanValue enableThunderWeatherRitual;
        public final ForgeConfigSpec.BooleanValue enableDayTimeRitual;
        public final ForgeConfigSpec.BooleanValue enableNightTimeRitual;
        public final ForgeConfigSpec.BooleanValue enableRemainingIngredientCountMatching;
        public final ForgeConfigSpec.DoubleValue ritualDurationMultiplier;
        public final ForgeConfigSpec.ConfigValue<List<String>> possibleSpiritNames;
        public final ForgeConfigSpec.DoubleValue usePossibleSpiritNamesChance;

        public RitualSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Ritual Settings").push("rituals");
            this.enableClearWeatherRitual = builder.comment("Enables the ritual to clear rainy weather.").define("enableClearWeatherRitual", true);
            this.enableRainWeatherRitual = builder.comment("Enables the ritual to start rainy weather.").define("enableRainWeatherRitual", true);
            this.enableThunderWeatherRitual = builder.comment("Enables the ritual to start a thunderstorm.").define("enableThunderWeatherRitual", true);
            this.enableDayTimeRitual = builder.comment("Enables the ritual to set time to day.").define("enableDayTimeRitual", true);
            this.enableNightTimeRitual = builder.comment("Enables the ritual to set time to night.").define("enableNightTimeRitual", true);
            this.enableRemainingIngredientCountMatching = builder.comment("If enabled, rituals are interrupted if *more* ingredients are present than needed. This should usually be disabled, but can improve performance if (very very) many rituals are running.").define("enableRemainingIngredientCountMatching", false);
            this.ritualDurationMultiplier = builder.comment("Set a value below 1.0 to speed up rituals.").defineInRange("ritualDurationMultiplier", 1.0, 0.05, Double.MAX_VALUE);
            this.possibleSpiritNames = builder.comment("By default spirit names are generated randomly. This list can be used as an additional source of spirit names, or even a full replacement, depending on the configuration of \"usePossibleSpiritNamesChance\".").define("possibleSpiritNames", new ArrayList());
            this.usePossibleSpiritNamesChance = builder.comment(new String[]{"0.0 (default) to only use random names.", "1.0 to only use the names in \"possibleSpiritNames\"", "0.1-0.9 to use a mix of both, the higher the value the higher the chance of using a name from this list instead of a random name.", "Will be ignored if \"possibleSpiritNames\" is empty."}).defineInRange("usePossibleSpiritNamesChance", 0.0, 0.0, 1.0);
            builder.pop();
        }
    }

    public static class DimensionalMineshaftSettings {
        public final MinerSpiritSettings minerFoliotUnspecialized;
        public final MinerSpiritSettings minerDjinniOres;
        public final MinerSpiritSettings minerAfritDeeps;
        public final MinerSpiritSettings minerMaridMaster;

        public DimensionalMineshaftSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Dimensional Mineshaft Settings").push("dimensional_mineshaft");
            this.minerFoliotUnspecialized = new MinerSpiritSettings("miner_foliot_unspecialized", builder, 400, 1, 1000);
            this.minerDjinniOres = new MinerSpiritSettings("miner_djinni_ores", builder, 300, 1, 400);
            this.minerAfritDeeps = new MinerSpiritSettings("miner_afrit_deeps", builder, 200, 1, 800);
            this.minerMaridMaster = new MinerSpiritSettings("miner_marid_master", builder, 100, 1, 1600);
            builder.pop();
        }

        public static class MinerSpiritSettings {
            public final ForgeConfigSpec.ConfigValue<Integer> maxMiningTime;
            public final ForgeConfigSpec.ConfigValue<Integer> rollsPerOperation;
            public final ForgeConfigSpec.ConfigValue<Integer> durability;

            public MinerSpiritSettings(String oreName, ForgeConfigSpec.Builder builder, int maxMiningTime, int rollsPerOperation, int durability) {
                builder.comment("Miner Spirit Settings").push(oreName);
                this.maxMiningTime = builder.comment("The amount of time it takes the spirit to perform one mining operation.").define("maxMiningTime", (Object)maxMiningTime);
                this.rollsPerOperation = builder.comment("The amount of blocks the spirit will obtain per mining operation").define("rollsPerOperation", (Object)rollsPerOperation);
                this.durability = builder.comment("The amount of mining operations the spirit can perform before breaking.").define("durability", (Object)durability);
                builder.pop();
            }
        }
    }

    public static class ItemSettings {
        public ItemSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Item Settings").push("items");
            builder.pop();
        }
    }
}

