/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.entity.ai.behaviour.DepositItemsBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.FellTreeBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.HandleUnreachableTreeBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.PickupItemBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.ReplantSaplingBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToDepositBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToItemBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToReplantSaplingBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToTreeBehaviour;
import com.klikli_dev.occultism.common.entity.ai.sensor.NearestJobItemSensor;
import com.klikli_dev.occultism.common.entity.ai.sensor.NearestTreeSensor;
import com.klikli_dev.occultism.common.entity.ai.sensor.UnreachableTreeWalkTargetSensor;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class LumberjackJob
extends SpiritJob {
    protected List<Ingredient> itemsToPickUp = new ArrayList<Ingredient>();

    public LumberjackJob(SpiritEntity entity) {
        super(entity);
    }

    @Override
    public List<ExtendedSensor<SpiritEntity>> getSensors() {
        return ImmutableList.of(new NearestTreeSensor(), new NearestJobItemSensor(), new UnreachableTreeWalkTargetSensor());
    }

    @Override
    public BrainActivityGroup<SpiritEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTargetSink(8, 8), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new MoveToWalkTarget(), new ReplantSaplingBehaviour(), new DepositItemsBehaviour(), new PickupItemBehaviour(), new FellTreeBehaviour()})});
    }

    @Override
    public BrainActivityGroup<SpiritEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetWalkTargetToReplantSaplingBehaviour(), new SetWalkTargetToDepositBehaviour(), new SetWalkTargetToItemBehaviour(), new SetWalkTargetToTreeBehaviour()}), new HandleUnreachableTreeBehaviour()});
    }

    @Override
    public void handleAdditionalBrainSetup(Brain<? extends SpiritEntity> brain) {
    }

    @Override
    public void onInit() {
        this.itemsToPickUp.add(Ingredient.m_204132_((TagKey)ItemTags.f_13182_));
        this.itemsToPickUp.add(Ingredient.m_204132_((TagKey)ItemTags.f_13143_));
        this.itemsToPickUp.add(Ingredient.m_204132_((TagKey)ItemTags.f_13180_));
        this.itemsToPickUp.add(Ingredient.m_204132_(OccultismTags.FRUITS));
        this.itemsToPickUp.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42398_}));
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        return !stack.m_41619_() && this.itemsToPickUp.stream().anyMatch(i -> i.test(stack));
    }

    @Override
    public List<Ingredient> getItemsToPickUp() {
        return this.itemsToPickUp;
    }

    @Override
    public void onChangeWorkArea() {
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.NO_TREE_IN_WORK_AREA.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.UNREACHABLE_TREES.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.NON_TREE_LOGS.get());
    }
}

