/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.spirit.FoliotEntity;
import com.klikli_dev.occultism.registry.OccultismSpiritJobs;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class FoliotModel
extends DefaultedEntityGeoModel<FoliotEntity> {
    public static final String ASSET_SUBPATH = "foliot";
    public final ModelData crusher = this.buildModelData("crusher");
    public final ModelData transporter = this.buildModelData("transporter");
    public final ModelData janitor = this.buildModelData("janitor");
    public final ModelData lumberjack = this.buildModelData("lumberjack");
    public final ModelData saplingTrader;
    public final ModelData otherstoneTrader = this.buildModelData("otherstone_trader");

    public FoliotModel() {
        super(new ResourceLocation("occultism", ASSET_SUBPATH), false);
        this.saplingTrader = this.buildModelData("sapling_trader");
    }

    public ModelData getModelData(FoliotEntity animatable) {
        String job = animatable.getJobID();
        if (Objects.equals(job, OccultismSpiritJobs.TRANSPORT_ITEMS.getId().toString())) {
            return this.transporter;
        }
        if (Objects.equals(job, OccultismSpiritJobs.CLEANER.getId().toString())) {
            return this.janitor;
        }
        if (Objects.equals(job, OccultismSpiritJobs.LUMBERJACK.getId().toString())) {
            return this.lumberjack;
        }
        if (Objects.equals(job, OccultismSpiritJobs.TRADE_OTHERSTONE_T1.getId().toString())) {
            return this.otherstoneTrader;
        }
        if (Objects.equals(job, OccultismSpiritJobs.TRADE_OTHERWORLD_SAPLINGS_T2.getId().toString())) {
            return this.saplingTrader;
        }
        return this.crusher;
    }

    public ResourceLocation getModelResource(FoliotEntity animatable) {
        return this.getModelData(animatable).model();
    }

    public ResourceLocation getTextureResource(FoliotEntity animatable) {
        return this.getModelData(animatable).texture();
    }

    public ResourceLocation getAnimationResource(FoliotEntity animatable) {
        return this.getModelData(animatable).animation();
    }

    public ModelData buildModelData(String job) {
        return this.buildModelData(job, "_");
    }

    public ModelData buildModelData(String job, String separator) {
        return new ModelData(this.buildFormattedModelPath(new ResourceLocation("occultism", ASSET_SUBPATH + separator + job)), this.buildFormattedTexturePath(new ResourceLocation("occultism", ASSET_SUBPATH + separator + job)), this.buildFormattedAnimationPath(new ResourceLocation("occultism", ASSET_SUBPATH + separator + job)));
    }

    public record ModelData(ResourceLocation model, ResourceLocation texture, ResourceLocation animation) {
    }
}

