/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.spirit.DjinniEntity;
import com.klikli_dev.occultism.registry.OccultismSpiritJobs;
import java.util.Objects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class DjinniModel
extends DefaultedEntityGeoModel<DjinniEntity> {
    public static final String ASSET_SUBPATH = "djinni";
    public final ModelData worker = this.buildModelData("worker");
    public final ModelData machineManager = this.buildModelData("machine_manager");

    public DjinniModel() {
        super(new ResourceLocation("occultism", ASSET_SUBPATH), false);
    }

    public ModelData getModelData(DjinniEntity animatable) {
        String job = animatable.getJobID();
        if (Objects.equals(job, OccultismSpiritJobs.MANAGE_MACHINE.getId().toString())) {
            return this.machineManager;
        }
        return this.worker;
    }

    public RenderType getRenderType(DjinniEntity animatable, ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureResource(animatable));
    }

    public ResourceLocation getModelResource(DjinniEntity animatable) {
        return this.getModelData(animatable).model();
    }

    public ResourceLocation getTextureResource(DjinniEntity animatable) {
        return this.getModelData(animatable).texture();
    }

    public ResourceLocation getAnimationResource(DjinniEntity animatable) {
        return this.getModelData(animatable).animation();
    }

    public ModelData buildModelData(String job) {
        return this.buildModelData(job, "_");
    }

    public ModelData buildModelData(String job, String separator) {
        return new ModelData(this.buildFormattedModelPath(new ResourceLocation("occultism", ASSET_SUBPATH + separator + job)), this.buildFormattedTexturePath(new ResourceLocation("occultism", ASSET_SUBPATH + separator + job)), this.buildFormattedAnimationPath(new ResourceLocation("occultism", ASSET_SUBPATH + separator + job)));
    }

    public record ModelData(ResourceLocation model, ResourceLocation texture, ResourceLocation animation) {
    }
}

