/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.noflyzone.event;

import cy.jdkdigital.noflyzone.Config;
import cy.jdkdigital.noflyzone.util.CompatHandler;
import cy.jdkdigital.noflyzone.util.FlightHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="noflyzone")
public class EventHandler {
    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        Player player;
        Entity entity;
        if (!Config.allowTeleporting && (entity = event.getEntity()) instanceof Player && !FlightHelper.isAllowedToFly(player = (Player)entity)) {
            event.setCanceled(true);
            FlightHelper.sendTeleportNotice(player);
        }
    }

    @SubscribeEvent
    public static void onEntityUseItem(PlayerInteractEvent.RightClickItem event) {
        if (!Config.allowFlyingDevices && CompatHandler.isFlyingDevice(event.getItemStack()) && !FlightHelper.isAllowedToFly(event.getEntity())) {
            event.setCanceled(true);
            FlightHelper.sendFlightNotice(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19797_ % Config.checkInterval == 0 && FlightHelper.isFlying(event.player) && !FlightHelper.isAllowedToFly(event.player)) {
            FlightHelper.stopFlying(event.player);
        }
    }
}

