/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.DistancedFollowParentGoal;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Elephant
extends Animal
implements NeutralMob,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> DRINKING = SynchedEntityData.m_135353_(Elephant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Elephant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public Elephant(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 1.2).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, 20.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnData, @javax.annotation.Nullable CompoundTag dataTag) {
        AgeableMob.AgeableMobGroupData ageableMobGroupData;
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(true);
        }
        if ((ageableMobGroupData = (AgeableMob.AgeableMobGroupData)spawnData).m_146777_() > 1) {
            this.m_146762_(-24000);
        }
        ageableMobGroupData.m_146778_();
        RandomSource random = level.m_213780_();
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", random.m_216328_(0.0, 0.11485000000000001), AttributeModifier.Operation.MULTIPLY_BASE));
        return spawnData;
    }

    @javax.annotation.Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)NaturalistEntityTypes.ELEPHANT.get().m_20615_((Level)serverLevel);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level);
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.2);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Bee.class, 8.0f, 1.3, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new ElephantMeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(4, (Goal)new DistancedFollowParentGoal(this, 1.25, 24.0, 6.0, 12.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BabyHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Elephant)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public int m_8085_() {
        return 35;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return NaturalistSoundEvents.ELEPHANT_HURT.get();
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return NaturalistSoundEvents.ELEPHANT_AMBIENT.get();
    }

    public boolean m_7327_(Entity target) {
        boolean shouldHurt = target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (shouldHurt && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            Vec3 knockbackDirection = new Vec3((double)this.m_20183_().m_123341_() - target.m_20185_(), 0.0, (double)this.m_20183_().m_123343_() - target.m_20189_()).m_82541_();
            float shieldBlockModifier = livingEntity.m_21275_(target.m_269291_().m_269333_((LivingEntity)this)) ? 0.5f : 1.0f;
            livingEntity.m_147240_((double)shieldBlockModifier * 3.0, knockbackDirection.m_7096_(), knockbackDirection.m_7094_());
            double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(0.0, 0.5 * knockbackResistance, 0.0));
        }
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return shouldHurt;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(DRINKING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)pTime);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_6925_(@javax.annotation.Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Elephant> PlayState predicate(AnimationState<E> event) {
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            if (this.m_20142_()) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("run"));
                event.getController().setAnimationSpeed((double)1.2f);
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
                event.getController().setAnimationSpeed((double)0.7f);
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            event.getController().setAnimationSpeed(0.5);
        }
        return PlayState.CONTINUE;
    }

    private <E extends Elephant> PlayState swingPredicate(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().thenPlay("elephant.swing"));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "swingController", 0, this::swingPredicate)});
    }

    static class ElephantMeleeAttackGoal
    extends MeleeAttackGoal {
        public ElephantMeleeAttackGoal(PathfinderMob pathfinderMob, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
            super(pathfinderMob, speedMultiplier, followingTargetEvenIfNotSeen);
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return Mth.m_14207_((float)this.f_25540_.m_20205_());
        }
    }
}

