/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Tortoise;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class TortoiseModel
extends GeoModel<Tortoise> {
    public ResourceLocation getModelResource(Tortoise tortoise) {
        return new ResourceLocation("naturalist", "geo/tortoise.geo.json");
    }

    public ResourceLocation getTextureResource(Tortoise tortoise) {
        return switch (tortoise.getVariant()) {
            case 1 -> new ResourceLocation("naturalist", "textures/entity/tortoise/green.png");
            case 2 -> new ResourceLocation("naturalist", "textures/entity/tortoise/black.png");
            default -> new ResourceLocation("naturalist", "textures/entity/tortoise/brown.png");
        };
    }

    public ResourceLocation getAnimationResource(Tortoise tortoise) {
        return new ResourceLocation("naturalist", "animations/tortoise.animation.json");
    }

    public void setCustomAnimations(Tortoise animatable, long instanceId, AnimationState<Tortoise> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (animatable.m_6162_()) {
            head.setScaleX(1.4f);
            head.setScaleY(1.4f);
            head.setScaleZ(1.4f);
        } else {
            head.setScaleX(1.0f);
            head.setScaleY(1.0f);
            head.setScaleZ(1.0f);
        }
        head.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
    }
}

