/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import commoble.morered.wires.AbstractWireBlock;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelCache
extends SavedData {
    public static final String ID = "morered:voxelcache";
    private static VoxelCache clientCache = null;
    protected final Level world;
    public final LoadingCache<BlockPos, VoxelShape> shapesByPos;

    public VoxelCache(@Nonnull Level world) {
        this.world = world;
        this.shapesByPos = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new VoxelLoader());
    }

    public static VoxelCache get(@Nonnull Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (VoxelCache)serverLevel.m_8895_().m_164861_(tag -> new VoxelCache(level), () -> new VoxelCache(level), ID);
        }
        if (clientCache == null || VoxelCache.clientCache.world != level) {
            clientCache = new VoxelCache(level);
        }
        return clientCache;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        return tag;
    }

    public static void clearClientCache() {
        clientCache = null;
    }

    public VoxelShape getWireShape(BlockPos pos) {
        return (VoxelShape)this.shapesByPos.getUnchecked((Object)pos.m_7949_());
    }

    public class VoxelLoader
    extends CacheLoader<BlockPos, VoxelShape> {
        public VoxelShape load(BlockPos pos) throws Exception {
            Level world = VoxelCache.this.world;
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof AbstractWireBlock)) {
                return Shapes.m_83040_();
            }
            AbstractWireBlock wireBlock = (AbstractWireBlock)block;
            return wireBlock.getCachedExpandedShapeVoxel(state, world, pos);
        }
    }
}

