/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.util;

import com.mojang.math.OctahedralGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class EightGroup {
    private static final OctahedralGroup[] STRUCTURE_TRANSFORMS = new OctahedralGroup[]{OctahedralGroup.IDENTITY, OctahedralGroup.ROT_180_FACE_XZ, OctahedralGroup.ROT_90_Y_NEG, OctahedralGroup.ROT_90_Y_POS, OctahedralGroup.INVERT_X, OctahedralGroup.INVERT_Z, OctahedralGroup.SWAP_XZ, OctahedralGroup.SWAP_NEG_XZ};
    public static final EnumProperty<OctahedralGroup> TRANSFORM = EnumProperty.m_61598_((String)"transform", OctahedralGroup.class, (Enum[])STRUCTURE_TRANSFORMS);

    public static BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(TRANSFORM, (Comparable)rotation.m_55948_().m_56521_((OctahedralGroup)state.m_61143_(TRANSFORM)));
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_(TRANSFORM, (Comparable)mirror.m_54842_().m_56521_((OctahedralGroup)state.m_61143_(TRANSFORM)));
    }

    public static BlockPos transform(BlockPos pos, OctahedralGroup group) {
        if (group == OctahedralGroup.IDENTITY) {
            return pos;
        }
        BlockPos newPos = new BlockPos(0, 0, 0);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (x != 0) {
            Direction oldDirX = x > 0 ? Direction.EAST : Direction.WEST;
            Direction newDirX = group.m_56528_(oldDirX);
            newPos = newPos.m_5484_(newDirX, Math.abs(x));
        }
        if (y != 0) {
            Direction oldDirY = y > 0 ? Direction.UP : Direction.DOWN;
            Direction newDirY = group.m_56528_(oldDirY);
            newPos = newPos.m_5484_(newDirY, Math.abs(y));
        }
        if (z != 0) {
            Direction oldDirZ = z > 0 ? Direction.SOUTH : Direction.NORTH;
            Direction newDirZ = group.m_56528_(oldDirZ);
            newPos = newPos.m_5484_(newDirZ, Math.abs(z));
        }
        return newPos;
    }
}

