/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;

public class BlockStateUtil {
    public static final Direction[][] OUTPUT_TABLE = new Direction[][]{{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}, {Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.EAST}, {Direction.UP, Direction.EAST, Direction.DOWN, Direction.WEST}, {Direction.UP, Direction.WEST, Direction.DOWN, Direction.EAST}, {Direction.UP, Direction.NORTH, Direction.DOWN, Direction.SOUTH}, {Direction.UP, Direction.SOUTH, Direction.DOWN, Direction.NORTH}};

    public static Direction getOutputDirection(Direction attachmentDirection, int rotationIndex) {
        return OUTPUT_TABLE[attachmentDirection.ordinal()][rotationIndex];
    }

    public static Direction getInputDirection(Direction attachmentDirection, int outputRotationIndex, int rotationsFromOutput) {
        return BlockStateUtil.getOutputDirection(attachmentDirection, (outputRotationIndex + rotationsFromOutput) % 4);
    }

    public static int getRotatedRotation(Direction attachmentFace, int rotationIndex, Rotation rotation) {
        if (attachmentFace == Direction.DOWN) {
            return (rotationIndex + rotation.ordinal()) % 4;
        }
        if (attachmentFace == Direction.UP) {
            return (rotationIndex + 4 - rotation.ordinal()) % 4;
        }
        return rotationIndex;
    }

    public static int getMirroredRotation(Direction attachmentFace, int rotationIndex, Mirror mirror) {
        boolean rotationIsEven;
        if (mirror == Mirror.NONE) {
            return rotationIndex;
        }
        boolean specialCase = mirror == Mirror.LEFT_RIGHT && attachmentFace.m_122434_() == Direction.Axis.Y;
        boolean bl = rotationIsEven = rotationIndex % 2 == 0;
        if (specialCase && rotationIsEven || !specialCase && !rotationIsEven) {
            return (rotationIndex + 2) % 4;
        }
        return rotationIndex;
    }

    public static int getRotationIndexForDirection(Direction attachmentFace, Direction outputDirection) {
        Direction[] rotatedOutputs = OUTPUT_TABLE[attachmentFace.ordinal()];
        int size = rotatedOutputs.length;
        for (int i = 0; i < size; ++i) {
            if (rotatedOutputs[i] != outputDirection) continue;
            return i;
        }
        return 0;
    }

    public static Direction getOutputDirectionFromRelativeHitVec(Vec3 hitVec, Direction directionTowardBlockAttachedTo) {
        Direction.Axis axis = directionTowardBlockAttachedTo.m_122434_();
        float x = (float)(axis == Direction.Axis.X ? 0.0 : hitVec.f_82479_ * 2.0 - 1.0);
        float y = (float)(axis == Direction.Axis.Y ? 0.0 : hitVec.f_82480_ * 2.0 - 1.0);
        float z = (float)(axis == Direction.Axis.Z ? 0.0 : hitVec.f_82481_ * 2.0 - 1.0);
        return Direction.m_122372_((float)x, (float)y, (float)z);
    }
}

