/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay;

import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public class LightOverlayRenderer
implements ILightRenderer {
    private static final ResourceLocation BLANK_TEX = new ResourceLocation("moreoverlays", "textures/blank.png");
    private static Tesselator tess;
    private static BufferBuilder renderer;
    private static Minecraft minecraft;

    public LightOverlayRenderer() {
        tess = Tesselator.m_85913_();
        renderer = tess.m_85915_();
        minecraft = Minecraft.m_91087_();
    }

    private static void renderCross(PoseStack matrixstack, BlockPos pos, float r, float g, float b) {
        LocalPlayer player = LightOverlayRenderer.minecraft.f_91074_;
        if (player == null) {
            return;
        }
        BlockState blockStateBelow = player.m_9236_().m_8055_(pos);
        float y = 0.0f;
        y = blockStateBelow.m_204336_(BlockTags.f_144279_) ? ((double)pos.m_123342_() > player.m_20186_() ? 0.005f + ((float)pos.m_123342_() + 0.125f) : (float)((double)(0.005f + ((float)pos.m_123342_() + 0.125f)) + (double)0.01f * -((double)pos.m_123342_() - player.m_20186_() - 1.0))) : ((double)pos.m_123342_() > player.m_20186_() ? 0.005f + (float)pos.m_123342_() : (float)((double)(0.005f + (float)pos.m_123342_()) + (double)0.01f * -((double)pos.m_123342_() - player.m_20186_() - 1.0)));
        int x0 = pos.m_123341_();
        int x1 = x0 + 1;
        int z0 = pos.m_123343_();
        int z1 = z0 + 1;
        Matrix4d matrix4d = new Matrix4d();
        matrixstack.m_85850_().m_252922_().get(matrix4d);
        Camera camera = LightOverlayRenderer.minecraft.f_91063_.m_109153_();
        double cameraX = camera.m_90583_().f_82479_;
        double cameraY = camera.m_90583_().f_82480_;
        double cameraZ = camera.m_90583_().f_82481_;
        LightOverlayRenderer.drawVertex(matrix4d, (double)x0 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
        LightOverlayRenderer.drawVertex(matrix4d, (double)x1 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
        LightOverlayRenderer.drawVertex(matrix4d, (double)x1 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
        LightOverlayRenderer.drawVertex(matrix4d, (double)x0 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
    }

    private static void drawVertex(Matrix4d matrix, double x, double y, double z, float r, float g, float b) {
        Vector4d vector4d = matrix.transform(new Vector4d(x, y, z, 1.0));
        renderer.m_5483_(vector4d.x(), vector4d.y(), vector4d.z()).m_85950_(r, g, b, 1.0f).m_5752_();
    }

    @Override
    public void renderOverlays(ILightScanner scanner, PoseStack matrixstack) {
        Minecraft.m_91087_().m_91097_().m_174784_(BLANK_TEX);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)((float)((Double)Config.render_chunkLineWidth.get()).doubleValue()));
        RenderSystem.setShader(GameRenderer::m_172811_);
        if (Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() != GraphicsStatus.FABULOUS) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableCull();
        }
        float ar = (float)((Integer)Config.render_spawnAColor.get() >> 16 & 0xFF) / 255.0f;
        float ag = (float)((Integer)Config.render_spawnAColor.get() >> 8 & 0xFF) / 255.0f;
        float ab = (float)((Integer)Config.render_spawnAColor.get() & 0xFF) / 255.0f;
        float nr = (float)((Integer)Config.render_spawnNColor.get() >> 16 & 0xFF) / 255.0f;
        float ng = (float)((Integer)Config.render_spawnNColor.get() >> 8 & 0xFF) / 255.0f;
        float nb = (float)((Integer)Config.render_spawnNColor.get() & 0xFF) / 255.0f;
        renderer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        for (Pair<BlockPos, Byte> entry : scanner.getLightModes()) {
            Byte mode = (Byte)entry.getValue();
            if (mode == null || mode == 0) continue;
            if (mode == 1) {
                LightOverlayRenderer.renderCross(matrixstack, (BlockPos)entry.getKey(), nr, ng, nb);
                continue;
            }
            if (mode != 2) continue;
            LightOverlayRenderer.renderCross(matrixstack, (BlockPos)entry.getKey(), ar, ag, ab);
        }
        tess.m_85914_();
        RenderSystem.depthMask((boolean)true);
        if (Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() != GraphicsStatus.FABULOUS) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableBlend();
        }
    }
}

