/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.potion;

import com.almostreliable.morejs.features.potion.PotionBrewingRegisterEvent;
import com.almostreliable.morejs.mixin.BrewingRecipeRegistryAccessor;
import com.almostreliable.morejs.mixin.potion.PotionBrewingAccessor;
import com.almostreliable.morejs.util.Utils;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.ListIterator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionBrewingRegisterEventForge
extends PotionBrewingRegisterEvent {
    @Override
    public void addCustomBrewing(Ingredient topInput, Ingredient bottomInput, ItemStack output) {
        this.validate(topInput, bottomInput, output);
        BrewingRecipeRegistry.addRecipe((Ingredient)bottomInput, (Ingredient)topInput, (ItemStack)output);
    }

    @Override
    public void addPotionBrewing(Ingredient ingredient, Potion input, Potion output) {
        this.validateSimple(input, ingredient, output);
        PotionBrewingAccessor.getMixes().add((PotionBrewing.Mix<Potion>)new PotionBrewing.Mix(ForgeRegistries.POTIONS, (Object)input, ingredient, (Object)output));
    }

    @Override
    protected Potion getInputPotionFromMix(PotionBrewing.Mix<Potion> mix) {
        return (Potion)mix.f_43532_.get();
    }

    @Override
    protected Potion getOutputPotionFromMix(PotionBrewing.Mix<Potion> mix) {
        return (Potion)mix.f_43534_.get();
    }

    public void removeByCustom(@Nullable Ingredient topInput, @Nullable Ingredient bottomInput, @Nullable Ingredient output) {
        ListIterator<IBrewingRecipe> it = BrewingRecipeRegistryAccessor.getRecipes().listIterator();
        while (it.hasNext()) {
            boolean matchesOutput;
            IBrewingRecipe recipe = it.next();
            if (!(recipe instanceof BrewingRecipe)) continue;
            BrewingRecipe br = (BrewingRecipe)recipe;
            boolean matchesInput = topInput == null || Utils.matchesIngredient(topInput, br.getIngredient());
            boolean matchesIngredient = bottomInput == null || Utils.matchesIngredient(bottomInput, br.getInput());
            boolean bl = matchesOutput = output == null || output.test(br.getOutput());
            if (!matchesInput || !matchesIngredient || !matchesOutput) continue;
            String s = String.format("Removing custom brewing recipe: [Input: %s][Ingredient: %s][Output: %s]", br.getInput(), br.getIngredient(), br.getOutput());
            ConsoleJS.STARTUP.info((Object)s);
            it.remove();
        }
    }

    public void removeByCustom(Predicate<IBrewingRecipe> predicate) {
        ListIterator<IBrewingRecipe> it = BrewingRecipeRegistryAccessor.getRecipes().listIterator();
        while (it.hasNext()) {
            IBrewingRecipe recipe = it.next();
            if (recipe instanceof BrewingRecipe || recipe instanceof VanillaBrewingRecipe || !predicate.test(recipe)) continue;
            ConsoleJS.STARTUP.info((Object)("Removing custom brewing recipe: " + recipe));
            it.remove();
        }
    }
}

