/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.mixin.villager;

import com.almostreliable.morejs.MoreJS;
import com.almostreliable.morejs.features.villager.OfferExtension;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MerchantOffers.class})
public class MerchantOffersMixin {
    @Inject(method={"createFromStream"}, at={@At(value="RETURN")})
    private static void morejs$createFromStream(FriendlyByteBuf friendlyByteBuf, CallbackInfoReturnable<MerchantOffers> cir) {
        ((MerchantOffers)cir.getReturnValue()).forEach(o -> {
            boolean disabled = friendlyByteBuf.readBoolean();
            ((OfferExtension)o).setDisabled(disabled);
        });
    }

    @Inject(method={"writeToStream"}, at={@At(value="RETURN")})
    private void morejs$writeCustomData(FriendlyByteBuf friendlyByteBuf, CallbackInfo ci) {
        for (MerchantOffer o : this.morejs$getSelf()) {
            friendlyByteBuf.writeBoolean(((OfferExtension)o).isDisabled());
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void morejs$storeDisabled(@Nullable CompoundTag tag, CallbackInfo ci) {
        if (tag == null) {
            return;
        }
        try {
            MerchantOffers offers = this.morejs$getSelf();
            if (!tag.m_128441_("morejs$disabled")) {
                return;
            }
            ListTag list = tag.m_128437_("morejs$disabled", 1);
            if (list.size() != offers.size()) {
                return;
            }
            for (int i = 0; i < offers.size(); ++i) {
                ByteTag bt;
                Tag hopefullyByteTag = list.get(i);
                boolean disabled = hopefullyByteTag instanceof ByteTag && (bt = (ByteTag)hopefullyByteTag).m_7063_() != 0;
                ((OfferExtension)offers.get(i)).setDisabled(disabled);
            }
        }
        catch (Exception e) {
            MoreJS.LOG.warn("Failed to receive disabled offers", (Throwable)e);
        }
    }

    @Inject(method={"createTag"}, at={@At(value="RETURN")})
    private void appendDisabledOnTag(CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        if (tag == null) {
            return;
        }
        try {
            MerchantOffers offers = this.morejs$getSelf();
            ListTag list = new ListTag();
            for (MerchantOffer offer : offers) {
                boolean disabled = ((OfferExtension)offer).isDisabled();
                list.add((Object)ByteTag.m_128273_((boolean)disabled));
            }
            tag.m_128365_("morejs$disabled", (Tag)list);
        }
        catch (Exception e) {
            MoreJS.LOG.warn("Failed to store disabled offers", (Throwable)e);
        }
    }

    private MerchantOffers morejs$getSelf() {
        return (MerchantOffers)this;
    }
}

