/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.mixin.enchanting;

import com.almostreliable.morejs.MoreJS;
import com.almostreliable.morejs.core.Events;
import com.almostreliable.morejs.features.enchantment.EnchantmentMenuExtension;
import com.almostreliable.morejs.features.enchantment.EnchantmentMenuProcess;
import com.almostreliable.morejs.features.enchantment.EnchantmentState;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableChangedJS;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableIsEnchantableEventJS;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableServerEventJS;
import dev.latvian.mods.kubejs.event.EventJS;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentMenu.class}, priority=42)
public abstract class EnchantmentMenuMixin
extends AbstractContainerMenu
implements EnchantmentMenuExtension {
    @Unique
    private EnchantmentMenuProcess morejs$process;
    @Shadow
    @Final
    private Container f_39449_;
    @Shadow
    @Final
    private ContainerLevelAccess f_39450_;
    @Shadow
    @Final
    private RandomSource f_39451_;

    protected EnchantmentMenuMixin(@Nullable MenuType<?> menuType, int i) {
        super(menuType, i);
    }

    @Override
    public EnchantmentMenuProcess getMoreJSProcess() {
        return this.morejs$process;
    }

    @Override
    public Container getMoreJsEnchantSlots() {
        return this.f_39449_;
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="RETURN")})
    private void initializeProcess(int i, Inventory inventory, ContainerLevelAccess containerLevelAccess, CallbackInfo ci) {
        this.morejs$process = new EnchantmentMenuProcess((EnchantmentMenu)this);
        this.morejs$process.setPlayer(inventory.f_35978_);
    }

    @Inject(method={"slotsChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ContainerLevelAccess;execute(Ljava/util/function/BiConsumer;)V")}, cancellable=true)
    private void slotchanged$PrepareChangeEvent(Container container, CallbackInfo ci) {
        this.f_39450_.m_39292_((level, pos) -> {
            ItemStack item = container.m_8020_(0);
            if (this.morejs$process.matchesCurrentItem(item)) {
                ci.cancel();
                return;
            }
            this.morejs$process.prepareEvent(item);
            MoreJS.LOG.warn("<{}> Pre SlotChange: {}", (Object)this.morejs$process.getPlayer(), (Object)item);
        });
    }

    @Redirect(method={"slotsChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEnchantable()Z"))
    private boolean slotChanged$InvokeEnchantableEvent(ItemStack itemStack, Container container) {
        Boolean[] result = new Boolean[1];
        this.f_39450_.m_39292_((level, pos) -> {
            ItemStack secondItem = container.m_8020_(1);
            EnchantmentTableIsEnchantableEventJS e = new EnchantmentTableIsEnchantableEventJS(itemStack, secondItem, (Level)level, (BlockPos)pos, this.morejs$process);
            Events.ENCHANTMENT_TABLE_IS_ENCHANTABLE.post((EventJS)e);
            result[0] = e.getIsEnchantable();
        });
        return this.morejs$process.storeItemIsEnchantable(result[0], itemStack);
    }

    @Inject(method={"slotsChanged"}, at={@At(value="RETURN")})
    private void slotChanged$InvokeChangeEvent(Container container, CallbackInfo ci) {
        if (container != this.f_39449_ || !this.morejs$process.isFreezeBroadcast()) {
            return;
        }
        ItemStack item = container.m_8020_(0);
        this.f_39450_.m_39292_((level, pos) -> {
            ItemStack secondItem = container.m_8020_(1);
            this.morejs$process.setFreezeBroadcast(false);
            this.morejs$process.setState(EnchantmentState.USE_STORED_ENCHANTMENTS);
            MoreJS.LOG.warn("<{}> Post SlotChange: {}", (Object)this.morejs$process.getPlayer(), (Object)item);
            Events.ENCHANTMENT_TABLE_CHANGED.post((EventJS)new EnchantmentTableChangedJS(item, secondItem, (Level)level, (BlockPos)pos, this.morejs$process, this.f_39451_));
        });
        if (item.m_41619_() || !this.morejs$process.isItemEnchantable(item)) {
            this.morejs$process.clearEnchantments();
        }
    }

    @Inject(method={"getEnchantmentList"}, at={@At(value="RETURN")}, cancellable=true)
    private void handleEnchantmentGetter(ItemStack itemStack, int index, int powerLevel, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        switch (this.morejs$process.getState()) {
            case STORE_ENCHANTMENTS: {
                this.morejs$process.setEnchantments(index, (List)cir.getReturnValue());
                break;
            }
            case USE_STORED_ENCHANTMENTS: {
                List<EnchantmentInstance> enchantments = this.morejs$process.getEnchantments(index);
                if (enchantments == null) {
                    MoreJS.LOG.error("Enchantment list is null for index " + index + ", when in state USE_STORED_ENCHANTMENTS");
                    return;
                }
                cir.setReturnValue(enchantments);
            }
        }
    }

    @Inject(method={"clickMenuButton"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ContainerLevelAccess;execute(Ljava/util/function/BiConsumer;)V")}, cancellable=true)
    private void clickMenuButton$InvokeEnchantEvent(Player player, int i, CallbackInfoReturnable<Boolean> cir) {
        this.f_39450_.m_39292_((level, pos) -> {
            ItemStack secondItem;
            if (player != this.morejs$process.getPlayer()) {
                MoreJS.LOG.warn("<{}> Player changed during clickMenuButton", (Object)this.morejs$process.getPlayer());
                return;
            }
            ItemStack item = this.f_39449_.m_8020_(0);
            EnchantmentTableServerEventJS e = new EnchantmentTableServerEventJS(item, secondItem = this.f_39449_.m_8020_(1), (Level)level, (BlockPos)pos, player, this.morejs$process);
            if (Events.ENCHANTMENT_TABLE_ENCHANT.post((EventJS)e).interruptFalse()) {
                cir.setReturnValue((Object)false);
            }
            if (e.itemWasChanged()) {
                cir.setReturnValue((Object)false);
                ItemStack newItem = e.getItem().m_41777_();
                this.morejs$process.abortEvent(newItem);
                this.f_39449_.m_6836_(0, newItem);
            }
        });
    }

    public void m_38946_() {
        if (this.morejs$process.isFreezeBroadcast()) {
            MoreJS.LOG.warn("<{}> Freezing broadcast", (Object)this.morejs$process.getPlayer());
            return;
        }
        super.m_38946_();
    }
}

