/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.core.Events;
import com.almostreliable.morejs.features.villager.events.VillagerTradingEventJS;
import com.almostreliable.morejs.features.villager.events.WandererTradingEventJS;
import dev.latvian.mods.kubejs.event.EventJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public class TradingManager {
    @Nullable
    protected Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> tradesBackup;
    @Nullable
    protected Int2ObjectMap<List<VillagerTrades.ItemListing>> wandererTradesBackup;

    public void invokeVillagerTradeEvent(Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> originalTrades) {
        this.updateVanillaTrades(originalTrades);
        Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> trades = this.createMutableTradesMapByProfessions();
        Events.VILLAGER_TRADING.post((EventJS)new VillagerTradingEventJS(trades));
        this.updateVanillaTrades(trades);
    }

    public void invokeWanderingTradeEvent(Int2ObjectMap<List<VillagerTrades.ItemListing>> originalTrades) {
        this.updateVanillaWanderingTrades(originalTrades);
        Int2ObjectMap<List<VillagerTrades.ItemListing>> wandererTrades = this.toListingsListMap((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.f_35628_);
        Events.WANDERING_TRADING.post((EventJS)new WandererTradingEventJS(wandererTrades));
        this.updateVanillaWanderingTrades(wandererTrades);
    }

    public void reload() {
        this.invokeVillagerTradeEvent(this.getTradesBackup());
        this.invokeWanderingTradeEvent(this.getWandererTradesBackup());
    }

    public Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> getTradesBackup() {
        if (this.tradesBackup == null) {
            this.tradesBackup = this.createMutableTradesMapByProfessions();
        }
        return this.tradesBackup;
    }

    public Int2ObjectMap<List<VillagerTrades.ItemListing>> getWandererTradesBackup() {
        if (this.wandererTradesBackup == null) {
            this.wandererTradesBackup = this.toListingsListMap((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.f_35628_);
        }
        return this.wandererTradesBackup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> createMutableTradesMapByProfessions() {
        Map map = VillagerTrades.f_35627_;
        synchronized (map) {
            HashMap<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> result = new HashMap<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>>();
            VillagerTrades.f_35627_.forEach((profession, trades) -> {
                Int2ObjectMap<List<VillagerTrades.ItemListing>> map = this.toListingsListMap((Int2ObjectMap<VillagerTrades.ItemListing[]>)trades);
                result.put((VillagerProfession)profession, map);
            });
            return result;
        }
    }

    private synchronized Int2ObjectMap<List<VillagerTrades.ItemListing>> toListingsListMap(Int2ObjectMap<VillagerTrades.ItemListing[]> listingsMap) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        listingsMap.forEach((level, listings) -> {
            ArrayList<VillagerTrades.ItemListing> newListings = new ArrayList<VillagerTrades.ItemListing>(Arrays.stream(listings).toList());
            result.put(level.intValue(), newListings);
        });
        return result;
    }

    private synchronized Int2ObjectMap<VillagerTrades.ItemListing[]> toListingsArrayMap(Int2ObjectMap<List<VillagerTrades.ItemListing>> listingsMap) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        listingsMap.forEach((level, listings) -> result.put(level.intValue(), (Object)listings.toArray(new VillagerTrades.ItemListing[0])));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVanillaTrades(Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> trades) {
        Map map = VillagerTrades.f_35627_;
        synchronized (map) {
            VillagerTrades.f_35627_.clear();
            trades.forEach((profession, newTrades) -> {
                Int2ObjectMap<VillagerTrades.ItemListing[]> vanillaTrades = this.toListingsArrayMap((Int2ObjectMap<List<VillagerTrades.ItemListing>>)newTrades);
                VillagerTrades.f_35627_.put(profession, vanillaTrades);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVanillaWanderingTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        Int2ObjectMap int2ObjectMap = VillagerTrades.f_35628_;
        synchronized (int2ObjectMap) {
            VillagerTrades.f_35628_.clear();
            Int2ObjectMap<VillagerTrades.ItemListing[]> map = this.toListingsArrayMap(trades);
            VillagerTrades.f_35628_.putAll(map);
        }
    }
}

