/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem, boolean bothSides) {
        if (!player.m_9236_().f_46443_ || bothSides) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        Utils.swapItem(player, hand, oldItem, newItem, false);
    }

    public static void swapItemNBT(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.m_9236_().f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)false));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack newItem) {
        Utils.swapItem(player, hand, player.m_21120_(hand), newItem);
    }

    public static void addStackToExisting(Player player, ItemStack stack, boolean avoidHands) {
        int j;
        Inventory inv = player.m_150109_();
        boolean added = false;
        for (j = 0; j < inv.f_35974_.size(); ++j) {
            if (!inv.m_8020_(j).m_150930_(stack.m_41720_()) || !inv.m_36040_(j, stack)) continue;
            added = true;
            break;
        }
        if (avoidHands && !added) {
            for (j = 0; j < inv.f_35974_.size(); ++j) {
                if (!inv.m_8020_(j).m_41619_() || j == inv.f_35977_ || !inv.m_36040_(j, stack)) continue;
                added = true;
                break;
            }
        }
        if (!added && inv.m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    public static int getXPinaBottle(int bottleCount, RandomSource rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; ++i) {
            xp += 3 + rand.m_188503_(5) + rand.m_188503_(5);
        }
        return xp;
    }

    public static ResourceLocation getID(Block object) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(EntityType<?> object) {
        return BuiltInRegistries.f_256780_.m_7981_(object);
    }

    public static ResourceLocation getID(Biome object) {
        return Utils.hackyGetRegistry(Registries.f_256952_).m_7981_((Object)object);
    }

    public static ResourceLocation getID(DamageType type) {
        return Utils.hackyGetRegistry(Registries.f_268580_).m_7981_((Object)type);
    }

    public static ResourceLocation getID(ConfiguredFeature<?, ?> object) {
        return Utils.hackyGetRegistry(Registries.f_256911_).m_7981_(object);
    }

    public static ResourceLocation getID(Item object) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(Fluid object) {
        return BuiltInRegistries.f_257020_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(BlockEntityType<?> object) {
        return BuiltInRegistries.f_257049_.m_7981_(object);
    }

    public static ResourceLocation getID(RecipeSerializer<?> object) {
        return BuiltInRegistries.f_256769_.m_7981_(object);
    }

    public static ResourceLocation getID(SoftFluid object) {
        return SoftFluidRegistry.hackyGetRegistry().m_7981_((Object)object);
    }

    public static ResourceLocation getID(MapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().m_7981_(object);
    }

    public static ResourceLocation getID(Potion object) {
        return BuiltInRegistries.f_256980_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(MobEffect object) {
        return BuiltInRegistries.f_256974_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(CreativeModeTab object) {
        return BuiltInRegistries.f_279662_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(Object object) {
        if (object instanceof Block) {
            Block b = (Block)object;
            return Utils.getID(b);
        }
        if (object instanceof Item) {
            Item b = (Item)object;
            return Utils.getID(b);
        }
        if (object instanceof EntityType) {
            EntityType b = (EntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof BlockEntityType) {
            BlockEntityType b = (BlockEntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof Biome) {
            Biome b = (Biome)object;
            return Utils.getID(b);
        }
        if (object instanceof Fluid) {
            Fluid b = (Fluid)object;
            return Utils.getID(b);
        }
        if (object instanceof RecipeSerializer) {
            RecipeSerializer b = (RecipeSerializer)object;
            return Utils.getID(b);
        }
        if (object instanceof ConfiguredFeature) {
            ConfiguredFeature c = (ConfiguredFeature)object;
            return Utils.getID(c);
        }
        if (object instanceof Potion) {
            Potion c = (Potion)object;
            return Utils.getID(c);
        }
        if (object instanceof MobEffect) {
            MobEffect c = (MobEffect)object;
            return Utils.getID(c);
        }
        if (object instanceof Supplier) {
            Supplier s = (Supplier)object;
            return Utils.getID(s.get());
        }
        if (object instanceof SoftFluid) {
            SoftFluid s = (SoftFluid)object;
            return Utils.getID(s);
        }
        if (object instanceof MapDecorationType) {
            MapDecorationType s = (MapDecorationType)object;
            return Utils.getID(s);
        }
        if (object instanceof CreativeModeTab) {
            CreativeModeTab t = (CreativeModeTab)object;
            return Utils.getID(t);
        }
        if (object instanceof DamageType) {
            DamageType t = (DamageType)object;
            return Utils.getID(t);
        }
        throw new UnsupportedOperationException("Unknown class type " + object.getClass());
    }

    public static <T> boolean isTagged(T entry, Registry<T> registry, TagKey<T> tag) {
        return registry.m_203300_(registry.m_7447_(entry)).map(h -> h.m_203656_(tag)).orElse(false);
    }

    public static RegistryAccess hackyGetRegistryAccess() {
        MinecraftServer s = PlatHelper.getCurrentServer();
        if (s != null) {
            return s.m_206579_();
        }
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                return level.m_9598_();
            }
            throw new UnsupportedOperationException("Failed to get registry access: level was null");
        }
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static <T> Registry<T> hackyGetRegistry(ResourceKey<Registry<T>> registry) {
        return Utils.hackyGetRegistryAccess().m_175515_(registry);
    }

    public static BlockBehaviour.Properties copyPropertySafe(Block blockBehaviour) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_60926_((BlockBehaviour)blockBehaviour);
        BlockState state = blockBehaviour.m_49966_();
        p.m_60953_(s -> state.m_60791_());
        p.m_222979_(BlockBehaviour.OffsetType.NONE);
        p.m_60922_((blockState, blockGetter, blockPos, object) -> false);
        p.m_284180_(blockBehaviour.m_284356_());
        return p;
    }

    public static HitResult rayTrace(LivingEntity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return Utils.rayTrace((Entity)entity, world, blockMode, fluidMode, ForgeHelper.getReachDistance(entity));
    }

    public static HitResult rayTrace(Entity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        Vec3 startPos = entity.m_146892_();
        Vec3 ray = entity.m_20252_(1.0f).m_82490_(range);
        Vec3 endPos = startPos.m_82549_(ray);
        ClipContext context = new ClipContext(startPos, endPos, blockMode, fluidMode, entity);
        return world.m_45547_(context);
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name) {
        Utils.awardAdvancement(sp, name, "unlock");
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name, String unlockProp) {
        PlayerAdvancements advancements;
        Advancement advancement = sp.m_20194_().m_129889_().m_136041_(name);
        if (advancement != null && !(advancements = sp.m_8960_()).m_135996_(advancement).m_8193_()) {
            advancements.m_135988_(advancement, unlockProp);
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static BlockState readBlockState(CompoundTag compound, @Nullable Level level) {
        HolderLookup.RegistryLookup holderGetter = level != null ? level.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        return NbtUtils.m_247651_((HolderGetter)holderGetter, (CompoundTag)compound);
    }

    public static <T extends Comparable<T>, A extends Property<T>> BlockState replaceProperty(BlockState from, BlockState to, A property) {
        if (from.m_61138_(property)) {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        return to;
    }

    public static boolean mayBuild(Player player, BlockPos pos) {
        if (player.m_150110_().f_35938_) {
            return true;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return !player.m_36187_(player.m_9236_(), pos, sp.f_8941_.m_9290_());
        }
        return !player.m_36187_(player.m_9236_(), pos, Minecraft.m_91087_().f_91072_.m_105295_());
    }

    public static boolean isMethodImplemented(Class<?> original, Class<?> subclass, String name) {
        Method declaredMethod = Utils.findMethodWithMatchingName(subclass, name);
        Method modMethod = Utils.findMethodWithMatchingName(original, name);
        return declaredMethod != null && modMethod != null && Arrays.equals(declaredMethod.getParameterTypes(), modMethod.getParameterTypes());
    }

    private static Method findMethodWithMatchingName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }
}

