/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidRegistryImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SoftFluidRegistry {
    public static final ResourceKey<Registry<SoftFluid>> KEY = ResourceKey.m_135788_((ResourceLocation)Moonlight.res("soft_fluids"));
    public static final ResourceLocation EMPTY_ID = Moonlight.res("empty");
    private static final Map<Fluid, SoftFluid> FLUID_MAP = new IdentityHashMap<Fluid, SoftFluid>();
    private static final Map<Item, SoftFluid> ITEM_MAP = new IdentityHashMap<Item, SoftFluid>();

    public static SoftFluid getEmpty() {
        return SoftFluidRegistry.get(EMPTY_ID);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidRegistryImpl.init();
    }

    public static Registry<SoftFluid> hackyGetRegistry() {
        return Utils.hackyGetRegistry(KEY);
    }

    public static Registry<SoftFluid> getRegistry(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(KEY);
    }

    public static Collection<SoftFluid> getValues() {
        return SoftFluidRegistry.hackyGetRegistry().m_123024_().toList();
    }

    public static Set<Map.Entry<ResourceKey<SoftFluid>, SoftFluid>> getEntries() {
        return SoftFluidRegistry.hackyGetRegistry().m_6579_();
    }

    public static SoftFluid get(String id) {
        return SoftFluidRegistry.get(new ResourceLocation(id));
    }

    public static SoftFluid get(ResourceLocation id) {
        String namespace = id.m_135827_();
        Registry<SoftFluid> reg = SoftFluidRegistry.hackyGetRegistry();
        SoftFluid r = (SoftFluid)reg.m_7745_(id);
        if (r == null) {
            if (namespace.equals("selene") || namespace.equals("minecraft")) {
                id = Moonlight.res(id.m_135815_());
            }
            if ((r = (SoftFluid)reg.m_7745_(id)) == null) {
                return (SoftFluid)reg.m_7745_(EMPTY_ID);
            }
        }
        return r;
    }

    public static Optional<SoftFluid> getOptional(ResourceLocation id) {
        String namespace = id.m_135827_();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.m_135815_());
        }
        return SoftFluidRegistry.hackyGetRegistry().m_6612_(id);
    }

    public static SoftFluid fromVanillaFluid(Fluid fluid) {
        return FLUID_MAP.getOrDefault(fluid, SoftFluidRegistry.getEmpty());
    }

    @Deprecated(forRemoval=true)
    public static SoftFluid fromForgeFluid(Fluid fluid) {
        return SoftFluidRegistry.fromVanillaFluid(fluid);
    }

    @NotNull
    public static SoftFluid fromItem(Item filledContainerItem) {
        return ITEM_MAP.getOrDefault(filledContainerItem, SoftFluidRegistry.getEmpty());
    }

    private static void populateSlaveMaps() {
        Map<Item, SoftFluid> itemMap = ITEM_MAP;
        itemMap.clear();
        Map<Fluid, SoftFluid> fluidsMap = FLUID_MAP;
        fluidsMap.clear();
        for (SoftFluid s : SoftFluidRegistry.getValues()) {
            if (!PlatHelper.isModLoaded(s.getFromMod())) continue;
            s.getEquivalentFluids().forEach(f -> fluidsMap.put((Fluid)f, s));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.f_42589_ || s != BuiltInSoftFluids.WATER.get()) {
                    itemMap.put((Item)i, s);
                }
            });
        }
    }

    @ApiStatus.Internal
    public static void postInitClient() {
        SoftFluidRegistry.populateSlaveMaps();
    }

    @ApiStatus.Internal
    public static void onDataSyncToPlayer(ServerPlayer player, boolean o) {
        ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
    }

    @ApiStatus.Internal
    public static void onDataLoad() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidRegistry.registerExistingVanillaFluids(FLUID_MAP, ITEM_MAP);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(Map<Fluid, SoftFluid> fluidMap, Map<Item, SoftFluid> itemMap) {
        void var1_1;
        SoftFluidRegistryImpl.registerExistingVanillaFluids(fluidMap, (Map<Item, SoftFluid>)var1_1);
    }
}

